/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.PermissionAccess;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.QSYSPermission;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserPermission;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;

class PermissionAccessQSYS
extends PermissionAccess {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";

    public PermissionAccessQSYS(AS400 aS400) {
        super(aS400);
    }

    public void addUser(String string, UserPermission userPermission) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        CommandCall commandCall = PermissionAccessQSYS.getAddCommand(this.as400_, string, userPermission);
        if (!commandCall.run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            throw new AS400Exception(aS400MessageArray);
        }
    }

    protected final String expandQuotes(String string) {
        return PermissionAccessQSYS.expandQuotes0(string);
    }

    static String expandQuotes0(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.insert(0, '\'');
        stringBuffer.append('\'');
        if (string.indexOf(34) != -1) {
            stringBuffer.insert(0, "''");
            stringBuffer.append("''");
        }
        return stringBuffer.toString();
    }

    private static CommandCall getAddCommand(AS400 aS400, String string, UserPermission userPermission) {
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string);
        String string2 = qSYSObjectPathName.getObjectType();
        boolean bl = string2.equals("AUTL");
        if (!bl) {
            return PermissionAccessQSYS.getChgCommand(aS400, string, userPermission);
        }
        QSYSPermission qSYSPermission = (QSYSPermission)userPermission;
        String string3 = qSYSPermission.getUserID();
        String string4 = qSYSObjectPathName.getObjectName();
        try {
            string4 = CharConverter.convertIFSQSYSPathnameToJobPathname(string4, aS400.getCcsid());
        }
        catch (Exception exception) {
            Trace.log(4, "Unable to convert CL command to correct job CCSID.", (Throwable)exception);
        }
        String string5 = "ADDAUTLE AUTL(" + string4 + ")" + " USER(" + string3 + ")" + " AUT(" + qSYSPermission.getAuthorities(bl) + ")";
        CommandCall commandCall = new CommandCall(aS400, string5);
        return commandCall;
    }

    private static CommandCall getClrCommand(AS400 aS400, String string, UserPermission userPermission) {
        String string2;
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string);
        QSYSPermission qSYSPermission = (QSYSPermission)userPermission;
        String string3 = qSYSPermission.getUserID();
        String string4 = qSYSObjectPathName.getObjectName();
        if (!qSYSObjectPathName.getLibraryName().equals("QSYS")) {
            string4 = qSYSObjectPathName.getLibraryName() + "/" + string4;
        }
        if ((string2 = qSYSObjectPathName.getObjectType()).toUpperCase().equals("MBR")) {
            string2 = "FILE";
        }
        try {
            string4 = CharConverter.convertIFSQSYSPathnameToJobPathname(string4, aS400.getCcsid());
        }
        catch (Exception exception) {
            Trace.log(4, "Unable to convert CL command to correct job CCSID.", (Throwable)exception);
        }
        String string5 = string2.equals("AUTL") ? "CHGAUTLE AUTL(" + string4 + ")" + " USER(" + string3 + ")" + " AUT(*EXCLUDE)" : "GRTOBJAUT OBJ(" + string4 + ")" + " OBJTYPE(*" + string2 + ")" + " USER(" + string3 + ")" + " AUT(*EXCLUDE)";
        CommandCall commandCall = new CommandCall(aS400, string5);
        return commandCall;
    }

    private static CommandCall getChgCommand(AS400 aS400, String string, UserPermission userPermission) {
        String string2;
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string);
        QSYSPermission qSYSPermission = (QSYSPermission)userPermission;
        String string3 = qSYSPermission.getUserID();
        String string4 = qSYSObjectPathName.getObjectName();
        if (!qSYSObjectPathName.getLibraryName().equals("QSYS")) {
            string4 = qSYSObjectPathName.getLibraryName() + "/" + string4;
        }
        if ((string2 = qSYSObjectPathName.getObjectType()).toUpperCase().equals("MBR")) {
            string2 = "FILE";
        }
        boolean bl = string2.equals("AUTL");
        try {
            string4 = CharConverter.convertIFSQSYSPathnameToJobPathname(string4, aS400.getCcsid());
        }
        catch (Exception exception) {
            Trace.log(4, "Unable to convert CL command to correct job CCSID.", (Throwable)exception);
        }
        String string5 = string2.equals("AUTL") ? "CHGAUTLE AUTL(" + string4 + ")" + " USER(" + string3 + ")" + " AUT(" + qSYSPermission.getAuthorities(bl) + ")" : "GRTOBJAUT OBJ(" + string4 + ")" + " OBJTYPE(*" + string2 + ")" + " USER(" + string3 + ")" + " AUT(" + qSYSPermission.getAuthorities(bl) + ")" + " REPLACE(*YES)";
        CommandCall commandCall = new CommandCall(aS400, string5);
        return commandCall;
    }

    private static CommandCall getRmvCommand(AS400 aS400, String string, String string2) {
        Object object;
        String string3;
        QSYSObjectPathName qSYSObjectPathName;
        String string4;
        String string5 = string.toUpperCase();
        String string6 = null;
        int n = string5.indexOf("/QSYS.LIB");
        if (n > 0) {
            string6 = string.substring(0, n);
            string = string.substring(n);
        }
        if ((string4 = (qSYSObjectPathName = new QSYSObjectPathName(string)).getObjectType()).equals("AUTL")) {
            String string7 = qSYSObjectPathName.getObjectName();
            try {
                string7 = CharConverter.convertIFSQSYSPathnameToJobPathname(string7, aS400.getCcsid());
            }
            catch (Exception exception) {
                Trace.log(4, "Unable to convert CL command to correct job CCSID.", (Throwable)exception);
            }
            string3 = "RMVAUTLE AUTL(" + string7 + ")" + " USER(" + string2 + ")";
            boolean bl = false;
        } else if (string4.equals("MBR")) {
            String string8 = string6 != null ? string6 + "/QSYS.LIB/" : "QSYS.LIB/";
            if (!qSYSObjectPathName.getLibraryName().equals("")) {
                string8 = string8 + qSYSObjectPathName.getLibraryName() + ".LIB/";
            }
            string8 = string8 + qSYSObjectPathName.getObjectName() + ".FILE";
            string3 = "CHGAUT OBJ(" + PermissionAccessQSYS.expandQuotes0(string8) + ")" + " USER(" + string2 + ")" + " DTAAUT(*NONE)" + " OBJAUT(*NONE)";
            boolean bl = true;
        } else {
            object = string;
            if (string6 != null) {
                object = string6 + (String)object;
            }
            string3 = "CHGAUT OBJ(" + PermissionAccessQSYS.expandQuotes0((String)object) + ")" + " USER(" + string2 + ")" + " DTAAUT(*NONE)" + " OBJAUT(*NONE)";
            boolean bl = true;
        }
        object = new CommandCall(aS400, string3);
        return object;
    }

    public UserPermission getUserPermission(Record record) throws UnsupportedEncodingException {
        String string = ((String)record.getField("profileName")).trim();
        String string2 = ((String)record.getField("userOrGroup")).trim();
        String string3 = ((String)record.getField("dataAuthority")).trim();
        String string4 = ((String)record.getField("autListMgt")).trim();
        String string5 = ((String)record.getField("objMgt")).trim();
        String string6 = ((String)record.getField("objExistence")).trim();
        String string7 = ((String)record.getField("objAlter")).trim();
        String string8 = ((String)record.getField("objRef")).trim();
        String string9 = ((String)record.getField("reserved1")).trim();
        String string10 = ((String)record.getField("objOperational")).trim();
        String string11 = ((String)record.getField("dataRead")).trim();
        String string12 = ((String)record.getField("dataAdd")).trim();
        String string13 = ((String)record.getField("dataUpdate")).trim();
        String string14 = ((String)record.getField("dataDelete")).trim();
        String string15 = ((String)record.getField("dataExecute")).trim();
        String string16 = ((String)record.getField("reserved2")).trim();
        QSYSPermission qSYSPermission = new QSYSPermission(string);
        qSYSPermission.setGroupIndicator(this.getIntValue(string2));
        qSYSPermission.setAuthorizationListManagement(this.getBooleanValue(string4));
        qSYSPermission.setManagement(this.getBooleanValue(string5));
        qSYSPermission.setExistence(this.getBooleanValue(string6));
        qSYSPermission.setAlter(this.getBooleanValue(string7));
        qSYSPermission.setReference(this.getBooleanValue(string8));
        qSYSPermission.setOperational(this.getBooleanValue(string10));
        qSYSPermission.setRead(this.getBooleanValue(string11));
        qSYSPermission.setAdd(this.getBooleanValue(string12));
        qSYSPermission.setUpdate(this.getBooleanValue(string13));
        qSYSPermission.setDelete(this.getBooleanValue(string14));
        qSYSPermission.setExecute(this.getBooleanValue(string15));
        if (string3.toUpperCase().equals("*AUTL")) {
            qSYSPermission.setFromAuthorizationList(true);
        }
        return qSYSPermission;
    }

    public void removeUser(String string, String string2) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        CommandCall commandCall = PermissionAccessQSYS.getRmvCommand(this.as400_, string, string2);
        if (!commandCall.run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            throw new AS400Exception(aS400MessageArray);
        }
    }

    public synchronized void setAuthority(String string, UserPermission userPermission) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        CommandCall commandCall = PermissionAccessQSYS.getChgCommand(this.as400_, string, userPermission);
        if (!commandCall.run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            throw new AS400Exception(aS400MessageArray);
        }
    }

    public synchronized void setAuthorizationList(String string, String string2, String string3) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        String string4;
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string);
        String string5 = qSYSObjectPathName.getObjectName();
        if (!qSYSObjectPathName.getLibraryName().equals("QSYS")) {
            string5 = qSYSObjectPathName.getLibraryName() + "/" + string5;
        }
        if ((string4 = qSYSObjectPathName.getObjectType()).toUpperCase().trim().equals("MBR")) {
            string4 = "FILE";
        }
        CommandCall commandCall = new CommandCall(this.as400_);
        try {
            string5 = CharConverter.convertIFSQSYSPathnameToJobPathname(string5, this.as400_.getCcsid());
        }
        catch (Exception exception) {
            Trace.log(4, "Unable to convert CL command to correct job CCSID.", (Throwable)exception);
        }
        String string6 = !string3.toUpperCase().equals("*NONE") && string2.toUpperCase().equals("*NONE") ? "RVKOBJAUT OBJ(" + string5 + ")" + " OBJTYPE(*" + string4 + ")" + " AUTL(" + string3 + ")" : "GRTOBJAUT OBJ(" + string5 + ")" + " OBJTYPE(*" + string4 + ")" + " AUTL(" + string2 + ")";
        commandCall.setCommand(string6);
        if (!commandCall.run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            throw new AS400Exception(aS400MessageArray);
        }
    }

    public synchronized void setFromAuthorizationList(String string, boolean bl) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        String string2;
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string);
        String string3 = qSYSObjectPathName.getObjectName();
        if (!qSYSObjectPathName.getLibraryName().equals("QSYS")) {
            string3 = qSYSObjectPathName.getLibraryName() + "/" + string3;
        }
        if ((string2 = qSYSObjectPathName.getObjectType()).toUpperCase().equals("MBR")) {
            string2 = "FILE";
        }
        CommandCall commandCall = new CommandCall(this.as400_);
        try {
            string3 = CharConverter.convertIFSQSYSPathnameToJobPathname(string3, this.as400_.getCcsid());
        }
        catch (Exception exception) {
            Trace.log(4, "Unable to convert CL command to correct job CCSID.", (Throwable)exception);
        }
        String string4 = bl ? "GRTOBJAUT OBJ(" + string3 + ")" + " OBJTYPE(*" + string2 + ")" + " USER(*PUBLIC)" + " AUT(*AUTL)" : "GRTOBJAUT OBJ(" + string3 + ")" + " OBJTYPE(*" + string2 + ")" + " USER(*PUBLIC)" + " AUT(*EXCLUDE)";
        commandCall.setCommand(string4);
        if (!commandCall.run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            throw new AS400Exception(aS400MessageArray);
        }
    }

    public synchronized void setSensitivity(String string, int n) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
    }
}

