/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.mob.MobFileCache;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MobCacheConfig
extends CacheConfig {
    private static MobFileCache mobFileCache;

    public MobCacheConfig(Configuration conf, ColumnFamilyDescriptor family) {
        super(conf, family);
        MobCacheConfig.instantiateMobFileCache(conf);
    }

    public MobCacheConfig(Configuration conf) {
        super(conf);
        MobCacheConfig.instantiateMobFileCache(conf);
    }

    public MobCacheConfig(Configuration conf, boolean needBlockCache) {
        super(conf, needBlockCache);
        MobCacheConfig.instantiateMobFileCache(conf);
    }

    public static synchronized MobFileCache instantiateMobFileCache(Configuration conf) {
        if (mobFileCache == null) {
            mobFileCache = new MobFileCache(conf);
        }
        return mobFileCache;
    }

    public MobFileCache getMobFileCache() {
        return mobFileCache;
    }
}

