/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.oozie.util.XLog;

public class WritableUtils {
    public static XLog LOG = XLog.getLog(WritableUtils.class);
    private static final String NULL = "||";

    public static byte[] toByteArray(Writable writable) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream daos = new DataOutputStream(baos);
            writable.write((DataOutput)daos);
            daos.close();
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T extends Writable> T fromByteArray(byte[] array, Class<T> clazz) {
        try {
            Writable o = (Writable)ReflectionUtils.newInstance(clazz, null);
            o.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(array)));
            return (T)o;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void writeStr(DataOutput dataOutput, String str) throws IOException {
        str = str != null ? str : NULL;
        dataOutput.writeUTF(str);
    }

    public static String readStr(DataInput dataInput) throws IOException {
        String str = dataInput.readUTF();
        return str.equals(NULL) ? null : str;
    }

    public static <T extends Writable> List<T> readList(DataInput dataInput, Class<T> clazz) throws IOException {
        ArrayList<Writable> a = new ArrayList<Writable>();
        int count = dataInput.readInt();
        for (int i = 0; i < count; ++i) {
            Writable o = (Writable)ReflectionUtils.newInstance(clazz, null);
            o.readFields(dataInput);
            a.add(o);
        }
        return a;
    }

    public static List<String> readStringList(DataInput dataInput) throws IOException {
        ArrayList<String> a = new ArrayList<String>();
        int count = dataInput.readInt();
        for (int i = 0; i < count; ++i) {
            a.add(WritableUtils.readBytesAsString(dataInput));
        }
        return a;
    }

    public static <T extends Writable> void writeList(DataOutput dataOutput, List<T> list) throws IOException {
        dataOutput.writeInt(list.size());
        for (Writable t : list) {
            t.write(dataOutput);
        }
    }

    public static void writeStringList(DataOutput dataOutput, List<String> list) throws IOException {
        dataOutput.writeInt(list.size());
        for (String str : list) {
            WritableUtils.writeStringAsBytes(dataOutput, str);
        }
    }

    public static <T extends Writable> void writeMap(DataOutput dataOutput, Map<String, T> map) throws IOException {
        dataOutput.writeInt(map.size());
        for (Map.Entry<String, T> t : map.entrySet()) {
            WritableUtils.writeStringAsBytes(dataOutput, t.getKey());
            ((Writable)t.getValue()).write(dataOutput);
        }
    }

    public static <T extends Writable> void writeMapWithList(DataOutput dataOutput, Map<String, List<T>> map) throws IOException {
        dataOutput.writeInt(map.size());
        for (Map.Entry<String, List<T>> t : map.entrySet()) {
            WritableUtils.writeStringAsBytes(dataOutput, t.getKey());
            WritableUtils.writeList(dataOutput, t.getValue());
        }
    }

    public static <T extends Writable> Map<String, T> readMap(DataInput dataInput, Class<T> clazz) throws IOException {
        HashMap<String, Writable> map = new HashMap<String, Writable>();
        int count = dataInput.readInt();
        for (int i = 0; i < count; ++i) {
            String key = WritableUtils.readBytesAsString(dataInput);
            Writable value = (Writable)ReflectionUtils.newInstance(clazz, null);
            value.readFields(dataInput);
            map.put(key, value);
        }
        return map;
    }

    public static <T extends Writable> Map<String, List<T>> readMapWithList(DataInput dataInput, Class<T> clazz) throws IOException {
        HashMap<String, List<T>> map = new HashMap<String, List<T>>();
        int count = dataInput.readInt();
        for (int i = 0; i < count; ++i) {
            String key = WritableUtils.readBytesAsString(dataInput);
            map.put(key, WritableUtils.readList(dataInput, clazz));
        }
        return map;
    }

    public static void writeStringAsBytes(DataOutput dOut, String value) throws IOException {
        byte[] data = value.getBytes("UTF-8");
        dOut.writeInt(data.length);
        dOut.write(data);
    }

    public static String readBytesAsString(DataInput dIn) throws IOException {
        int length = dIn.readInt();
        byte[] data = new byte[length];
        dIn.readFully(data);
        return new String(data, "UTF-8");
    }
}

