/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.datasource;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLException;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.sql.DataSource;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.datasource.DataSourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HikariCPDataSourceProvider
implements DataSourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(HikariCPDataSourceProvider.class);
    public static final String HIKARI = "hikaricp";
    private static final String CONNECTION_TIMEOUT_PROPERTY = "hikaricp.connectionTimeout";

    @Override
    public DataSource create(Configuration hdpConfig) throws SQLException {
        LOG.debug("Creating Hikari connection pool for the MetaStore");
        String driverUrl = DataSourceProvider.getMetastoreJdbcDriverUrl(hdpConfig);
        String user = DataSourceProvider.getMetastoreJdbcUser(hdpConfig);
        String passwd = DataSourceProvider.getMetastoreJdbcPasswd(hdpConfig);
        int maxPoolSize = HiveConf.getIntVar(hdpConfig, HiveConf.ConfVars.METASTORE_CONNECTION_POOLING_MAX_CONNECTIONS);
        Properties properties = this.replacePrefix(DataSourceProvider.getPrefixedProperties(hdpConfig, HIKARI));
        long connectionTimeout = hdpConfig.getLong(CONNECTION_TIMEOUT_PROPERTY, 30000L);
        HikariConfig config = null;
        try {
            config = new HikariConfig(properties);
        }
        catch (Exception e) {
            throw new SQLException("Cannot create HikariCP configuration: ", e);
        }
        config.setMaximumPoolSize(maxPoolSize);
        config.setJdbcUrl(driverUrl);
        config.setUsername(user);
        config.setPassword(passwd);
        config.setConnectionTimeout(connectionTimeout);
        return new HikariDataSource(config);
    }

    @Override
    public boolean mayReturnClosedConnection() {
        return false;
    }

    @Override
    public boolean supports(Configuration configuration) {
        String poolingType = configuration.get(HiveConf.ConfVars.METASTORE_CONNECTION_POOLING_TYPE.varname);
        return HIKARI.equalsIgnoreCase(poolingType);
    }

    private Properties replacePrefix(Properties props) {
        Properties newProps = new Properties();
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> newProps.put(key.toString().replaceFirst("hikaricp.", ""), value)));
        return newProps;
    }
}

