/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.TaskContext;
import org.slf4j.Logger;

public final class SparkMetricUtils {
    private SparkMetricUtils() {
    }

    public static void updateSparkRecordsWrittenMetrics(long numRows) {
        TaskContext taskContext = TaskContext.get();
        if (taskContext != null && numRows > 0L) {
            taskContext.taskMetrics().outputMetrics().setRecordsWritten(numRows);
        }
    }

    public static void updateSparkBytesWrittenMetrics(Logger log, FileSystem fs, Path[] commitPaths) {
        AtomicLong bytesWritten = new AtomicLong();
        ((Stream)Arrays.stream(commitPaths).parallel()).forEach(path -> {
            try {
                bytesWritten.addAndGet(fs.getFileStatus(path).getLen());
            }
            catch (IOException e) {
                log.debug("Unable to collect stats for file: " + path + " output metrics may be inaccurate", (Throwable)e);
            }
        });
        if (bytesWritten.get() > 0L) {
            TaskContext.get().taskMetrics().outputMetrics().setBytesWritten(bytesWritten.get());
        }
    }
}

