/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Calendar;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hive.common.util.DateUtils;

public abstract class VectorUDFTimestampFieldDate
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    protected int colNum;
    protected int outputColumn;
    protected int field;
    protected final transient Calendar calendar = Calendar.getInstance();

    public VectorUDFTimestampFieldDate(int field, int colNum, int outputColumn) {
        this();
        this.colNum = colNum;
        this.outputColumn = outputColumn;
        this.field = field;
    }

    public VectorUDFTimestampFieldDate() {
    }

    protected long getDateField(long days) {
        this.calendar.setTimeInMillis(DateWritable.daysToMillis((int)days));
        return this.calendar.get(this.field);
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        Preconditions.checkState(this.inputTypes[0] == VectorExpression.Type.DATE);
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumn];
        ColumnVector inputColVec = batch.cols[this.colNum];
        int n = inputColVec.isRepeating ? 1 : batch.size;
        int[] sel = batch.selected;
        boolean selectedInUse = !inputColVec.isRepeating && batch.selectedInUse;
        boolean[] outputIsNull = outputColVector.isNull;
        if (batch.size == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        LongColumnVector longColVector = (LongColumnVector)inputColVec;
        if (inputColVec.isRepeating) {
            if (inputColVec.noNulls || !inputColVec.isNull[0]) {
                outputColVector.isNull[0] = false;
                outputColVector.vector[0] = this.getDateField(longColVector.vector[0]);
            } else {
                outputColVector.isNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (inputColVec.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        outputColVector.vector[i] = this.getDateField(longColVector.vector[i]);
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputColVector.vector[i] = this.getDateField(longColVector.vector[i]);
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    outputColVector.vector[i] = this.getDateField(longColVector.vector[i]);
                }
            }
        } else {
            outputColVector.noNulls = false;
            if (selectedInUse) {
                for (int j = 0; j < n; ++j) {
                    int i = sel[j];
                    outputColVector.isNull[i] = inputColVec.isNull[i];
                    if (inputColVec.isNull[i]) continue;
                    outputColVector.vector[i] = this.getDateField(longColVector.vector[i]);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    outputColVector.isNull[i] = inputColVec.isNull[i];
                    if (inputColVec.isNull[i]) continue;
                    outputColVector.vector[i] = this.getDateField(longColVector.vector[i]);
                }
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public int getField() {
        return this.field;
    }

    public void setField(int field) {
        this.field = field;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public String vectorExpressionParameters() {
        if (this.field == -1) {
            return "col " + this.colNum;
        }
        return "col " + this.colNum + ", field " + DateUtils.getFieldName(this.field);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.DATE).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

