/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.plain;

import java.io.IOException;
import org.apache.parquet.Log;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.CapacityByteArrayOutputStream;
import org.apache.parquet.bytes.LittleEndianDataOutputStream;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.column.values.plain.PlainValuesWriter;
import org.apache.parquet.io.ParquetEncodingException;
import org.apache.parquet.io.api.Binary;

public class FixedLenByteArrayPlainValuesWriter
extends ValuesWriter {
    private static final Log LOG = Log.getLog(PlainValuesWriter.class);
    private CapacityByteArrayOutputStream arrayOut;
    private LittleEndianDataOutputStream out;
    private int length;
    private ByteBufferAllocator allocator;

    public FixedLenByteArrayPlainValuesWriter(int length, int initialSize, int pageSize, ByteBufferAllocator allocator) {
        this.length = length;
        this.allocator = allocator;
        this.arrayOut = new CapacityByteArrayOutputStream(initialSize, pageSize, this.allocator);
        this.out = new LittleEndianDataOutputStream(this.arrayOut);
    }

    @Override
    public final void writeBytes(Binary v) {
        if (v.length() != this.length) {
            throw new IllegalArgumentException("Fixed Binary size " + v.length() + " does not match field type length " + this.length);
        }
        try {
            v.writeTo(this.out);
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write fixed bytes", e);
        }
    }

    @Override
    public long getBufferedSize() {
        return this.arrayOut.size();
    }

    @Override
    public BytesInput getBytes() {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write page", e);
        }
        if (Log.DEBUG) {
            LOG.debug("writing a buffer of size " + this.arrayOut.size());
        }
        return BytesInput.from(this.arrayOut);
    }

    @Override
    public void reset() {
        this.arrayOut.reset();
    }

    @Override
    public void close() {
        this.arrayOut.close();
    }

    @Override
    public long getAllocatedSize() {
        return this.arrayOut.getCapacity();
    }

    @Override
    public Encoding getEncoding() {
        return Encoding.PLAIN;
    }

    @Override
    public String memUsageString(String prefix) {
        return this.arrayOut.memUsageString(prefix + " PLAIN");
    }
}

