/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.CapacitySchedulerPreemptionContext;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.IntraQueueCandidatesSelector;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.IntraQueuePreemptionComputePlugin;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TempAppPerPartition;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TempQueuePerPartition;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TempUserPerPartition;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class FifoIntraQueuePreemptionPlugin
implements IntraQueuePreemptionComputePlugin {
    protected final CapacitySchedulerPreemptionContext context;
    protected final ResourceCalculator rc;
    private static final Log LOG = LogFactory.getLog(FifoIntraQueuePreemptionPlugin.class);

    public FifoIntraQueuePreemptionPlugin(ResourceCalculator rc, CapacitySchedulerPreemptionContext preemptionContext) {
        this.context = preemptionContext;
        this.rc = rc;
    }

    @Override
    public Collection<FiCaSchedulerApp> getPreemptableApps(String queueName, String partition) {
        TempQueuePerPartition tq = this.context.getQueueByPartition(queueName, partition);
        ArrayList<FiCaSchedulerApp> apps = new ArrayList<FiCaSchedulerApp>();
        for (TempAppPerPartition tmpApp : tq.getApps()) {
            if (Resources.equals((Resource)tmpApp.getActuallyToBePreempted(), (Resource)Resources.none())) continue;
            apps.add(tmpApp.app);
        }
        return apps;
    }

    @Override
    public Map<String, Resource> getResourceDemandFromAppsPerQueue(String queueName, String partition) {
        HashMap<String, Resource> resToObtainByPartition = new HashMap<String, Resource>();
        TempQueuePerPartition tq = this.context.getQueueByPartition(queueName, partition);
        Collection<TempAppPerPartition> appsOrderedByPriority = tq.getApps();
        Resource actualPreemptNeeded = (Resource)resToObtainByPartition.get(partition);
        if (actualPreemptNeeded == null) {
            actualPreemptNeeded = Resources.createResource((int)0, (int)0);
            resToObtainByPartition.put(partition, actualPreemptNeeded);
        }
        for (TempAppPerPartition a1 : appsOrderedByPriority) {
            Resources.addTo((Resource)actualPreemptNeeded, (Resource)a1.getActuallyToBePreempted());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Selected to preempt " + actualPreemptNeeded + " resource from partition:" + partition));
        }
        return resToObtainByPartition;
    }

    @Override
    public void computeAppsIdealAllocation(Resource clusterResource, TempQueuePerPartition tq, Map<ApplicationAttemptId, Set<RMContainer>> selectedCandidates, Resource totalPreemptedResourceAllowed, Resource queueReassignableResource, float maxAllowablePreemptLimit) {
        HashMap<String, Resource> perUserAMUsed = new HashMap<String, Resource>();
        Resource amUsed = this.calculateUsedAMResourcesPerQueue(tq.partition, tq.leafQueue, perUserAMUsed);
        Resources.subtractFrom((Resource)queueReassignableResource, (Resource)amUsed);
        Collection<FiCaSchedulerApp> apps = tq.leafQueue.getAllApplications();
        if (apps.size() == 1) {
            return;
        }
        PriorityQueue<TempAppPerPartition> orderedByPriority = this.createTempAppForResCalculation(tq, apps, clusterResource, perUserAMUsed);
        TreeSet<TempAppPerPartition> orderedApps = this.calculateIdealAssignedResourcePerApp(clusterResource, tq, selectedCandidates, queueReassignableResource, orderedByPriority);
        Resource maxIntraQueuePreemptable = Resources.multiply((Resource)tq.getGuaranteed(), (double)maxAllowablePreemptLimit);
        if (Resources.greaterThan((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)maxIntraQueuePreemptable, (Resource)tq.getActuallyToBePreempted())) {
            Resources.subtractFrom((Resource)maxIntraQueuePreemptable, (Resource)tq.getActuallyToBePreempted());
        } else {
            maxIntraQueuePreemptable = Resource.newInstance((int)0, (int)0);
        }
        Resource preemptionLimit = Resources.min((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)maxIntraQueuePreemptable, (Resource)totalPreemptedResourceAllowed);
        this.calculateToBePreemptedResourcePerApp(clusterResource, orderedApps, Resources.clone((Resource)preemptionLimit));
        tq.addAllApps(orderedApps);
        this.validateOutSameAppPriorityFromDemand(clusterResource, orderedApps, tq.getUsersPerPartition(), this.context.getIntraQueuePreemptionOrderPolicy());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Queue Name:" + tq.queueName + ", partition:" + tq.partition));
            for (TempAppPerPartition tmpApp : tq.getApps()) {
                LOG.debug((Object)tmpApp);
            }
        }
    }

    private void calculateToBePreemptedResourcePerApp(Resource clusterResource, TreeSet<TempAppPerPartition> orderedApps, Resource preemptionLimit) {
        for (TempAppPerPartition tmpApp : orderedApps) {
            if (Resources.lessThanOrEqual((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)preemptionLimit, (Resource)Resources.none()) || Resources.lessThanOrEqual((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)tmpApp.getUsed(), (Resource)Resources.none())) continue;
            Resource preemtableFromApp = Resources.subtract((Resource)tmpApp.getUsed(), (Resource)tmpApp.idealAssigned);
            Resources.subtractFromNonNegative((Resource)preemtableFromApp, (Resource)tmpApp.selected);
            Resources.subtractFromNonNegative((Resource)preemtableFromApp, (Resource)tmpApp.getAMUsed());
            if (this.context.getIntraQueuePreemptionOrderPolicy().equals((Object)ProportionalCapacityPreemptionPolicy.IntraQueuePreemptionOrderPolicy.USERLIMIT_FIRST)) {
                Resources.subtractFromNonNegative((Resource)preemtableFromApp, (Resource)tmpApp.getFiCaSchedulerApp().getCSLeafQueue().getMinimumAllocation());
            }
            tmpApp.toBePreempted = Resources.min((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)Resources.max((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)preemtableFromApp, (Resource)Resources.none()), (Resource)Resources.clone((Resource)preemptionLimit));
            preemptionLimit = Resources.subtractFromNonNegative((Resource)preemptionLimit, (Resource)tmpApp.toBePreempted);
        }
    }

    private TreeSet<TempAppPerPartition> calculateIdealAssignedResourcePerApp(Resource clusterResource, TempQueuePerPartition tq, Map<ApplicationAttemptId, Set<RMContainer>> selectedCandidates, Resource queueReassignableResource, PriorityQueue<TempAppPerPartition> orderedByPriority) {
        Comparator<TempAppPerPartition> reverseComp = Collections.reverseOrder(new IntraQueueCandidatesSelector.TAPriorityComparator());
        TreeSet<TempAppPerPartition> orderedApps = new TreeSet<TempAppPerPartition>(reverseComp);
        String partition = tq.partition;
        Map<String, TempUserPerPartition> usersPerPartition = tq.getUsersPerPartition();
        while (!orderedByPriority.isEmpty()) {
            TempAppPerPartition tmpApp = (TempAppPerPartition)orderedByPriority.remove();
            orderedApps.add(tmpApp);
            if (Resources.lessThanOrEqual((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)queueReassignableResource, (Resource)Resources.none()) || Resources.isAnyMajorResourceZero((ResourceCalculator)this.rc, (Resource)queueReassignableResource)) continue;
            String userName = tmpApp.app.getUser();
            TempUserPerPartition tmpUser = usersPerPartition.get(userName);
            Resource userLimitResource = tmpUser.getUserLimit();
            Resource idealAssignedForUser = tmpUser.idealAssigned;
            this.getAlreadySelectedPreemptionCandidatesResource(selectedCandidates, tmpApp, tmpUser, partition);
            Resource appIdealAssigned = Resources.add((Resource)tmpApp.getUsedDeductAM(), (Resource)tmpApp.getPending());
            Resources.subtractFrom((Resource)appIdealAssigned, (Resource)tmpApp.selected);
            if (!Resources.lessThan((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)idealAssignedForUser, (Resource)userLimitResource)) continue;
            Resource idealAssigned = Resources.min((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)appIdealAssigned, (Resource)Resources.subtract((Resource)userLimitResource, (Resource)idealAssignedForUser));
            tmpApp.idealAssigned = Resources.clone((Resource)Resources.min((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)queueReassignableResource, (Resource)idealAssigned));
            Resources.addTo((Resource)idealAssignedForUser, (Resource)tmpApp.idealAssigned);
            Resource appUsedExcludedSelected = Resources.subtract((Resource)tmpApp.getUsedDeductAM(), (Resource)tmpApp.selected);
            if (Resources.greaterThan((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)tmpApp.idealAssigned, (Resource)appUsedExcludedSelected)) {
                tmpApp.setToBePreemptFromOther(Resources.subtract((Resource)tmpApp.idealAssigned, (Resource)appUsedExcludedSelected));
            }
            Resources.subtractFromNonNegative((Resource)queueReassignableResource, (Resource)tmpApp.idealAssigned);
        }
        return orderedApps;
    }

    private void getAlreadySelectedPreemptionCandidatesResource(Map<ApplicationAttemptId, Set<RMContainer>> selectedCandidates, TempAppPerPartition tmpApp, TempUserPerPartition tmpUser, String partition) {
        tmpApp.selected = Resources.createResource((int)0, (int)0);
        Set<RMContainer> containers = selectedCandidates.get(tmpApp.app.getApplicationAttemptId());
        if (containers == null) {
            return;
        }
        for (RMContainer cont : containers) {
            if (!partition.equals(cont.getNodeLabelExpression())) continue;
            Resources.addTo((Resource)tmpApp.selected, (Resource)cont.getAllocatedResource());
            Resources.addTo((Resource)tmpUser.selected, (Resource)cont.getAllocatedResource());
        }
    }

    private PriorityQueue<TempAppPerPartition> createTempAppForResCalculation(TempQueuePerPartition tq, Collection<FiCaSchedulerApp> apps, Resource clusterResource, Map<String, Resource> perUserAMUsed) {
        IntraQueueCandidatesSelector.TAPriorityComparator taComparator = new IntraQueueCandidatesSelector.TAPriorityComparator();
        PriorityQueue<TempAppPerPartition> orderedByPriority = new PriorityQueue<TempAppPerPartition>(100, taComparator);
        String partition = tq.partition;
        Map<String, TempUserPerPartition> usersPerPartition = tq.getUsersPerPartition();
        for (FiCaSchedulerApp app : apps) {
            Resource used = app.getAppAttemptResourceUsage().getUsed(partition);
            Resource amUsed = null;
            if (!app.isWaitingForAMContainer()) {
                amUsed = app.getAMResource(partition);
            }
            Resource pending = app.getTotalPendingRequestsPerPartition().get(partition);
            Resource reserved = app.getAppAttemptResourceUsage().getReserved(partition);
            used = used == null ? Resources.createResource((int)0, (int)0) : used;
            amUsed = amUsed == null ? Resources.createResource((int)0, (int)0) : amUsed;
            pending = pending == null ? Resources.createResource((int)0, (int)0) : pending;
            reserved = reserved == null ? Resources.createResource((int)0, (int)0) : reserved;
            HashSet<String> partitions = new HashSet<String>(app.getAppAttemptResourceUsage().getNodePartitionsSet());
            partitions.addAll(app.getTotalPendingRequestsPerPartition().keySet());
            TempAppPerPartition tmpApp = new TempAppPerPartition(app, Resources.clone((Resource)used), Resources.clone((Resource)amUsed), Resources.clone((Resource)reserved), Resources.clone((Resource)pending));
            tmpApp.idealAssigned = Resources.createResource((int)0, (int)0);
            orderedByPriority.add(tmpApp);
            String userName = app.getUser();
            if (usersPerPartition.containsKey(userName)) continue;
            ResourceUsage userResourceUsage = tq.leafQueue.getUser(userName).getResourceUsage();
            Resource userSpecificAmUsed = perUserAMUsed.get(userName);
            amUsed = userSpecificAmUsed == null ? Resources.none() : userSpecificAmUsed;
            TempUserPerPartition tmpUser = new TempUserPerPartition(tq.leafQueue.getUser(userName), tq.queueName, Resources.clone((Resource)userResourceUsage.getUsed(partition)), Resources.clone((Resource)userSpecificAmUsed), Resources.clone((Resource)userResourceUsage.getReserved(partition)), Resources.none());
            Resource userLimitResource = Resources.clone((Resource)tq.leafQueue.getResourceLimitForAllUsers(userName, clusterResource, partition, SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY));
            userLimitResource = Resources.subtract((Resource)userLimitResource, (Resource)tmpUser.amUsed);
            tmpUser.setUserLimit(userLimitResource);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("TempUser:" + tmpUser));
            }
            tmpUser.idealAssigned = Resources.createResource((int)0, (int)0);
            tq.addUserPerPartition(userName, tmpUser);
        }
        return orderedByPriority;
    }

    public void validateOutSameAppPriorityFromDemand(Resource cluster, TreeSet<TempAppPerPartition> orderedApps, Map<String, TempUserPerPartition> usersPerPartition, ProportionalCapacityPreemptionPolicy.IntraQueuePreemptionOrderPolicy intraQueuePreemptionOrder) {
        TempAppPerPartition[] apps = orderedApps.toArray(new TempAppPerPartition[orderedApps.size()]);
        if (apps.length <= 0) {
            return;
        }
        for (int hPriority = apps.length - 1; hPriority >= 0; --hPriority) {
            if (!Resources.greaterThan((ResourceCalculator)this.rc, (Resource)cluster, (Resource)apps[hPriority].getToBePreemptFromOther(), (Resource)Resources.none())) continue;
            for (int lPriority = 0; lPriority < apps.length; ++lPriority) {
                if (!Resources.greaterThan((ResourceCalculator)this.rc, (Resource)cluster, (Resource)apps[lPriority].toBePreempted, (Resource)Resources.none()) || apps[hPriority].getUser().equals(apps[lPriority].getUser()) && apps[lPriority].getPriority() >= apps[hPriority].getPriority() || Resources.lessThanOrEqual((ResourceCalculator)this.rc, (Resource)cluster, (Resource)apps[lPriority].toBePreempted, (Resource)apps[lPriority].getActuallyToBePreempted()) || Resources.equals((Resource)apps[hPriority].getToBePreemptFromOther(), (Resource)Resources.none())) continue;
                TempUserPerPartition tmpUser = usersPerPartition.get(apps[lPriority].getUser());
                if (!apps[hPriority].getUser().equals(apps[lPriority].getUser()) && !tmpUser.isUserLimitReached(this.rc, cluster) && intraQueuePreemptionOrder.equals((Object)ProportionalCapacityPreemptionPolicy.IntraQueuePreemptionOrderPolicy.USERLIMIT_FIRST)) continue;
                Resource toPreemptFromOther = apps[hPriority].getToBePreemptFromOther();
                Resource actuallyToPreempt = apps[lPriority].getActuallyToBePreempted();
                Resource preemptableFromLowerPriorityApp = Resources.subtract((Resource)apps[lPriority].toBePreempted, (Resource)actuallyToPreempt);
                if (!apps[hPriority].getUser().equals(apps[lPriority].getUser()) && apps[lPriority].getPriority() == apps[hPriority].getPriority() && tmpUser.isUserLimitReached(this.rc, cluster)) {
                    Resource deltaULQuota = Resources.subtract((Resource)tmpUser.getUsedDeductAM(), (Resource)tmpUser.selected);
                    Resources.subtractFrom((Resource)deltaULQuota, (Resource)tmpUser.getUserLimit());
                    if (tmpUser.isPreemptionQuotaForULDeltaDone()) {
                        deltaULQuota = Resources.createResource((int)0, (int)0);
                    }
                    if (Resources.lessThan((ResourceCalculator)this.rc, (Resource)cluster, (Resource)deltaULQuota, (Resource)preemptableFromLowerPriorityApp)) {
                        tmpUser.updatePreemptionQuotaForULDeltaAsDone(true);
                        preemptableFromLowerPriorityApp = deltaULQuota;
                    }
                }
                if (!Resources.greaterThan((ResourceCalculator)this.rc, (Resource)cluster, (Resource)preemptableFromLowerPriorityApp, (Resource)Resources.none())) continue;
                Resource toPreempt = Resources.min((ResourceCalculator)this.rc, (Resource)cluster, (Resource)toPreemptFromOther, (Resource)preemptableFromLowerPriorityApp);
                apps[hPriority].setToBePreemptFromOther(Resources.subtract((Resource)toPreemptFromOther, (Resource)toPreempt));
                apps[lPriority].setActuallyToBePreempted(Resources.add((Resource)actuallyToPreempt, (Resource)toPreempt));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource calculateUsedAMResourcesPerQueue(String partition, LeafQueue leafQueue, Map<String, Resource> perUserAMUsed) {
        Collection<FiCaSchedulerApp> runningApps = leafQueue.getApplications();
        Resource amUsed = Resources.createResource((int)0, (int)0);
        LeafQueue leafQueue2 = leafQueue;
        synchronized (leafQueue2) {
            for (FiCaSchedulerApp app : runningApps) {
                Resource userAMResource = perUserAMUsed.get(app.getUser());
                if (null == userAMResource) {
                    userAMResource = Resources.createResource((int)0, (int)0);
                    perUserAMUsed.put(app.getUser(), userAMResource);
                }
                Resources.addTo((Resource)userAMResource, (Resource)app.getAMResource(partition));
                Resources.addTo((Resource)amUsed, (Resource)app.getAMResource(partition));
            }
        }
        return amUsed;
    }

    @Override
    public boolean skipContainerBasedOnIntraQueuePolicy(FiCaSchedulerApp app, Resource clusterResource, Resource usedResource, RMContainer c) {
        String partition = ((FiCaSchedulerNode)this.context.getScheduler().getSchedulerNode(c.getAllocatedNode())).getPartition();
        TempQueuePerPartition tq = this.context.getQueueByPartition(app.getQueueName(), partition);
        TempUserPerPartition tmpUser = tq.getUsersPerPartition().get(app.getUser());
        if (tmpUser == null) {
            return false;
        }
        Resource userLimit = Resources.add((Resource)tmpUser.getUserLimit(), (Resource)tmpUser.amUsed);
        return Resources.lessThanOrEqual((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)Resources.subtract((Resource)usedResource, (Resource)c.getAllocatedResource()), (Resource)userLimit) && this.context.getIntraQueuePreemptionOrderPolicy().equals((Object)ProportionalCapacityPreemptionPolicy.IntraQueuePreemptionOrderPolicy.USERLIMIT_FIRST);
    }
}

