/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.bitmap;

import java.io.IOException;
import java.io.InputStream;

public class GDIPalette {
    private int noColors;
    private int[] colors;

    public void setNoOfColors(int colors) {
        this.noColors = colors;
    }

    public void setNoOfImportantColors(int colors) {
        if (colors > this.noColors) {
            throw new IllegalArgumentException("There may be not more important colors than colors defined in the palette.");
        }
    }

    public void readPalette(InputStream in) throws IOException {
        this.colors = new int[this.noColors];
        for (int i = 0; i < this.noColors; ++i) {
            this.colors[i] = this.readNextColor(in);
        }
    }

    private int readNextColor(InputStream in) throws IOException {
        int b = in.read();
        int g = in.read();
        int r = in.read();
        in.read();
        return b + (g << 8) + (r << 16);
    }

    public int lookupColor(int color) {
        if (this.noColors == 0) {
            int b = (color & 0xFF0000) >> 16;
            int g = color & 0xFF00;
            int r = color & 0xFF;
            return b + g + (r << 16);
        }
        return this.colors[color];
    }
}

