/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ant;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.hive.ant.GenVectorCode;

public class GenVectorTestCode {
    private final String testOutputDir;
    private final String testTemplateDirectory;
    private final HashMap<TestSuiteClassName, StringBuilder> testsuites;

    public GenVectorTestCode(String testOutputDir, String testTemplateDirectory) {
        this.testOutputDir = testOutputDir;
        this.testTemplateDirectory = testTemplateDirectory;
        this.testsuites = new HashMap();
        for (TestSuiteClassName className : TestSuiteClassName.values()) {
            this.testsuites.put(className, new StringBuilder());
        }
    }

    public void addColumnScalarOperationCheckedTestCases(boolean op1IsCol, String vectorExpClassName, String inputColumnVectorType, String outputColumnVectorType, String scalarType, boolean isReturnTypeLong) throws IOException {
        TestSuiteClassName template = TestSuiteClassName.TestColumnScalarOperationVectorExpressionCheckedEvaluation;
        String templateFile = GenVectorCode.joinPath(this.testTemplateDirectory, template.toString() + ".txt");
        String templateString = GenVectorTestCode.removeTemplateComments(GenVectorCode.readFile(templateFile));
        String[] outputTypeInfos = null;
        outputTypeInfos = isReturnTypeLong ? new String[]{"tinyint", "smallint", "int", "bigint"} : new String[]{"float", "double"};
        for (String outputTypeInfo : outputTypeInfos) {
            for (Boolean[] testMatrix : new Boolean[][]{{false, true, true, true}, {false, false, false, false}, {true, false, true, false}, {true, true, false, false}, {true, false, false, true}}) {
                String testCase = templateString;
                testCase = testCase.replaceAll("<TestName>", "test" + vectorExpClassName + GenVectorTestCode.createNullRepeatingNameFragment("Out", testMatrix[0], testMatrix[1]) + GenVectorTestCode.createNullRepeatingNameFragment("Col", testMatrix[2], testMatrix[3]) + GenVectorTestCode.createOutputTypeInfoFragment("Ret", outputTypeInfo));
                testCase = testCase.replaceAll("<OutputTypeInfo>", outputTypeInfo);
                testCase = testCase.replaceAll("<VectorExpClassName>", vectorExpClassName);
                testCase = testCase.replaceAll("<InputColumnVectorType>", inputColumnVectorType);
                testCase = testCase.replaceAll("<OutputColumnVectorType>", outputColumnVectorType);
                testCase = testCase.replaceAll("<ScalarType>", scalarType);
                testCase = testCase.replaceAll("<CamelCaseScalarType>", GenVectorCode.getCamelCaseType(scalarType));
                testCase = testCase.replaceAll("<InitOuputColHasNulls>", testMatrix[0].toString());
                testCase = testCase.replaceAll("<InitOuputColIsRepeating>", testMatrix[1].toString());
                testCase = testCase.replaceAll("<ColumnHasNulls>", testMatrix[2].toString());
                testCase = testCase.replaceAll("<ColumnIsRepeating>", testMatrix[3].toString());
                testCase = op1IsCol ? testCase.replaceAll("<ConstructorParams>", "0, scalarValue") : testCase.replaceAll("<ConstructorParams>", "scalarValue, 0");
                this.testsuites.get((Object)template).append(testCase);
            }
        }
    }

    public void addColumnScalarOperationTestCases(boolean op1IsCol, String vectorExpClassName, String inputColumnVectorType, String outputColumnVectorType, String scalarType) throws IOException {
        TestSuiteClassName template = TestSuiteClassName.TestColumnScalarOperationVectorExpressionEvaluation;
        String templateFile = GenVectorCode.joinPath(this.testTemplateDirectory, template.toString() + ".txt");
        String templateString = GenVectorTestCode.removeTemplateComments(GenVectorCode.readFile(templateFile));
        for (Boolean[] testMatrix : new Boolean[][]{{false, true, true, true}, {false, false, false, false}, {true, false, true, false}, {true, true, false, false}, {true, false, false, true}}) {
            String testCase = templateString;
            testCase = testCase.replaceAll("<TestName>", "test" + vectorExpClassName + GenVectorTestCode.createNullRepeatingNameFragment("Out", testMatrix[0], testMatrix[1]) + GenVectorTestCode.createNullRepeatingNameFragment("Col", testMatrix[2], testMatrix[3]));
            testCase = testCase.replaceAll("<VectorExpClassName>", vectorExpClassName);
            testCase = testCase.replaceAll("<InputColumnVectorType>", inputColumnVectorType);
            testCase = testCase.replaceAll("<OutputColumnVectorType>", outputColumnVectorType);
            testCase = testCase.replaceAll("<ScalarType>", scalarType);
            testCase = testCase.replaceAll("<CamelCaseScalarType>", GenVectorCode.getCamelCaseType(scalarType));
            testCase = testCase.replaceAll("<InitOuputColHasNulls>", testMatrix[0].toString());
            testCase = testCase.replaceAll("<InitOuputColIsRepeating>", testMatrix[1].toString());
            testCase = testCase.replaceAll("<ColumnHasNulls>", testMatrix[2].toString());
            testCase = testCase.replaceAll("<ColumnIsRepeating>", testMatrix[3].toString());
            testCase = op1IsCol ? testCase.replaceAll("<ConstructorParams>", "0, scalarValue") : testCase.replaceAll("<ConstructorParams>", "scalarValue, 0");
            this.testsuites.get((Object)template).append(testCase);
        }
    }

    public void addColumnScalarFilterTestCases(boolean op1IsCol, String vectorExpClassName, String inputColumnVectorType, String scalarType, String operatorSymbol) throws IOException {
        TestSuiteClassName template = TestSuiteClassName.TestColumnScalarFilterVectorExpressionEvaluation;
        String templateFile = GenVectorCode.joinPath(this.testTemplateDirectory, template.toString() + ".txt");
        String templateString = GenVectorTestCode.removeTemplateComments(GenVectorCode.readFile(templateFile));
        for (Boolean[] testMatrix : new Boolean[][]{{true, true}, {true, false}, {false, false}, {false, true}}) {
            String testCase = templateString;
            testCase = testCase.replaceAll("<TestName>", "test" + vectorExpClassName + GenVectorTestCode.createNullRepeatingNameFragment("Col", testMatrix[0], testMatrix[1]));
            testCase = testCase.replaceAll("<VectorExpClassName>", vectorExpClassName);
            testCase = testCase.replaceAll("<InputColumnVectorType>", inputColumnVectorType);
            testCase = testCase.replaceAll("<ScalarType>", scalarType);
            testCase = testCase.replaceAll("<CamelCaseScalarType>", GenVectorCode.getCamelCaseType(scalarType));
            testCase = testCase.replaceAll("<ColumnHasNulls>", testMatrix[0].toString());
            testCase = testCase.replaceAll("<ColumnIsRepeating>", testMatrix[1].toString());
            testCase = testCase.replaceAll("<Operator>", operatorSymbol);
            if (op1IsCol) {
                testCase = testCase.replaceAll("<Operand1>", "inputColumnVector.vector[i]");
                testCase = testCase.replaceAll("<Operand2>", "scalarValue");
                testCase = testCase.replaceAll("<ConstructorParams>", "0, scalarValue");
            } else {
                testCase = testCase.replaceAll("<Operand1>", "scalarValue");
                testCase = testCase.replaceAll("<Operand2>", "inputColumnVector.vector[i]");
                testCase = testCase.replaceAll("<ConstructorParams>", "scalarValue, 0");
            }
            this.testsuites.get((Object)template).append(testCase);
        }
    }

    public void addColumnColumnOperationCheckedTestCases(String vectorExpClassName, String inputColumnVectorType1, String inputColumnVectorType2, String outputColumnVectorType, boolean isReturnTypeLong) throws IOException {
        TestSuiteClassName template = TestSuiteClassName.TestColumnColumnOperationVectorExpressionCheckedEvaluation;
        String templateFile = GenVectorCode.joinPath(this.testTemplateDirectory, template.toString() + ".txt");
        String templateString = GenVectorTestCode.removeTemplateComments(GenVectorCode.readFile(templateFile));
        String[] outputTypeInfos = null;
        outputTypeInfos = isReturnTypeLong ? new String[]{"tinyint", "smallint", "int", "bigint"} : new String[]{"float", "double"};
        for (String outputTypeInfo : outputTypeInfos) {
            for (Boolean[] testMatrix : new Boolean[][]{{true, true, false, true, true, true}, {false, false, true, false, false, false}, {true, false, true, false, true, true}, {true, true, true, true, false, false}, {false, false, false, true, true, false}, {false, true, false, false, false, true}}) {
                String testCase = templateString;
                testCase = testCase.replaceAll("<TestName>", "test" + vectorExpClassName + GenVectorTestCode.createNullRepeatingNameFragment("Out", testMatrix[0], testMatrix[1]) + GenVectorTestCode.createNullRepeatingNameFragment("C1", testMatrix[2], testMatrix[3]) + GenVectorTestCode.createNullRepeatingNameFragment("C2", testMatrix[4], testMatrix[5]) + GenVectorTestCode.createOutputTypeInfoFragment("Ret", outputTypeInfo));
                testCase = testCase.replaceAll("<VectorExpClassName>", vectorExpClassName);
                testCase = testCase.replaceAll("<InputColumnVectorType1>", inputColumnVectorType1);
                testCase = testCase.replaceAll("<InputColumnVectorType2>", inputColumnVectorType2);
                testCase = testCase.replaceAll("<OutputColumnVectorType>", outputColumnVectorType);
                testCase = testCase.replaceAll("<InitOuputColHasNulls>", testMatrix[0].toString());
                testCase = testCase.replaceAll("<InitOuputColIsRepeating>", testMatrix[1].toString());
                testCase = testCase.replaceAll("<Column1HasNulls>", testMatrix[2].toString());
                testCase = testCase.replaceAll("<Column1IsRepeating>", testMatrix[3].toString());
                testCase = testCase.replaceAll("<Column2HasNulls>", testMatrix[4].toString());
                testCase = testCase.replaceAll("<Column2IsRepeating>", testMatrix[5].toString());
                testCase = testCase.replaceAll("<OutputTypeInfo>", outputTypeInfo);
                this.testsuites.get((Object)template).append(testCase);
            }
        }
    }

    public void addColumnColumnOperationTestCases(String vectorExpClassName, String inputColumnVectorType1, String inputColumnVectorType2, String outputColumnVectorType) throws IOException {
        TestSuiteClassName template = TestSuiteClassName.TestColumnColumnOperationVectorExpressionEvaluation;
        String templateFile = GenVectorCode.joinPath(this.testTemplateDirectory, template.toString() + ".txt");
        String templateString = GenVectorTestCode.removeTemplateComments(GenVectorCode.readFile(templateFile));
        for (Boolean[] testMatrix : new Boolean[][]{{true, true, false, true, true, true}, {false, false, true, false, false, false}, {true, false, true, false, true, true}, {true, true, true, true, false, false}, {false, false, false, true, true, false}, {false, true, false, false, false, true}}) {
            String testCase = templateString;
            testCase = testCase.replaceAll("<TestName>", "test" + vectorExpClassName + GenVectorTestCode.createNullRepeatingNameFragment("Out", testMatrix[0], testMatrix[1]) + GenVectorTestCode.createNullRepeatingNameFragment("C1", testMatrix[2], testMatrix[3]) + GenVectorTestCode.createNullRepeatingNameFragment("C2", testMatrix[4], testMatrix[5]));
            testCase = testCase.replaceAll("<VectorExpClassName>", vectorExpClassName);
            testCase = testCase.replaceAll("<InputColumnVectorType1>", inputColumnVectorType1);
            testCase = testCase.replaceAll("<InputColumnVectorType2>", inputColumnVectorType2);
            testCase = testCase.replaceAll("<OutputColumnVectorType>", outputColumnVectorType);
            testCase = testCase.replaceAll("<InitOuputColHasNulls>", testMatrix[0].toString());
            testCase = testCase.replaceAll("<InitOuputColIsRepeating>", testMatrix[1].toString());
            testCase = testCase.replaceAll("<Column1HasNulls>", testMatrix[2].toString());
            testCase = testCase.replaceAll("<Column1IsRepeating>", testMatrix[3].toString());
            testCase = testCase.replaceAll("<Column2HasNulls>", testMatrix[4].toString());
            testCase = testCase.replaceAll("<Column2IsRepeating>", testMatrix[5].toString());
            this.testsuites.get((Object)template).append(testCase);
        }
    }

    public void addColumnColumnFilterTestCases(String vectorExpClassName, String inputColumnVectorType1, String inputColumnVectorType2, String operatorSymbol) throws IOException {
        TestSuiteClassName template = TestSuiteClassName.TestColumnColumnFilterVectorExpressionEvaluation;
        String templateFile = GenVectorCode.joinPath(this.testTemplateDirectory, template.toString() + ".txt");
        String templateString = GenVectorTestCode.removeTemplateComments(GenVectorCode.readFile(templateFile));
        for (Boolean[] testMatrix : new Boolean[][]{{false, true, true, true}, {false, false, false, false}, {true, false, true, false}, {true, true, false, false}, {true, false, false, true}}) {
            String testCase = templateString;
            testCase = testCase.replaceAll("<TestName>", "test" + vectorExpClassName + GenVectorTestCode.createNullRepeatingNameFragment("C1", testMatrix[0], testMatrix[1]) + GenVectorTestCode.createNullRepeatingNameFragment("C2", testMatrix[2], testMatrix[3]));
            testCase = testCase.replaceAll("<VectorExpClassName>", vectorExpClassName);
            testCase = testCase.replaceAll("<InputColumnVectorType1>", inputColumnVectorType1);
            testCase = testCase.replaceAll("<InputColumnVectorType2>", inputColumnVectorType2);
            testCase = testCase.replaceAll("<Column1HasNulls>", testMatrix[0].toString());
            testCase = testCase.replaceAll("<Column1IsRepeating>", testMatrix[1].toString());
            testCase = testCase.replaceAll("<Column2HasNulls>", testMatrix[2].toString());
            testCase = testCase.replaceAll("<Column2IsRepeating>", testMatrix[3].toString());
            testCase = testCase.replaceAll("<Operator>", operatorSymbol);
            this.testsuites.get((Object)template).append(testCase);
        }
    }

    public void generateTestSuites() throws IOException {
        String templateFile = GenVectorCode.joinPath(this.testTemplateDirectory, "TestClass.txt");
        for (TestSuiteClassName testClass : this.testsuites.keySet()) {
            String templateString = GenVectorCode.readFile(templateFile);
            templateString = templateString.replaceAll("<ClassName>", testClass.toString());
            templateString = templateString.replaceAll("<TestCases>", this.testsuites.get((Object)testClass).toString());
            String outputFile = GenVectorCode.joinPath(this.testOutputDir, (Object)((Object)testClass) + ".java");
            GenVectorCode.writeFile(new File(outputFile), templateString);
        }
    }

    private static String createNullRepeatingNameFragment(String identifier, boolean nulls, boolean repeating) {
        if (nulls || repeating) {
            if (nulls) {
                identifier = identifier + "Nulls";
            }
            if (repeating) {
                identifier = identifier + "Repeats";
            }
            return identifier;
        }
        return "";
    }

    private static String createOutputTypeInfoFragment(String identifier, String outputTypeInfo) {
        if (identifier == null) {
            throw new RuntimeException("Received null input for the identifier");
        }
        switch (outputTypeInfo) {
            case "tinyint": {
                return identifier + "TinyInt";
            }
            case "smallint": {
                return identifier + "SmallInt";
            }
            case "int": {
                return identifier + "Int";
            }
            case "bigint": {
                return identifier + "BigInt";
            }
            case "float": {
                return identifier + "Float";
            }
            case "double": {
                return identifier + "Double";
            }
        }
        throw new RuntimeException("Unsupported input typeInfo " + outputTypeInfo);
    }

    private static String removeTemplateComments(String templateString) {
        return templateString.replaceAll("(?s)<!--(.*)-->", "");
    }

    public static enum TestSuiteClassName {
        TestColumnScalarOperationVectorExpressionEvaluation,
        TestColumnScalarOperationVectorExpressionCheckedEvaluation,
        TestColumnScalarFilterVectorExpressionEvaluation,
        TestColumnColumnOperationVectorExpressionEvaluation,
        TestColumnColumnOperationVectorExpressionCheckedEvaluation,
        TestColumnColumnFilterVectorExpressionEvaluation;

    }
}

