/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.launch;

import java.io.IOException;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.slider.api.SliderClusterProtocol;
import org.apache.slider.client.SliderYarnClientImpl;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.core.launch.LaunchedApplication;
import org.apache.slider.server.appmaster.rpc.RpcBinder;

public class RunningApplication
extends LaunchedApplication {
    private final ApplicationReport applicationReport;

    public RunningApplication(SliderYarnClientImpl yarnClient, ApplicationReport applicationReport) {
        super(yarnClient, applicationReport);
        this.applicationReport = applicationReport;
    }

    @Override
    public ApplicationReport getApplicationReport() {
        return this.applicationReport;
    }

    public SliderClusterProtocol connect(ApplicationReport app) throws YarnException, IOException {
        try {
            return RpcBinder.getProxy(this.yarnClient.getConfig(), this.yarnClient.getRmClient(), app, 10000, 15000);
        }
        catch (InterruptedException e) {
            throw new SliderException(67, e, "Interrupted waiting for communications with the Application Master", new Object[0]);
        }
    }
}

