/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.registry.docstore;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.slider.core.registry.docstore.ExportEntry;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class PublishedExports {
    public String description;
    public long updated;
    public String updatedTime;
    public Map<String, List<ExportEntry>> entries = new HashMap<String, List<ExportEntry>>();

    public PublishedExports() {
    }

    public PublishedExports(String description) {
        this.description = description;
    }

    public PublishedExports(String description, Iterable<Map.Entry<String, List<ExportEntry>>> entries) {
        this.description = description;
        this.putValues(entries);
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public long getUpdated() {
        return this.updated;
    }

    public void setUpdated(long updated) {
        this.updated = updated;
        this.updatedTime = new Date(updated).toString();
    }

    public void putValues(Iterable<Map.Entry<String, List<ExportEntry>>> entries) {
        this.entries = new HashMap<String, List<ExportEntry>>();
        for (Map.Entry<String, List<ExportEntry>> entry : entries) {
            this.entries.put(entry.getKey(), entry.getValue());
        }
    }

    public String asJson() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        String json = mapper.writeValueAsString(this.entries);
        return json;
    }

    public PublishedExports shallowCopy() {
        PublishedExports that = new PublishedExports();
        that.description = this.description;
        that.updated = this.updated;
        that.updatedTime = this.updatedTime;
        return that;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PublishedConfiguration{");
        sb.append("description='").append(this.description).append('\'');
        sb.append(" entries = ").append(this.entries.size());
        sb.append('}');
        return sb.toString();
    }
}

