/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.services.workflow;

import com.google.common.base.Preconditions;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ServiceThreadFactory
implements ThreadFactory {
    private static AtomicInteger counter = new AtomicInteger(1);
    public static final String DEFAULT_NAMING_FORMAT = "%s-%03d";
    private final String name;
    private final boolean daemons;
    private final String namingFormat;

    public ServiceThreadFactory(String name, boolean daemons, String namingFormat) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"null name");
        Preconditions.checkArgument((namingFormat != null ? 1 : 0) != 0, (Object)"null naming format");
        this.name = name;
        this.daemons = daemons;
        this.namingFormat = namingFormat;
    }

    public ServiceThreadFactory(String name, boolean daemons) {
        this(name, daemons, DEFAULT_NAMING_FORMAT);
    }

    @Override
    public Thread newThread(Runnable r) {
        Preconditions.checkArgument((r != null ? 1 : 0) != 0, (Object)"null runnable");
        String threadName = String.format(this.namingFormat, this.name, counter.getAndIncrement());
        Thread thread = new Thread(r, threadName);
        thread.setDaemon(this.daemons);
        return thread;
    }

    public static ExecutorService singleThreadExecutor(String name, boolean daemons) {
        return Executors.newSingleThreadExecutor(new ServiceThreadFactory(name, daemons));
    }
}

