/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.table;

import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public abstract class RowMapperTableModel
implements TableModel {
    private EventListenerList eventListenerList;
    private TableModel parent;
    private int rowCount;

    public RowMapperTableModel(TableModel parent) {
        if (parent == null) {
            throw new NullPointerException();
        }
        this.eventListenerList = new EventListenerList();
        this.parent = parent;
        this.parent.addTableModelListener(new EventForwardHandler());
    }

    protected void fireTableModelEvent(TableModelEvent event) {
        TableModelListener[] listeners = (TableModelListener[])this.eventListenerList.getListeners(TableModelListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            TableModelListener listener = listeners[i];
            listener.tableChanged(event);
        }
    }

    protected void recomputeRowCount() {
        this.rowCount = this.mapFromModel(this.parent.getRowCount());
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.parent.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.parent.getColumnName(columnIndex);
    }

    public Class getColumnClass(int columnIndex) {
        return this.parent.getColumnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        int index = this.mapToModel(rowIndex);
        return this.parent.isCellEditable(index, columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.parent.getValueAt(this.mapToModel(rowIndex), columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        int index = this.mapToModel(rowIndex);
        this.parent.setValueAt(aValue, index, columnIndex);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.eventListenerList.add(TableModelListener.class, l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.eventListenerList.remove(TableModelListener.class, l);
    }

    public int mapToModel(int row) {
        int size = this.parent.getRowCount();
        int effectiveRow = 0;
        for (int i = 0; i < size; ++i) {
            if (this.isFiltered(i)) continue;
            if (effectiveRow == row) {
                return i;
            }
            ++effectiveRow;
        }
        throw new IndexOutOfBoundsException("Unable to map row to model: " + row);
    }

    protected abstract boolean isFiltered(int var1);

    public int mapFromModel(int row) {
        if (row < 0) {
            return row;
        }
        int size = this.parent.getRowCount();
        int retval = 0;
        for (int i = 0; i < size; ++i) {
            if (this.isFiltered(i)) continue;
            if (row == i) {
                return retval;
            }
            ++retval;
        }
        return retval;
    }

    private class EventForwardHandler
    implements TableModelListener {
        private EventForwardHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            RowMapperTableModel.this.recomputeRowCount();
            if (e.getFirstRow() == 0 && e.getLastRow() == Integer.MAX_VALUE) {
                RowMapperTableModel.this.fireTableModelEvent(new TableModelEvent(RowMapperTableModel.this, e.getFirstRow(), e.getLastRow(), e.getColumn(), e.getType()));
                return;
            }
            TableModelEvent event = new TableModelEvent(RowMapperTableModel.this, RowMapperTableModel.this.mapFromModel(e.getFirstRow()), RowMapperTableModel.this.mapFromModel(e.getLastRow()), e.getColumn(), e.getType());
            RowMapperTableModel.this.fireTableModelEvent(event);
        }
    }
}

