/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun.extra;

import java.util.HashMap;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.StringCalc;
import mondrian.calc.TupleCalc;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;

public class CachedExistsFunDef
extends FunDefBase {
    public static final CachedExistsFunDef instance = new CachedExistsFunDef();

    CachedExistsFunDef() {
        super("CachedExists", "Returns tuples from a non-dynamic <Set> that exists in the specified <Tuple>.  This function will build a query level cache named <String> based on the <Tuple> type.", "fxxtS");
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc1 = compiler.compileList(call.getArg(0));
        final TupleCalc tupleCalc1 = compiler.compileTuple(call.getArg(1));
        final StringCalc stringCalc = compiler.compileString(call.getArg(2));
        return new AbstractListCalc(call, new Calc[]{listCalc1, tupleCalc1, stringCalc}){

            @Override
            public TupleList evaluateList(Evaluator evaluator) {
                Member[] subtotal = tupleCalc1.evaluateTuple(evaluator);
                String namedSetName = stringCalc.evaluateString(evaluator);
                Object cacheObj = evaluator.getQuery().getEvalCache(CachedExistsFunDef.this.makeSetCacheKey(namedSetName, subtotal));
                if (cacheObj != null) {
                    HashMap setCache = (HashMap)cacheObj;
                    TupleList tuples = (TupleList)setCache.get(CachedExistsFunDef.this.makeSubtotalKey(subtotal));
                    if (tuples == null) {
                        tuples = TupleCollections.emptyList(listCalc1.getType().getArity());
                    }
                    return tuples;
                }
                HashMap<String, TupleList> setCache = new HashMap<String, TupleList>();
                TupleList setToCache = listCalc1.evaluateList(evaluator);
                for (List tuple : setToCache) {
                    String subtotalKey = CachedExistsFunDef.this.makeSubtotalKey(tuple, subtotal);
                    TupleList tupleCache = (TupleList)setCache.get(subtotalKey);
                    if (tupleCache == null) {
                        tupleCache = TupleCollections.createList(listCalc1.getType().getArity());
                        setCache.put(subtotalKey, tupleCache);
                    }
                    tupleCache.add(tuple);
                }
                evaluator.getQuery().putEvalCache(CachedExistsFunDef.this.makeSetCacheKey(namedSetName, subtotal), setCache);
                TupleList tuples = (TupleList)setCache.get(CachedExistsFunDef.this.makeSubtotalKey(subtotal));
                if (tuples == null) {
                    tuples = TupleCollections.emptyList(listCalc1.getType().getArity());
                }
                return tuples;
            }
        };
    }

    private String makeSubtotalKey(List<Member> tuple, Member[] subtotal) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < subtotal.length; ++i) {
            Member subtotalMember = subtotal[i];
            Member tupleMember = tuple.get(i);
            int parentLevels = tupleMember.getDepth() - subtotalMember.getDepth();
            while (parentLevels-- > 0) {
                tupleMember = tupleMember.getParentMember();
            }
            builder.append(tupleMember.getUniqueName());
        }
        return builder.toString();
    }

    private String makeSetCacheKey(String setName, Member[] members) {
        StringBuilder builder = new StringBuilder();
        builder.append(setName);
        for (Member m : members) {
            builder.append(m.getLevel().getUniqueName());
        }
        return builder.toString();
    }

    private String makeSubtotalKey(Member[] members) {
        StringBuilder builder = new StringBuilder();
        for (Member m : members) {
            builder.append(m.getUniqueName());
        }
        return builder.toString();
    }
}

