/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatus;

public class BlockPlacementStatusDefault
implements BlockPlacementStatus {
    private int requiredRacks = 0;
    private int currentRacks = 0;
    private final int totalRacks;

    public BlockPlacementStatusDefault(int currentRacks, int requiredRacks, int totalRacks) {
        this.requiredRacks = requiredRacks;
        this.currentRacks = currentRacks;
        this.totalRacks = totalRacks;
    }

    @Override
    public boolean isPlacementPolicySatisfied() {
        return this.requiredRacks <= this.currentRacks || this.currentRacks >= this.totalRacks;
    }

    @Override
    public String getErrorDescription() {
        if (this.isPlacementPolicySatisfied()) {
            return null;
        }
        return "Block should be additionally replicated on " + (this.requiredRacks - this.currentRacks) + " more rack(s). Total number of racks in the cluster: " + this.totalRacks;
    }
}

