/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.scoring;

import org.pentaho.di.scoring.WekaScoringModel;
import weka.classifiers.Classifier;
import weka.classifiers.UpdateableClassifier;
import weka.classifiers.pmml.consumer.PMMLClassifier;
import weka.core.BatchPredictor;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

class WekaScoringClassifier
extends WekaScoringModel {
    private Classifier m_model;

    public WekaScoringClassifier(Object model) {
        super(model);
    }

    @Override
    public void setModel(Object model) {
        this.m_model = (Classifier)model;
    }

    @Override
    public Object getModel() {
        return this.m_model;
    }

    @Override
    public double classifyInstance(Instance inst) throws Exception {
        return this.m_model.classifyInstance(inst);
    }

    @Override
    public boolean update(Instance inst) throws Exception {
        if (this.isUpdateableModel()) {
            ((UpdateableClassifier)this.m_model).updateClassifier(inst);
            return true;
        }
        return false;
    }

    @Override
    public double[] distributionForInstance(Instance inst) throws Exception {
        return this.m_model.distributionForInstance(inst);
    }

    @Override
    public boolean isSupervisedLearningModel() {
        return true;
    }

    @Override
    public boolean isUpdateableModel() {
        return this.m_model instanceof UpdateableClassifier;
    }

    @Override
    public void done() {
        if (this.m_model instanceof PMMLClassifier) {
            ((PMMLClassifier)this.m_model).done();
        }
    }

    public String toString() {
        return this.m_model.toString();
    }

    @Override
    public double[] classifyInstances(Instances insts) throws Exception {
        double[][] preds = this.distributionsForInstances(insts);
        double[] result = new double[preds.length];
        for (int i = 0; i < preds.length; ++i) {
            double[] p = preds[i];
            result[i] = Utils.sum((double[])p) <= 0.0 ? Utils.missingValue() : (double)Utils.maxIndex((double[])p);
        }
        return result;
    }

    @Override
    public double[][] distributionsForInstances(Instances insts) throws Exception {
        if (!this.isBatchPredictor()) {
            throw new Exception("Weka model cannot produce batch predictions!");
        }
        return ((BatchPredictor)this.m_model).distributionsForInstances(insts);
    }

    @Override
    public boolean isBatchPredictor() {
        return this.m_model instanceof BatchPredictor;
    }
}

