/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net;

import java.io.Serializable;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.BIFReader;
import weka.classifiers.bayes.net.ParentSet;
import weka.classifiers.bayes.net.estimate.DiscreteEstimatorBayes;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.SerializedObject;
import weka.estimators.Estimator;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Reorder;

public class EditableBayesNet
extends BayesNet {
    static final long serialVersionUID = 746037443258735954L;
    protected FastVector m_nPositionX;
    protected FastVector m_nPositionY;
    protected FastVector m_fMarginP;
    protected FastVector m_nEvidence;
    static final int TEST = 0;
    static final int EXECUTE = 1;
    FastVector m_undoStack = new FastVector();
    int m_nCurrentEditAction = -1;
    int m_nSavedPointer = -1;
    boolean m_bNeedsUndoAction = true;

    public EditableBayesNet() {
        this.m_nEvidence = new FastVector(0);
        this.m_fMarginP = new FastVector(0);
        this.m_nPositionX = new FastVector();
        this.m_nPositionY = new FastVector();
        this.clearUndoStack();
    }

    public EditableBayesNet(Instances instances) {
        int iNode;
        int i;
        try {
            if (instances.classIndex() < 0) {
                instances.setClassIndex(instances.numAttributes() - 1);
            }
            this.m_Instances = this.normalizeDataSet(instances);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int nNodes = this.getNrOfNodes();
        this.m_ParentSets = new ParentSet[nNodes];
        for (i = 0; i < nNodes; ++i) {
            this.m_ParentSets[i] = new ParentSet();
        }
        this.m_Distributions = new Estimator[nNodes][];
        for (iNode = 0; iNode < nNodes; ++iNode) {
            this.m_Distributions[iNode] = new Estimator[1];
            this.m_Distributions[iNode][0] = new DiscreteEstimatorBayes(this.getCardinality(iNode), 0.5);
        }
        this.m_nEvidence = new FastVector(nNodes);
        for (i = 0; i < nNodes; ++i) {
            this.m_nEvidence.addElement(-1);
        }
        this.m_fMarginP = new FastVector(nNodes);
        for (i = 0; i < nNodes; ++i) {
            double[] P = new double[this.getCardinality(i)];
            this.m_fMarginP.addElement(P);
        }
        this.m_nPositionX = new FastVector(nNodes);
        this.m_nPositionY = new FastVector(nNodes);
        for (iNode = 0; iNode < nNodes; ++iNode) {
            this.m_nPositionX.addElement(iNode % 10 * 50);
            this.m_nPositionY.addElement(iNode / 10 * 50);
        }
    }

    public EditableBayesNet(BIFReader other) {
        int i;
        this.m_Instances = other.m_Instances;
        this.m_ParentSets = other.getParentSets();
        this.m_Distributions = other.getDistributions();
        int nNodes = this.getNrOfNodes();
        this.m_nPositionX = new FastVector(nNodes);
        this.m_nPositionY = new FastVector(nNodes);
        for (i = 0; i < nNodes; ++i) {
            this.m_nPositionX.addElement(other.m_nPositionX[i]);
            this.m_nPositionY.addElement(other.m_nPositionY[i]);
        }
        this.m_nEvidence = new FastVector(nNodes);
        for (i = 0; i < nNodes; ++i) {
            this.m_nEvidence.addElement(-1);
        }
        this.m_fMarginP = new FastVector(nNodes);
        for (i = 0; i < nNodes; ++i) {
            double[] P = new double[this.getCardinality(i)];
            this.m_fMarginP.addElement(P);
        }
        this.clearUndoStack();
    }

    public EditableBayesNet(boolean bSetInstances) {
        this.m_nEvidence = new FastVector(0);
        this.m_fMarginP = new FastVector(0);
        this.m_nPositionX = new FastVector();
        this.m_nPositionY = new FastVector();
        this.clearUndoStack();
        if (bSetInstances) {
            this.m_Instances = new Instances("New Network", new FastVector<Attribute>(0), 0);
        }
    }

    public void setData(Instances instances) throws Exception {
        int[] order = new int[this.getNrOfNodes()];
        for (int iNode = 0; iNode < this.getNrOfNodes(); ++iNode) {
            int nNode;
            String sName = this.getNodeName(iNode);
            for (nNode = 0; nNode < this.getNrOfNodes() && !sName.equals(instances.attribute(nNode).name()); ++nNode) {
            }
            if (nNode >= this.getNrOfNodes()) {
                throw new Exception("Cannot find node named [[[" + sName + "]]] in the data");
            }
            order[iNode] = nNode;
        }
        Reorder reorderFilter = new Reorder();
        reorderFilter.setAttributeIndicesArray(order);
        reorderFilter.setInputFormat(instances);
        instances = Filter.useFilter(instances, reorderFilter);
        Instances newInstances = new Instances(this.m_Instances, 0);
        if (this.m_DiscretizeFilter == null && this.m_MissingValuesFilter == null) {
            newInstances = this.normalizeDataSet(instances);
        } else {
            for (int iInstance = 0; iInstance < instances.numInstances(); ++iInstance) {
                newInstances.add(this.normalizeInstance(instances.instance(iInstance)));
            }
        }
        for (int iNode = 0; iNode < this.getNrOfNodes(); ++iNode) {
            if (newInstances.attribute(iNode).numValues() == this.getCardinality(iNode)) continue;
            throw new Exception("Number of values of node [[[" + this.getNodeName(iNode) + "]]] differs in (discretized) dataset.");
        }
        this.m_Instances = newInstances;
    }

    public int getNode2(String sNodeName) {
        for (int iNode = 0; iNode < this.m_Instances.numAttributes(); ++iNode) {
            if (!this.m_Instances.attribute(iNode).name().equals(sNodeName)) continue;
            return iNode;
        }
        return -1;
    }

    public int getNode(String sNodeName) throws Exception {
        int iNode = this.getNode2(sNodeName);
        if (iNode < 0) {
            throw new Exception("Could not find node [[" + sNodeName + "]]");
        }
        return iNode;
    }

    public void addNode(String sName, int nCardinality) throws Exception {
        this.addNode(sName, nCardinality, 100 + this.getNrOfNodes() * 10, 100 + this.getNrOfNodes() * 10);
    }

    public void addNode(String sName, int nCardinality, int nPosX, int nPosY) throws Exception {
        if (this.getNode2(sName) >= 0) {
            this.addNode(sName + "x", nCardinality);
            return;
        }
        FastVector<String> values = new FastVector<String>(nCardinality);
        for (int iValue = 0; iValue < nCardinality; ++iValue) {
            values.addElement("Value" + (iValue + 1));
        }
        Attribute att = new Attribute(sName, values);
        this.m_Instances.insertAttributeAt(att, this.m_Instances.numAttributes());
        int nAtts = this.m_Instances.numAttributes();
        ParentSet[] parentSets = new ParentSet[nAtts];
        for (int iParentSet = 0; iParentSet < nAtts - 1; ++iParentSet) {
            parentSets[iParentSet] = this.m_ParentSets[iParentSet];
        }
        parentSets[nAtts - 1] = new ParentSet();
        this.m_ParentSets = parentSets;
        Estimator[][] distributions = new Estimator[nAtts][];
        for (int iNode = 0; iNode < nAtts - 1; ++iNode) {
            distributions[iNode] = this.m_Distributions[iNode];
        }
        distributions[nAtts - 1] = new Estimator[1];
        distributions[nAtts - 1][0] = new DiscreteEstimatorBayes(nCardinality, 0.5);
        this.m_Distributions = distributions;
        this.m_nPositionX.addElement(nPosX);
        this.m_nPositionY.addElement(nPosY);
        this.m_nEvidence.addElement(-1);
        double[] fMarginP = new double[nCardinality];
        for (int iValue = 0; iValue < nCardinality; ++iValue) {
            fMarginP[iValue] = 1.0 / (double)nCardinality;
        }
        this.m_fMarginP.addElement(fMarginP);
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new AddNodeAction(sName, nCardinality, nPosX, nPosY));
        }
    }

    public void deleteNode(String sName) throws Exception {
        int nTargetNode = this.getNode(sName);
        this.deleteNode(nTargetNode);
    }

    public void deleteNode(int nTargetNode) throws Exception {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new DeleteNodeAction(nTargetNode));
        }
        int nAtts = this.m_Instances.numAttributes() - 1;
        int nTargetCard = this.m_Instances.attribute(nTargetNode).numValues();
        Estimator[][] distributions = new Estimator[nAtts][];
        for (int iNode = 0; iNode < nAtts; ++iNode) {
            int iNode2 = iNode;
            if (iNode >= nTargetNode) {
                ++iNode2;
            }
            Estimator[] distribution = this.m_Distributions[iNode2];
            if (this.m_ParentSets[iNode2].contains(nTargetNode)) {
                int nParentCard = this.m_ParentSets[iNode2].getCardinalityOfParents();
                Estimator[] distribution2 = new Estimator[nParentCard /= nTargetCard];
                for (int iParent = 0; iParent < nParentCard; ++iParent) {
                    distribution2[iParent] = distribution[iParent];
                }
                distribution = distribution2;
            }
            distributions[iNode] = distribution;
        }
        this.m_Distributions = distributions;
        ParentSet[] parentSets = new ParentSet[nAtts];
        for (int iParentSet = 0; iParentSet < nAtts; ++iParentSet) {
            int iParentSet2 = iParentSet;
            if (iParentSet >= nTargetNode) {
                ++iParentSet2;
            }
            ParentSet parentset = this.m_ParentSets[iParentSet2];
            parentset.deleteParent(nTargetNode, this.m_Instances);
            for (int iParent = 0; iParent < parentset.getNrOfParents(); ++iParent) {
                int nParent = parentset.getParent(iParent);
                if (nParent <= nTargetNode) continue;
                parentset.SetParent(iParent, nParent - 1);
            }
            parentSets[iParentSet] = parentset;
        }
        this.m_ParentSets = parentSets;
        this.m_Instances.setClassIndex(-1);
        this.m_Instances.deleteAttributeAt(nTargetNode);
        this.m_Instances.setClassIndex(nAtts - 1);
        this.m_nPositionX.removeElementAt(nTargetNode);
        this.m_nPositionY.removeElementAt(nTargetNode);
        this.m_nEvidence.removeElementAt(nTargetNode);
        this.m_fMarginP.removeElementAt(nTargetNode);
    }

    public void deleteSelection(FastVector nodes) {
        for (int i = 0; i < nodes.size(); ++i) {
            for (int j = i + 1; j < nodes.size(); ++j) {
                if ((Integer)nodes.elementAt(i) <= (Integer)nodes.elementAt(j)) continue;
                int h = (Integer)nodes.elementAt(i);
                nodes.setElementAt(nodes.elementAt(j), i);
                nodes.setElementAt(h, j);
            }
        }
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new DeleteSelectionAction(nodes));
        }
        boolean bNeedsUndoAction = this.m_bNeedsUndoAction;
        this.m_bNeedsUndoAction = false;
        try {
            for (int iNode = nodes.size() - 1; iNode >= 0; --iNode) {
                this.deleteNode((Integer)nodes.elementAt(iNode));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_bNeedsUndoAction = bNeedsUndoAction;
    }

    FastVector selectElements(Node item, String sElement) throws Exception {
        NodeList children = item.getChildNodes();
        FastVector<Node> nodelist = new FastVector<Node>();
        for (int iNode = 0; iNode < children.getLength(); ++iNode) {
            Node node = children.item(iNode);
            if (node.getNodeType() != 1 || !node.getNodeName().equals(sElement)) continue;
            nodelist.addElement(node);
        }
        return nodelist;
    }

    public String getContent(Element node) {
        String result = "";
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node item = list.item(i);
            if (item.getNodeType() != 3) continue;
            result = result + "\n" + item.getNodeValue();
        }
        return result;
    }

    Element getDefinition(Document doc, String sName) throws Exception {
        NodeList nodelist = doc.getElementsByTagName("DEFINITION");
        for (int iNode = 0; iNode < nodelist.getLength(); ++iNode) {
            Node forNode;
            Node node = nodelist.item(iNode);
            FastVector list = this.selectElements(node, "FOR");
            if (list.size() <= 0 || !this.getContent((Element)(forNode = (Node)list.elementAt(0))).trim().equals(sName)) continue;
            return (Element)node;
        }
        throw new Exception("Could not find definition for ((" + sName + "))");
    }

    public void paste(String sXML) throws Exception {
        this.paste(sXML, 0);
        this.paste(sXML, 1);
    }

    void paste(String sXML, int mode) throws Exception {
        int iNode;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        Document doc = factory.newDocumentBuilder().parse(new InputSource(new StringReader(sXML)));
        doc.normalize();
        NodeList nodelist = doc.getElementsByTagName("VARIABLE");
        FastVector<String> sBaseNames = new FastVector<String>();
        Instances instances = new Instances(this.m_Instances, 0);
        int nBase = instances.numAttributes();
        for (int iNode2 = 0; iNode2 < nodelist.getLength(); ++iNode2) {
            FastVector valueslist = this.selectElements(nodelist.item(iNode2), "OUTCOME");
            int nValues = valueslist.size();
            FastVector<String> nomStrings = new FastVector<String>(nValues + 1);
            for (int iValue = 0; iValue < nValues; ++iValue) {
                Node node = ((Node)valueslist.elementAt(iValue)).getFirstChild();
                String sValue = ((CharacterData)node).getData();
                if (sValue == null) {
                    sValue = "Value" + (iValue + 1);
                }
                nomStrings.addElement(sValue);
            }
            FastVector nodelist2 = this.selectElements(nodelist.item(iNode2), "NAME");
            if (nodelist2.size() == 0) {
                throw new Exception("No name specified for variable");
            }
            String sBaseName = ((CharacterData)((Node)nodelist2.elementAt(0)).getFirstChild()).getData();
            sBaseNames.addElement(sBaseName);
            String sNodeName = sBaseName;
            if (this.getNode2(sNodeName) >= 0) {
                sNodeName = "Copy of " + sBaseName;
            }
            int iAttempt = 2;
            while (this.getNode2(sNodeName) >= 0) {
                sNodeName = "Copy (" + iAttempt + ") of " + sBaseName;
                ++iAttempt;
            }
            Attribute att = new Attribute(sNodeName, nomStrings);
            instances.insertAttributeAt(att, instances.numAttributes());
            valueslist = this.selectElements(nodelist.item(iNode2), "PROPERTY");
            nValues = valueslist.size();
            int nPosX = iAttempt * 10;
            int nPosY = iAttempt * 10;
            for (int iValue = 0; iValue < nValues; ++iValue) {
                Node node = ((Node)valueslist.elementAt(iValue)).getFirstChild();
                String sValue = ((CharacterData)node).getData();
                if (!sValue.startsWith("position")) continue;
                int i0 = sValue.indexOf(40);
                int i1 = sValue.indexOf(44);
                int i2 = sValue.indexOf(41);
                String sX = sValue.substring(i0 + 1, i1).trim();
                String sY = sValue.substring(i1 + 1, i2).trim();
                try {
                    nPosX = Integer.parseInt(sX) + iAttempt * 10;
                    nPosY = Integer.parseInt(sY) + iAttempt * 10;
                    continue;
                }
                catch (NumberFormatException e) {
                    System.err.println("Wrong number format in position :(" + sX + "," + sY + ")");
                }
            }
            if (mode != 1) continue;
            this.m_nPositionX.addElement(nPosX);
            this.m_nPositionY.addElement(nPosY);
        }
        Estimator[][] distributions = new Estimator[nBase + sBaseNames.size()][];
        ParentSet[] parentsets = new ParentSet[nBase + sBaseNames.size()];
        for (iNode = 0; iNode < nBase; ++iNode) {
            distributions[iNode] = this.m_Distributions[iNode];
            parentsets[iNode] = this.m_ParentSets[iNode];
        }
        if (mode == 1) {
            this.m_Instances = instances;
        }
        for (iNode = 0; iNode < sBaseNames.size(); ++iNode) {
            String sName = (String)sBaseNames.elementAt(iNode);
            Element definition = this.getDefinition(doc, sName);
            parentsets[nBase + iNode] = new ParentSet();
            FastVector nodelist2 = this.selectElements(definition, "GIVEN");
            for (int iParent = 0; iParent < nodelist2.size(); ++iParent) {
                Node parentName = ((Node)nodelist2.elementAt(iParent)).getFirstChild();
                String sParentName = ((CharacterData)parentName).getData();
                int nParent = -1;
                for (int iBase = 0; iBase < sBaseNames.size(); ++iBase) {
                    if (!sParentName.equals((String)sBaseNames.elementAt(iBase))) continue;
                    nParent = nBase + iBase;
                }
                if (nParent < 0) {
                    nParent = this.getNode(sParentName);
                }
                parentsets[nBase + iNode].addParent(nParent, instances);
            }
            int nCardinality = parentsets[nBase + iNode].getCardinalityOfParents();
            int nValues = instances.attribute(nBase + iNode).numValues();
            distributions[nBase + iNode] = new Estimator[nCardinality];
            for (int i = 0; i < nCardinality; ++i) {
                distributions[nBase + iNode][i] = new DiscreteEstimatorBayes(nValues, 0.0);
            }
            String sTable = this.getContent((Element)this.selectElements(definition, "TABLE").elementAt(0));
            sTable = sTable.replaceAll("\\n", " ");
            StringTokenizer st = new StringTokenizer(sTable.toString());
            for (int i = 0; i < nCardinality; ++i) {
                DiscreteEstimatorBayes d = (DiscreteEstimatorBayes)distributions[nBase + iNode][i];
                for (int iValue = 0; iValue < nValues; ++iValue) {
                    String sWeight = st.nextToken();
                    d.addValue(iValue, new Double(sWeight));
                }
            }
            if (mode != 1) continue;
            this.m_nEvidence.insertElementAt(-1, nBase + iNode);
            this.m_fMarginP.insertElementAt(new double[this.getCardinality(nBase + iNode)], nBase + iNode);
        }
        if (mode == 1) {
            this.m_Distributions = distributions;
            this.m_ParentSets = parentsets;
        }
        if (mode == 1 && this.m_bNeedsUndoAction) {
            this.addUndoAction(new PasteAction(sXML, nBase));
        }
    }

    public void addArc(String sParent, String sChild) throws Exception {
        int nParent = this.getNode(sParent);
        int nChild = this.getNode(sChild);
        this.addArc(nParent, nChild);
    }

    public void addArc(int nParent, int nChild) throws Exception {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new AddArcAction(nParent, nChild));
        }
        int nOldCard = this.m_ParentSets[nChild].getCardinalityOfParents();
        this.m_ParentSets[nChild].addParent(nParent, this.m_Instances);
        int nNewCard = this.m_ParentSets[nChild].getCardinalityOfParents();
        Estimator[] ds = new Estimator[nNewCard];
        for (int iParent = 0; iParent < nNewCard; ++iParent) {
            ds[iParent] = Estimator.clone(this.m_Distributions[nChild][iParent % nOldCard]);
        }
        this.m_Distributions[nChild] = ds;
    }

    public void addArc(String sParent, FastVector nodes) throws Exception {
        int nParent = this.getNode(sParent);
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new AddArcAction(nParent, nodes));
        }
        boolean bNeedsUndoAction = this.m_bNeedsUndoAction;
        this.m_bNeedsUndoAction = false;
        for (int iNode = 0; iNode < nodes.size(); ++iNode) {
            int nNode = (Integer)nodes.elementAt(iNode);
            this.addArc(nParent, nNode);
        }
        this.m_bNeedsUndoAction = bNeedsUndoAction;
    }

    public void deleteArc(String sParent, String sChild) throws Exception {
        int nParent = this.getNode(sParent);
        int nChild = this.getNode(sChild);
        this.deleteArc(nParent, nChild);
    }

    public void deleteArc(int nParent, int nChild) throws Exception {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new DeleteArcAction(nParent, nChild));
        }
        int nParentCard = this.m_ParentSets[nChild].getCardinalityOfParents();
        int nTargetCard = this.m_Instances.attribute(nChild).numValues();
        Estimator[] distribution2 = new Estimator[nParentCard /= nTargetCard];
        for (int iParent = 0; iParent < nParentCard; ++iParent) {
            distribution2[iParent] = this.m_Distributions[nChild][iParent];
        }
        this.m_Distributions[nChild] = distribution2;
        this.m_ParentSets[nChild].deleteParent(nParent, this.m_Instances);
    }

    public void setDistribution(String sName, double[][] P) throws Exception {
        int nTargetNode = this.getNode(sName);
        this.setDistribution(nTargetNode, P);
    }

    public void setDistribution(int nTargetNode, double[][] P) throws Exception {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new SetDistributionAction(nTargetNode, P));
        }
        Estimator[] distributions = this.m_Distributions[nTargetNode];
        for (int iParent = 0; iParent < distributions.length; ++iParent) {
            DiscreteEstimatorBayes distribution = new DiscreteEstimatorBayes(P[0].length, 0.0);
            for (int iValue = 0; iValue < distribution.getNumSymbols(); ++iValue) {
                distribution.addValue(iValue, P[iParent][iValue]);
            }
            distributions[iParent] = distribution;
        }
    }

    public double[][] getDistribution(String sName) {
        int nTargetNode = this.getNode2(sName);
        return this.getDistribution(nTargetNode);
    }

    public double[][] getDistribution(int nTargetNode) {
        int nParentCard = this.m_ParentSets[nTargetNode].getCardinalityOfParents();
        int nCard = this.m_Instances.attribute(nTargetNode).numValues();
        double[][] P = new double[nParentCard][nCard];
        for (int iParent = 0; iParent < nParentCard; ++iParent) {
            for (int iValue = 0; iValue < nCard; ++iValue) {
                P[iParent][iValue] = this.m_Distributions[nTargetNode][iParent].getProbability(iValue);
            }
        }
        return P;
    }

    public String[] getValues(String sName) {
        int nTargetNode = this.getNode2(sName);
        return this.getValues(nTargetNode);
    }

    public String[] getValues(int nTargetNode) {
        String[] values = new String[this.getCardinality(nTargetNode)];
        for (int iValue = 0; iValue < values.length; ++iValue) {
            values[iValue] = this.m_Instances.attribute(nTargetNode).value(iValue);
        }
        return values;
    }

    public String getValueName(int nTargetNode, int iValue) {
        return this.m_Instances.attribute(nTargetNode).value(iValue);
    }

    public void setNodeName(int nTargetNode, String sName) {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new RenameAction(nTargetNode, this.getNodeName(nTargetNode), sName));
        }
        Attribute att = this.m_Instances.attribute(nTargetNode);
        int nCardinality = att.numValues();
        FastVector<String> values = new FastVector<String>(nCardinality);
        for (int iValue = 0; iValue < nCardinality; ++iValue) {
            values.addElement(att.value(iValue));
        }
        this.replaceAtt(nTargetNode, sName, values);
    }

    public void renameNodeValue(int nTargetNode, String sValue, String sNewValue) {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new RenameValueAction(nTargetNode, sValue, sNewValue));
        }
        Attribute att = this.m_Instances.attribute(nTargetNode);
        int nCardinality = att.numValues();
        FastVector<String> values = new FastVector<String>(nCardinality);
        for (int iValue = 0; iValue < nCardinality; ++iValue) {
            if (att.value(iValue).equals(sValue)) {
                values.addElement(sNewValue);
                continue;
            }
            values.addElement(att.value(iValue));
        }
        this.replaceAtt(nTargetNode, att.name(), values);
    }

    public void addNodeValue(int nTargetNode, String sNewValue) {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new AddValueAction(nTargetNode, sNewValue));
        }
        Attribute att = this.m_Instances.attribute(nTargetNode);
        int nCardinality = att.numValues();
        FastVector<String> values = new FastVector<String>(nCardinality);
        for (int iValue = 0; iValue < nCardinality; ++iValue) {
            values.addElement(att.value(iValue));
        }
        values.addElement(sNewValue);
        this.replaceAtt(nTargetNode, att.name(), values);
        Estimator[] distributions = this.m_Distributions[nTargetNode];
        int nNewCard = values.size();
        for (int iParent = 0; iParent < distributions.length; ++iParent) {
            DiscreteEstimatorBayes distribution = new DiscreteEstimatorBayes(nNewCard, 0.0);
            for (int iValue = 0; iValue < nNewCard - 1; ++iValue) {
                distribution.addValue(iValue, distributions[iParent].getProbability(iValue));
            }
            distributions[iParent] = distribution;
        }
        for (int iNode = 0; iNode < this.getNrOfNodes(); ++iNode) {
            if (!this.m_ParentSets[iNode].contains(nTargetNode)) continue;
            distributions = this.m_Distributions[iNode];
            ParentSet parentSet = this.m_ParentSets[iNode];
            int nParentCard = parentSet.getFreshCardinalityOfParents(this.m_Instances);
            Estimator[] newDistributions = new Estimator[nParentCard];
            int nCard = this.getCardinality(iNode);
            int nParents = parentSet.getNrOfParents();
            int[] values2 = new int[nParents];
            int iOldPos = 0;
            int iTargetNode = 0;
            while (parentSet.getParent(iTargetNode) != nTargetNode) {
                ++iTargetNode;
            }
            for (int iPos = 0; iPos < nParentCard; ++iPos) {
                int i;
                DiscreteEstimatorBayes distribution = new DiscreteEstimatorBayes(nCard, 0.0);
                for (int iValue = 0; iValue < nCard; ++iValue) {
                    distribution.addValue(iValue, distributions[iOldPos].getProbability(iValue));
                }
                newDistributions[iPos] = distribution;
                int n = i = 0;
                values2[n] = values2[n] + 1;
                while (i < nParents && values2[i] == this.getCardinality(parentSet.getParent(i))) {
                    values2[i] = 0;
                    if (++i >= nParents) continue;
                    int n2 = i;
                    values2[n2] = values2[n2] + 1;
                }
                if (values2[iTargetNode] == nNewCard - 1) continue;
                ++iOldPos;
            }
            this.m_Distributions[iNode] = newDistributions;
        }
    }

    public void delNodeValue(int nTargetNode, String sValue) throws Exception {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new DelValueAction(nTargetNode, sValue));
        }
        Attribute att = this.m_Instances.attribute(nTargetNode);
        int nCardinality = att.numValues();
        FastVector<String> values = new FastVector<String>(nCardinality);
        int nValue = -1;
        for (int iValue = 0; iValue < nCardinality; ++iValue) {
            if (att.value(iValue).equals(sValue)) {
                nValue = iValue;
                continue;
            }
            values.addElement(att.value(iValue));
        }
        if (nValue < 0) {
            throw new Exception("Node " + nTargetNode + " does not have value (" + sValue + ")");
        }
        this.replaceAtt(nTargetNode, att.name(), values);
        Estimator[] distributions = this.m_Distributions[nTargetNode];
        int nCard = values.size();
        for (int iParent = 0; iParent < distributions.length; ++iParent) {
            int iValue;
            DiscreteEstimatorBayes distribution = new DiscreteEstimatorBayes(nCard, 0.0);
            double sum = 0.0;
            for (iValue = 0; iValue < nCard; ++iValue) {
                sum += distributions[iParent].getProbability(iValue);
            }
            if (sum > 0.0) {
                for (iValue = 0; iValue < nCard; ++iValue) {
                    distribution.addValue(iValue, distributions[iParent].getProbability(iValue) / sum);
                }
            } else {
                for (iValue = 0; iValue < nCard; ++iValue) {
                    distribution.addValue(iValue, 1.0 / (double)nCard);
                }
            }
            distributions[iParent] = distribution;
        }
        for (int iNode = 0; iNode < this.getNrOfNodes(); ++iNode) {
            if (!this.m_ParentSets[iNode].contains(nTargetNode)) continue;
            ParentSet parentSet = this.m_ParentSets[iNode];
            distributions = this.m_Distributions[iNode];
            Estimator[] newDistributions = new Estimator[distributions.length * nCard / (nCard + 1)];
            int iCurrentDist = 0;
            int nParents = parentSet.getNrOfParents();
            int[] values2 = new int[nParents];
            int nParentCard = parentSet.getFreshCardinalityOfParents(this.m_Instances) * (nCard + 1) / nCard;
            int iTargetNode = 0;
            while (parentSet.getParent(iTargetNode) != nTargetNode) {
                ++iTargetNode;
            }
            int[] nCards = new int[nParents];
            for (int iParent = 0; iParent < nParents; ++iParent) {
                nCards[iParent] = this.getCardinality(parentSet.getParent(iParent));
            }
            int n = iTargetNode;
            nCards[n] = nCards[n] + 1;
            for (int iPos = 0; iPos < nParentCard; ++iPos) {
                int i;
                if (values2[iTargetNode] != nValue) {
                    newDistributions[iCurrentDist++] = distributions[iPos];
                }
                int n2 = i = 0;
                values2[n2] = values2[n2] + 1;
                while (i < nParents && values2[i] == nCards[i]) {
                    values2[i] = 0;
                    if (++i >= nParents) continue;
                    int n3 = i;
                    values2[n3] = values2[n3] + 1;
                }
            }
            this.m_Distributions[iNode] = newDistributions;
        }
        if (this.getEvidence(nTargetNode) > nValue) {
            this.setEvidence(nTargetNode, this.getEvidence(nTargetNode) - 1);
        }
    }

    public void setPosition(int iNode, int nX, int nY) {
        if (this.m_bNeedsUndoAction) {
            boolean isUpdate = false;
            UndoAction undoAction = null;
            try {
                if (this.m_undoStack.size() > 0) {
                    undoAction = (UndoAction)this.m_undoStack.elementAt(this.m_undoStack.size() - 1);
                    SetPositionAction posAction = (SetPositionAction)undoAction;
                    if (posAction.m_nTargetNode == iNode) {
                        isUpdate = true;
                        posAction.setUndoPosition(nX, nY);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!isUpdate) {
                this.addUndoAction(new SetPositionAction(iNode, nX, nY));
            }
        }
        this.m_nPositionX.setElementAt(nX, iNode);
        this.m_nPositionY.setElementAt(nY, iNode);
    }

    public void setPosition(int nNode, int nX, int nY, FastVector nodes) {
        int dX = nX - this.getPositionX(nNode);
        int dY = nY - this.getPositionY(nNode);
        if (this.m_bNeedsUndoAction) {
            boolean isUpdate = false;
            try {
                UndoAction undoAction = null;
                if (this.m_undoStack.size() > 0) {
                    undoAction = (UndoAction)this.m_undoStack.elementAt(this.m_undoStack.size() - 1);
                    SetGroupPositionAction posAction = (SetGroupPositionAction)undoAction;
                    isUpdate = true;
                    for (int iNode = 0; isUpdate && iNode < posAction.m_nodes.size(); ++iNode) {
                        if ((Integer)posAction.m_nodes.elementAt(iNode) == (Integer)nodes.elementAt(iNode)) continue;
                        isUpdate = false;
                    }
                    if (isUpdate) {
                        posAction.setUndoPosition(dX, dY);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!isUpdate) {
                this.addUndoAction(new SetGroupPositionAction(nodes, dX, dY));
            }
        }
        for (int iNode = 0; iNode < nodes.size(); ++iNode) {
            nNode = (Integer)nodes.elementAt(iNode);
            this.m_nPositionX.setElementAt(this.getPositionX(nNode) + dX, nNode);
            this.m_nPositionY.setElementAt(this.getPositionY(nNode) + dY, nNode);
        }
    }

    public void layoutGraph(FastVector nPosX, FastVector nPosY) {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new LayoutGraphAction(nPosX, nPosY));
        }
        this.m_nPositionX = nPosX;
        this.m_nPositionY = nPosY;
    }

    public int getPositionX(int iNode) {
        return (Integer)this.m_nPositionX.elementAt(iNode);
    }

    public int getPositionY(int iNode) {
        return (Integer)this.m_nPositionY.elementAt(iNode);
    }

    public void alignLeft(FastVector nodes) {
        int iNode;
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new alignLeftAction(nodes));
        }
        int nMinX = -1;
        for (iNode = 0; iNode < nodes.size(); ++iNode) {
            int nX = this.getPositionX((Integer)nodes.elementAt(iNode));
            if (nX >= nMinX && iNode != 0) continue;
            nMinX = nX;
        }
        for (iNode = 0; iNode < nodes.size(); ++iNode) {
            int nNode = (Integer)nodes.elementAt(iNode);
            this.m_nPositionX.setElementAt(nMinX, nNode);
        }
    }

    public void alignRight(FastVector nodes) {
        int iNode;
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new alignRightAction(nodes));
        }
        int nMaxX = -1;
        for (iNode = 0; iNode < nodes.size(); ++iNode) {
            int nX = this.getPositionX((Integer)nodes.elementAt(iNode));
            if (nX <= nMaxX && iNode != 0) continue;
            nMaxX = nX;
        }
        for (iNode = 0; iNode < nodes.size(); ++iNode) {
            int nNode = (Integer)nodes.elementAt(iNode);
            this.m_nPositionX.setElementAt(nMaxX, nNode);
        }
    }

    public void alignTop(FastVector nodes) {
        int iNode;
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new alignTopAction(nodes));
        }
        int nMinY = -1;
        for (iNode = 0; iNode < nodes.size(); ++iNode) {
            int nY = this.getPositionY((Integer)nodes.elementAt(iNode));
            if (nY >= nMinY && iNode != 0) continue;
            nMinY = nY;
        }
        for (iNode = 0; iNode < nodes.size(); ++iNode) {
            int nNode = (Integer)nodes.elementAt(iNode);
            this.m_nPositionY.setElementAt(nMinY, nNode);
        }
    }

    public void alignBottom(FastVector nodes) {
        int iNode;
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new alignBottomAction(nodes));
        }
        int nMaxY = -1;
        for (iNode = 0; iNode < nodes.size(); ++iNode) {
            int nY = this.getPositionY((Integer)nodes.elementAt(iNode));
            if (nY <= nMaxY && iNode != 0) continue;
            nMaxY = nY;
        }
        for (iNode = 0; iNode < nodes.size(); ++iNode) {
            int nNode = (Integer)nodes.elementAt(iNode);
            this.m_nPositionY.setElementAt(nMaxY, nNode);
        }
    }

    public void centerHorizontal(FastVector nodes) {
        int iNode;
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new centerHorizontalAction(nodes));
        }
        int nMinY = -1;
        int nMaxY = -1;
        for (iNode = 0; iNode < nodes.size(); ++iNode) {
            int nY = this.getPositionY((Integer)nodes.elementAt(iNode));
            if (nY < nMinY || iNode == 0) {
                nMinY = nY;
            }
            if (nY <= nMaxY && iNode != 0) continue;
            nMaxY = nY;
        }
        for (iNode = 0; iNode < nodes.size(); ++iNode) {
            int nNode = (Integer)nodes.elementAt(iNode);
            this.m_nPositionY.setElementAt((nMinY + nMaxY) / 2, nNode);
        }
    }

    public void centerVertical(FastVector nodes) {
        int iNode;
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new centerVerticalAction(nodes));
        }
        int nMinX = -1;
        int nMaxX = -1;
        for (iNode = 0; iNode < nodes.size(); ++iNode) {
            int nX = this.getPositionX((Integer)nodes.elementAt(iNode));
            if (nX < nMinX || iNode == 0) {
                nMinX = nX;
            }
            if (nX <= nMaxX && iNode != 0) continue;
            nMaxX = nX;
        }
        for (iNode = 0; iNode < nodes.size(); ++iNode) {
            int nNode = (Integer)nodes.elementAt(iNode);
            this.m_nPositionX.setElementAt((nMinX + nMaxX) / 2, nNode);
        }
    }

    public void spaceHorizontal(FastVector nodes) {
        int iNode;
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new spaceHorizontalAction(nodes));
        }
        int nMinX = -1;
        int nMaxX = -1;
        for (iNode = 0; iNode < nodes.size(); ++iNode) {
            int nX = this.getPositionX((Integer)nodes.elementAt(iNode));
            if (nX < nMinX || iNode == 0) {
                nMinX = nX;
            }
            if (nX <= nMaxX && iNode != 0) continue;
            nMaxX = nX;
        }
        for (iNode = 0; iNode < nodes.size(); ++iNode) {
            int nNode = (Integer)nodes.elementAt(iNode);
            this.m_nPositionX.setElementAt((int)((double)nMinX + (double)(iNode * (nMaxX - nMinX)) / ((double)nodes.size() - 1.0)), nNode);
        }
    }

    public void spaceVertical(FastVector nodes) {
        int iNode;
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new spaceVerticalAction(nodes));
        }
        int nMinY = -1;
        int nMaxY = -1;
        for (iNode = 0; iNode < nodes.size(); ++iNode) {
            int nY = this.getPositionY((Integer)nodes.elementAt(iNode));
            if (nY < nMinY || iNode == 0) {
                nMinY = nY;
            }
            if (nY <= nMaxY && iNode != 0) continue;
            nMaxY = nY;
        }
        for (iNode = 0; iNode < nodes.size(); ++iNode) {
            int nNode = (Integer)nodes.elementAt(iNode);
            this.m_nPositionY.setElementAt((int)((double)nMinY + (double)(iNode * (nMaxY - nMinY)) / ((double)nodes.size() - 1.0)), nNode);
        }
    }

    void replaceAtt(int nTargetNode, String sName, FastVector values) {
        Attribute newAtt = new Attribute(sName, values);
        if (this.m_Instances.classIndex() == nTargetNode) {
            this.m_Instances.setClassIndex(-1);
            this.m_Instances.deleteAttributeAt(nTargetNode);
            this.m_Instances.insertAttributeAt(newAtt, nTargetNode);
            this.m_Instances.setClassIndex(nTargetNode);
        } else {
            this.m_Instances.deleteAttributeAt(nTargetNode);
            this.m_Instances.insertAttributeAt(newAtt, nTargetNode);
        }
    }

    public double[] getMargin(int iNode) {
        return (double[])this.m_fMarginP.elementAt(iNode);
    }

    public void setMargin(int iNode, double[] fMarginP) {
        this.m_fMarginP.setElementAt(fMarginP, iNode);
    }

    public int getEvidence(int iNode) {
        return (Integer)this.m_nEvidence.elementAt(iNode);
    }

    public void setEvidence(int iNode, int iValue) {
        this.m_nEvidence.setElementAt(iValue, iNode);
    }

    public FastVector getChildren(int nTargetNode) {
        FastVector<Integer> children = new FastVector<Integer>();
        for (int iNode = 0; iNode < this.getNrOfNodes(); ++iNode) {
            if (!this.m_ParentSets[iNode].contains(nTargetNode)) continue;
            children.addElement(iNode);
        }
        return children;
    }

    @Override
    public String toXMLBIF03() {
        int iAttribute;
        if (this.m_Instances == null) {
            return "<!--No model built yet-->";
        }
        StringBuffer text = new StringBuffer();
        text.append(this.getBIFHeader());
        text.append("\n");
        text.append("\n");
        text.append("<BIF VERSION=\"0.3\">\n");
        text.append("<NETWORK>\n");
        text.append("<NAME>" + this.XMLNormalize(this.m_Instances.relationName()) + "</NAME>\n");
        for (iAttribute = 0; iAttribute < this.m_Instances.numAttributes(); ++iAttribute) {
            text.append("<VARIABLE TYPE=\"nature\">\n");
            text.append("<NAME>" + this.XMLNormalize(this.m_Instances.attribute(iAttribute).name()) + "</NAME>\n");
            for (int iValue = 0; iValue < this.m_Instances.attribute(iAttribute).numValues(); ++iValue) {
                text.append("<OUTCOME>" + this.XMLNormalize(this.m_Instances.attribute(iAttribute).value(iValue)) + "</OUTCOME>\n");
            }
            text.append("<PROPERTY>position = (" + this.getPositionX(iAttribute) + "," + this.getPositionY(iAttribute) + ")</PROPERTY>\n");
            text.append("</VARIABLE>\n");
        }
        for (iAttribute = 0; iAttribute < this.m_Instances.numAttributes(); ++iAttribute) {
            int iParent;
            text.append("<DEFINITION>\n");
            text.append("<FOR>" + this.XMLNormalize(this.m_Instances.attribute(iAttribute).name()) + "</FOR>\n");
            for (iParent = 0; iParent < this.m_ParentSets[iAttribute].getNrOfParents(); ++iParent) {
                text.append("<GIVEN>" + this.XMLNormalize(this.m_Instances.attribute(this.m_ParentSets[iAttribute].getParent(iParent)).name()) + "</GIVEN>\n");
            }
            text.append("<TABLE>\n");
            for (iParent = 0; iParent < this.m_ParentSets[iAttribute].getCardinalityOfParents(); ++iParent) {
                for (int iValue = 0; iValue < this.m_Instances.attribute(iAttribute).numValues(); ++iValue) {
                    text.append(this.m_Distributions[iAttribute][iParent].getProbability(iValue));
                    text.append(' ');
                }
                text.append('\n');
            }
            text.append("</TABLE>\n");
            text.append("</DEFINITION>\n");
        }
        text.append("</NETWORK>\n");
        text.append("</BIF>\n");
        return text.toString();
    }

    public String toXMLBIF03(FastVector nodes) {
        int nNode;
        int iNode;
        StringBuffer text = new StringBuffer();
        text.append(this.getBIFHeader());
        text.append("\n");
        text.append("\n");
        text.append("<BIF VERSION=\"0.3\">\n");
        text.append("<NETWORK>\n");
        text.append("<NAME>" + this.XMLNormalize(this.m_Instances.relationName()) + "</NAME>\n");
        for (iNode = 0; iNode < nodes.size(); ++iNode) {
            nNode = (Integer)nodes.elementAt(iNode);
            text.append("<VARIABLE TYPE=\"nature\">\n");
            text.append("<NAME>" + this.XMLNormalize(this.m_Instances.attribute(nNode).name()) + "</NAME>\n");
            for (int iValue = 0; iValue < this.m_Instances.attribute(nNode).numValues(); ++iValue) {
                text.append("<OUTCOME>" + this.XMLNormalize(this.m_Instances.attribute(nNode).value(iValue)) + "</OUTCOME>\n");
            }
            text.append("<PROPERTY>position = (" + this.getPositionX(nNode) + "," + this.getPositionY(nNode) + ")</PROPERTY>\n");
            text.append("</VARIABLE>\n");
        }
        for (iNode = 0; iNode < nodes.size(); ++iNode) {
            int iParent;
            nNode = (Integer)nodes.elementAt(iNode);
            text.append("<DEFINITION>\n");
            text.append("<FOR>" + this.XMLNormalize(this.m_Instances.attribute(nNode).name()) + "</FOR>\n");
            for (iParent = 0; iParent < this.m_ParentSets[nNode].getNrOfParents(); ++iParent) {
                text.append("<GIVEN>" + this.XMLNormalize(this.m_Instances.attribute(this.m_ParentSets[nNode].getParent(iParent)).name()) + "</GIVEN>\n");
            }
            text.append("<TABLE>\n");
            for (iParent = 0; iParent < this.m_ParentSets[nNode].getCardinalityOfParents(); ++iParent) {
                for (int iValue = 0; iValue < this.m_Instances.attribute(nNode).numValues(); ++iValue) {
                    text.append(this.m_Distributions[nNode][iParent].getProbability(iValue));
                    text.append(' ');
                }
                text.append('\n');
            }
            text.append("</TABLE>\n");
            text.append("</DEFINITION>\n");
        }
        text.append("</NETWORK>\n");
        text.append("</BIF>\n");
        return text.toString();
    }

    public boolean canUndo() {
        return this.m_nCurrentEditAction >= 0;
    }

    public boolean canRedo() {
        return this.m_nCurrentEditAction < this.m_undoStack.size() - 1;
    }

    public boolean isChanged() {
        return this.m_nCurrentEditAction != this.m_nSavedPointer;
    }

    public void isSaved() {
        this.m_nSavedPointer = this.m_nCurrentEditAction;
    }

    public String lastActionMsg() {
        if (this.m_undoStack.size() == 0) {
            return "";
        }
        return ((UndoAction)this.m_undoStack.lastElement()).getRedoMsg();
    }

    public String undo() {
        if (!this.canUndo()) {
            return "";
        }
        UndoAction undoAction = (UndoAction)this.m_undoStack.elementAt(this.m_nCurrentEditAction);
        this.m_bNeedsUndoAction = false;
        undoAction.undo();
        this.m_bNeedsUndoAction = true;
        --this.m_nCurrentEditAction;
        return undoAction.getUndoMsg();
    }

    public String redo() {
        if (!this.canRedo()) {
            return "";
        }
        ++this.m_nCurrentEditAction;
        UndoAction undoAction = (UndoAction)this.m_undoStack.elementAt(this.m_nCurrentEditAction);
        this.m_bNeedsUndoAction = false;
        undoAction.redo();
        this.m_bNeedsUndoAction = true;
        return undoAction.getRedoMsg();
    }

    void addUndoAction(UndoAction action) {
        int iAction = this.m_undoStack.size() - 1;
        while (iAction > this.m_nCurrentEditAction) {
            this.m_undoStack.removeElementAt(iAction--);
        }
        if (this.m_nSavedPointer > this.m_nCurrentEditAction) {
            this.m_nSavedPointer = -2;
        }
        this.m_undoStack.addElement(action);
        ++this.m_nCurrentEditAction;
    }

    public void clearUndoStack() {
        this.m_undoStack = new FastVector();
        this.m_nCurrentEditAction = -1;
        this.m_nSavedPointer = -1;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8048 $");
    }

    public static void main(String[] args) {
    }

    static /* synthetic */ ParentSet[] access$302(EditableBayesNet x0, ParentSet[] x1) {
        x0.m_ParentSets = x1;
        return x1;
    }

    static /* synthetic */ ParentSet[] access$702(EditableBayesNet x0, ParentSet[] x1) {
        x0.m_ParentSets = x1;
        return x1;
    }

    class PasteAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        int m_nBase;
        String m_sXML;

        PasteAction(String sXML, int nBase) {
            this.m_sXML = sXML;
            this.m_nBase = nBase;
        }

        @Override
        public void undo() {
            try {
                for (int iNode = EditableBayesNet.this.getNrOfNodes() - 1; iNode >= this.m_nBase; --iNode) {
                    EditableBayesNet.this.deleteNode(iNode);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void redo() {
            try {
                EditableBayesNet.this.paste(this.m_sXML, 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class LayoutGraphAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        FastVector m_nPosX;
        FastVector m_nPosY;
        FastVector m_nPosX2;
        FastVector m_nPosY2;

        LayoutGraphAction(FastVector nPosX, FastVector nPosY) {
            this.m_nPosX = new FastVector(nPosX.size());
            this.m_nPosY = new FastVector(nPosX.size());
            this.m_nPosX2 = new FastVector(nPosX.size());
            this.m_nPosY2 = new FastVector(nPosX.size());
            for (int iNode = 0; iNode < nPosX.size(); ++iNode) {
                this.m_nPosX.addElement(EditableBayesNet.this.m_nPositionX.elementAt(iNode));
                this.m_nPosY.addElement(EditableBayesNet.this.m_nPositionY.elementAt(iNode));
                this.m_nPosX2.addElement(nPosX.elementAt(iNode));
                this.m_nPosY2.addElement(nPosY.elementAt(iNode));
            }
        }

        @Override
        public void undo() {
            for (int iNode = 0; iNode < this.m_nPosX.size(); ++iNode) {
                EditableBayesNet.this.setPosition(iNode, (Integer)this.m_nPosX.elementAt(iNode), (Integer)this.m_nPosY.elementAt(iNode));
            }
        }

        @Override
        public void redo() {
            for (int iNode = 0; iNode < this.m_nPosX.size(); ++iNode) {
                EditableBayesNet.this.setPosition(iNode, (Integer)this.m_nPosX2.elementAt(iNode), (Integer)this.m_nPosY2.elementAt(iNode));
            }
        }
    }

    class SetGroupPositionAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        FastVector m_nodes;
        int m_dX;
        int m_dY;

        SetGroupPositionAction(FastVector nodes, int dX, int dY) {
            this.m_nodes = new FastVector(nodes.size());
            for (int iNode = 0; iNode < nodes.size(); ++iNode) {
                this.m_nodes.addElement(nodes.elementAt(iNode));
            }
            this.m_dX = dX;
            this.m_dY = dY;
        }

        @Override
        public void undo() {
            for (int iNode = 0; iNode < this.m_nodes.size(); ++iNode) {
                int nNode = (Integer)this.m_nodes.elementAt(iNode);
                EditableBayesNet.this.setPosition(nNode, EditableBayesNet.this.getPositionX(nNode) - this.m_dX, EditableBayesNet.this.getPositionY(nNode) - this.m_dY);
            }
        }

        @Override
        public void redo() {
            for (int iNode = 0; iNode < this.m_nodes.size(); ++iNode) {
                int nNode = (Integer)this.m_nodes.elementAt(iNode);
                EditableBayesNet.this.setPosition(nNode, EditableBayesNet.this.getPositionX(nNode) + this.m_dX, EditableBayesNet.this.getPositionY(nNode) + this.m_dY);
            }
        }

        public void setUndoPosition(int dX, int dY) {
            this.m_dX += dX;
            this.m_dY += dY;
        }
    }

    class SetPositionAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        int m_nTargetNode;
        int m_nX;
        int m_nY;
        int m_nX2;
        int m_nY2;

        SetPositionAction(int nTargetNode, int nX, int nY) {
            this.m_nTargetNode = nTargetNode;
            this.m_nX2 = nX;
            this.m_nY2 = nY;
            this.m_nX = EditableBayesNet.this.getPositionX(nTargetNode);
            this.m_nY = EditableBayesNet.this.getPositionY(nTargetNode);
        }

        @Override
        public void undo() {
            EditableBayesNet.this.setPosition(this.m_nTargetNode, this.m_nX, this.m_nY);
        }

        @Override
        public void redo() {
            EditableBayesNet.this.setPosition(this.m_nTargetNode, this.m_nX2, this.m_nY2);
        }

        public void setUndoPosition(int nX, int nY) {
            this.m_nX2 = nX;
            this.m_nY2 = nY;
        }
    }

    class spaceVerticalAction
    extends alignAction {
        static final long serialVersionUID = 1L;

        public spaceVerticalAction(FastVector nodes) {
            super(nodes);
        }

        @Override
        public void redo() {
            try {
                EditableBayesNet.this.spaceVertical(this.m_nodes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public String getUndoMsg() {
            return "Returning " + this.m_nodes.size() + " from spaceng vertically.";
        }

        @Override
        public String getRedoMsg() {
            return "Spaceng " + this.m_nodes.size() + " nodes vertically.";
        }
    }

    class spaceHorizontalAction
    extends alignAction {
        static final long serialVersionUID = 1L;

        public spaceHorizontalAction(FastVector nodes) {
            super(nodes);
        }

        @Override
        public void redo() {
            try {
                EditableBayesNet.this.spaceHorizontal(this.m_nodes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public String getUndoMsg() {
            return "Returning " + this.m_nodes.size() + " from spaceing horizontally.";
        }

        @Override
        public String getRedoMsg() {
            return "spaceing " + this.m_nodes.size() + " nodes horizontally.";
        }
    }

    class centerVerticalAction
    extends alignAction {
        static final long serialVersionUID = 1L;

        public centerVerticalAction(FastVector nodes) {
            super(nodes);
        }

        @Override
        public void redo() {
            try {
                EditableBayesNet.this.centerVertical(this.m_nodes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public String getUndoMsg() {
            return "Returning " + this.m_nodes.size() + " from centering vertically.";
        }

        @Override
        public String getRedoMsg() {
            return "Centering " + this.m_nodes.size() + " nodes vertically.";
        }
    }

    class centerHorizontalAction
    extends alignAction {
        static final long serialVersionUID = 1L;

        public centerHorizontalAction(FastVector nodes) {
            super(nodes);
        }

        @Override
        public void redo() {
            try {
                EditableBayesNet.this.centerHorizontal(this.m_nodes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public String getUndoMsg() {
            return "Returning " + this.m_nodes.size() + " from centering horizontally.";
        }

        @Override
        public String getRedoMsg() {
            return "Centering " + this.m_nodes.size() + " nodes horizontally.";
        }
    }

    class alignBottomAction
    extends alignAction {
        static final long serialVersionUID = 1L;

        public alignBottomAction(FastVector nodes) {
            super(nodes);
        }

        @Override
        public void redo() {
            try {
                EditableBayesNet.this.alignBottom(this.m_nodes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public String getUndoMsg() {
            return "Returning " + this.m_nodes.size() + " from aliging nodes to the bottom.";
        }

        @Override
        public String getRedoMsg() {
            return "Aligning " + this.m_nodes.size() + " nodes to the bottom.";
        }
    }

    class alignTopAction
    extends alignAction {
        static final long serialVersionUID = 1L;

        public alignTopAction(FastVector nodes) {
            super(nodes);
        }

        @Override
        public void redo() {
            try {
                EditableBayesNet.this.alignTop(this.m_nodes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public String getUndoMsg() {
            return "Returning " + this.m_nodes.size() + " from aliging nodes to the top.";
        }

        @Override
        public String getRedoMsg() {
            return "Aligning " + this.m_nodes.size() + " nodes to the top.";
        }
    }

    class alignRightAction
    extends alignAction {
        static final long serialVersionUID = 1L;

        public alignRightAction(FastVector nodes) {
            super(nodes);
        }

        @Override
        public void redo() {
            try {
                EditableBayesNet.this.alignRight(this.m_nodes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public String getUndoMsg() {
            return "Returning " + this.m_nodes.size() + " from aliging nodes to the right.";
        }

        @Override
        public String getRedoMsg() {
            return "Aligning " + this.m_nodes.size() + " nodes to the right.";
        }
    }

    class alignLeftAction
    extends alignAction {
        static final long serialVersionUID = 1L;

        public alignLeftAction(FastVector nodes) {
            super(nodes);
        }

        @Override
        public void redo() {
            try {
                EditableBayesNet.this.alignLeft(this.m_nodes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public String getUndoMsg() {
            return "Returning " + this.m_nodes.size() + " from aliging nodes to the left.";
        }

        @Override
        public String getRedoMsg() {
            return "Aligning " + this.m_nodes.size() + " nodes to the left.";
        }
    }

    class alignAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        FastVector m_nodes;
        FastVector m_posX;
        FastVector m_posY;

        alignAction(FastVector nodes) {
            this.m_nodes = new FastVector(nodes.size());
            this.m_posX = new FastVector(nodes.size());
            this.m_posY = new FastVector(nodes.size());
            for (int iNode = 0; iNode < nodes.size(); ++iNode) {
                int nNode = (Integer)nodes.elementAt(iNode);
                this.m_nodes.addElement(nNode);
                this.m_posX.addElement(EditableBayesNet.this.getPositionX(nNode));
                this.m_posY.addElement(EditableBayesNet.this.getPositionY(nNode));
            }
        }

        @Override
        public void undo() {
            try {
                for (int iNode = 0; iNode < this.m_nodes.size(); ++iNode) {
                    int nNode = (Integer)this.m_nodes.elementAt(iNode);
                    EditableBayesNet.this.setPosition(nNode, (Integer)this.m_posX.elementAt(iNode), (Integer)this.m_posY.elementAt(iNode));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class DelValueAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        int m_nTargetNode;
        String m_sValue;
        Estimator[] m_CPT;
        FastVector m_children;
        Estimator[][] m_childAtts;
        Attribute m_att;

        DelValueAction(int nTargetNode, String sValue) {
            try {
                this.m_nTargetNode = nTargetNode;
                this.m_sValue = sValue;
                this.m_att = EditableBayesNet.this.m_Instances.attribute(nTargetNode);
                SerializedObject so = new SerializedObject(EditableBayesNet.this.m_Distributions[nTargetNode]);
                this.m_CPT = (Estimator[])so.getObject();
                this.m_children = new FastVector();
                for (int iNode = 0; iNode < EditableBayesNet.this.getNrOfNodes(); ++iNode) {
                    if (!EditableBayesNet.this.m_ParentSets[iNode].contains(nTargetNode)) continue;
                    this.m_children.addElement(iNode);
                }
                this.m_childAtts = new Estimator[this.m_children.size()][];
                for (int iChild = 0; iChild < this.m_children.size(); ++iChild) {
                    int nChild = (Integer)this.m_children.elementAt(iChild);
                    this.m_childAtts[iChild] = EditableBayesNet.this.m_Distributions[nChild];
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void undo() {
            try {
                EditableBayesNet.this.m_Instances.insertAttributeAt(this.m_att, this.m_nTargetNode);
                SerializedObject so = new SerializedObject(this.m_CPT);
                EditableBayesNet.this.m_Distributions[this.m_nTargetNode] = (Estimator[])so.getObject();
                for (int iChild = 0; iChild < this.m_children.size(); ++iChild) {
                    int nChild = (Integer)this.m_children.elementAt(iChild);
                    EditableBayesNet.this.m_Instances.insertAttributeAt(this.m_att, this.m_nTargetNode);
                    so = new SerializedObject(this.m_childAtts[iChild]);
                    EditableBayesNet.this.m_Distributions[nChild] = (Estimator[])so.getObject();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void redo() {
            try {
                EditableBayesNet.this.delNodeValue(this.m_nTargetNode, this.m_sValue);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public String getUndoMsg() {
            return "Value " + this.m_sValue + " added to node " + EditableBayesNet.this.getNodeName(this.m_nTargetNode);
        }

        @Override
        public String getRedoMsg() {
            return "Value " + this.m_sValue + " removed from node " + EditableBayesNet.this.getNodeName(this.m_nTargetNode);
        }
    }

    class AddValueAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        int m_nTargetNode;
        String m_sValue;

        AddValueAction(int nTargetNode, String sValue) {
            this.m_nTargetNode = nTargetNode;
            this.m_sValue = sValue;
        }

        @Override
        public void undo() {
            try {
                EditableBayesNet.this.delNodeValue(this.m_nTargetNode, this.m_sValue);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void redo() {
            EditableBayesNet.this.addNodeValue(this.m_nTargetNode, this.m_sValue);
        }

        @Override
        public String getUndoMsg() {
            return "Value " + this.m_sValue + " removed from node " + EditableBayesNet.this.getNodeName(this.m_nTargetNode);
        }

        @Override
        public String getRedoMsg() {
            return "Value " + this.m_sValue + " added to node " + EditableBayesNet.this.getNodeName(this.m_nTargetNode);
        }
    }

    class RenameValueAction
    extends RenameAction {
        static final long serialVersionUID = 1L;

        RenameValueAction(int nTargetNode, String sOldName, String sNewName) {
            super(nTargetNode, sOldName, sNewName);
        }

        @Override
        public void undo() {
            EditableBayesNet.this.renameNodeValue(this.m_nTargetNode, this.m_sNewName, this.m_sOldName);
        }

        @Override
        public void redo() {
            EditableBayesNet.this.renameNodeValue(this.m_nTargetNode, this.m_sOldName, this.m_sNewName);
        }

        @Override
        public String getUndoMsg() {
            return "Value of node " + EditableBayesNet.this.getNodeName(this.m_nTargetNode) + " changed from " + this.m_sNewName + " to " + this.m_sOldName;
        }

        @Override
        public String getRedoMsg() {
            return "Value of node " + EditableBayesNet.this.getNodeName(this.m_nTargetNode) + " changed from " + this.m_sOldName + " to " + this.m_sNewName;
        }
    }

    class RenameAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        int m_nTargetNode;
        String m_sNewName;
        String m_sOldName;

        RenameAction(int nTargetNode, String sOldName, String sNewName) {
            this.m_nTargetNode = nTargetNode;
            this.m_sNewName = sNewName;
            this.m_sOldName = sOldName;
        }

        @Override
        public void undo() {
            EditableBayesNet.this.setNodeName(this.m_nTargetNode, this.m_sOldName);
        }

        @Override
        public void redo() {
            EditableBayesNet.this.setNodeName(this.m_nTargetNode, this.m_sNewName);
        }
    }

    class SetDistributionAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        int m_nTargetNode;
        Estimator[] m_CPT;
        double[][] m_P;

        SetDistributionAction(int nTargetNode, double[][] P) {
            try {
                this.m_nTargetNode = nTargetNode;
                SerializedObject so = new SerializedObject(EditableBayesNet.this.m_Distributions[nTargetNode]);
                this.m_CPT = (Estimator[])so.getObject();
                this.m_P = P;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void undo() {
            try {
                SerializedObject so = new SerializedObject(this.m_CPT);
                EditableBayesNet.this.m_Distributions[this.m_nTargetNode] = (Estimator[])so.getObject();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void redo() {
            try {
                EditableBayesNet.this.setDistribution(this.m_nTargetNode, this.m_P);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public String getUndoMsg() {
            return "Distribution of node " + EditableBayesNet.this.getNodeName(this.m_nTargetNode) + " changed";
        }

        @Override
        public String getRedoMsg() {
            return "Distribution of node " + EditableBayesNet.this.getNodeName(this.m_nTargetNode) + " changed";
        }
    }

    class DeleteArcAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        int[] m_nParents;
        int m_nChild;
        int m_nParent;
        Estimator[] m_CPT;

        DeleteArcAction(int nParent, int nChild) {
            try {
                this.m_nChild = nChild;
                this.m_nParent = nParent;
                this.m_nParents = new int[EditableBayesNet.this.getNrOfParents(nChild)];
                for (int iParent = 0; iParent < this.m_nParents.length; ++iParent) {
                    this.m_nParents[iParent] = EditableBayesNet.this.getParent(nChild, iParent);
                }
                SerializedObject so = new SerializedObject(EditableBayesNet.this.m_Distributions[nChild]);
                this.m_CPT = (Estimator[])so.getObject();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void undo() {
            try {
                SerializedObject so = new SerializedObject(this.m_CPT);
                EditableBayesNet.this.m_Distributions[this.m_nChild] = (Estimator[])so.getObject();
                ParentSet parentSet = new ParentSet();
                for (int iParent = 0; iParent < this.m_nParents.length; ++iParent) {
                    parentSet.addParent(this.m_nParents[iParent], EditableBayesNet.this.m_Instances);
                }
                ((EditableBayesNet)EditableBayesNet.this).m_ParentSets[this.m_nChild] = parentSet;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void redo() {
            try {
                EditableBayesNet.this.deleteArc(this.m_nParent, this.m_nChild);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class AddArcAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        FastVector m_children;
        int m_nParent;
        Estimator[][] m_CPT;

        AddArcAction(int nParent, int nChild) {
            try {
                this.m_nParent = nParent;
                this.m_children = new FastVector();
                this.m_children.addElement(nChild);
                SerializedObject so = new SerializedObject(EditableBayesNet.this.m_Distributions[nChild]);
                this.m_CPT = new Estimator[1][];
                this.m_CPT[0] = (Estimator[])so.getObject();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        AddArcAction(int nParent, FastVector children) {
            try {
                this.m_nParent = nParent;
                this.m_children = new FastVector();
                this.m_CPT = new Estimator[children.size()][];
                for (int iChild = 0; iChild < children.size(); ++iChild) {
                    int nChild = (Integer)children.elementAt(iChild);
                    this.m_children.addElement(nChild);
                    SerializedObject so = new SerializedObject(EditableBayesNet.this.m_Distributions[nChild]);
                    this.m_CPT[iChild] = (Estimator[])so.getObject();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void undo() {
            try {
                for (int iChild = 0; iChild < this.m_children.size(); ++iChild) {
                    int nChild = (Integer)this.m_children.elementAt(iChild);
                    EditableBayesNet.this.deleteArc(this.m_nParent, nChild);
                    SerializedObject so = new SerializedObject(this.m_CPT[iChild]);
                    EditableBayesNet.this.m_Distributions[nChild] = (Estimator[])so.getObject();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void redo() {
            try {
                for (int iChild = 0; iChild < this.m_children.size(); ++iChild) {
                    int nChild = (Integer)this.m_children.elementAt(iChild);
                    EditableBayesNet.this.addArc(this.m_nParent, nChild);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class DeleteSelectionAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        FastVector m_nodes;
        Attribute[] m_att;
        Estimator[][] m_CPT;
        ParentSet[] m_ParentSet;
        FastVector m_deleteArcActions;
        int[] m_nPosX;
        int[] m_nPosY;

        public DeleteSelectionAction(FastVector nodes) {
            this.m_nodes = new FastVector();
            int nNodes = nodes.size();
            this.m_att = new Attribute[nNodes];
            this.m_CPT = new Estimator[nNodes][];
            this.m_ParentSet = new ParentSet[nNodes];
            this.m_nPosX = new int[nNodes];
            this.m_nPosY = new int[nNodes];
            this.m_deleteArcActions = new FastVector();
            for (int iNode = 0; iNode < nodes.size(); ++iNode) {
                int nTargetNode = (Integer)nodes.elementAt(iNode);
                this.m_nodes.addElement(nTargetNode);
                this.m_att[iNode] = EditableBayesNet.this.m_Instances.attribute(nTargetNode);
                try {
                    SerializedObject so = new SerializedObject(EditableBayesNet.this.m_Distributions[nTargetNode]);
                    this.m_CPT[iNode] = (Estimator[])so.getObject();
                    so = new SerializedObject(EditableBayesNet.this.m_ParentSets[nTargetNode]);
                    this.m_ParentSet[iNode] = (ParentSet)so.getObject();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.m_nPosX[iNode] = EditableBayesNet.this.getPositionX(nTargetNode);
                this.m_nPosY[iNode] = EditableBayesNet.this.getPositionY(nTargetNode);
                for (int iNode2 = 0; iNode2 < EditableBayesNet.this.getNrOfNodes(); ++iNode2) {
                    if (nodes.contains(iNode2) || !EditableBayesNet.this.m_ParentSets[iNode2].contains(nTargetNode)) continue;
                    this.m_deleteArcActions.addElement(new DeleteArcAction(nTargetNode, iNode2));
                }
            }
        }

        @Override
        public void undo() {
            try {
                int iNode;
                int iNode2;
                for (int iNode3 = 0; iNode3 < this.m_nodes.size(); ++iNode3) {
                    int nTargetNode = (Integer)this.m_nodes.elementAt(iNode3);
                    EditableBayesNet.this.m_Instances.insertAttributeAt(this.m_att[iNode3], nTargetNode);
                }
                int nAtts = EditableBayesNet.this.m_Instances.numAttributes();
                ParentSet[] parentSets = new ParentSet[nAtts];
                int[] offset = new int[nAtts];
                for (iNode2 = 0; iNode2 < nAtts; ++iNode2) {
                    offset[iNode2] = iNode2;
                }
                for (iNode2 = this.m_nodes.size() - 1; iNode2 >= 0; --iNode2) {
                    int nTargetNode;
                    for (int i = nTargetNode = ((Integer)this.m_nodes.elementAt(iNode2)).intValue(); i < nAtts - 1; ++i) {
                        offset[i] = offset[i + 1];
                    }
                }
                int iTargetNode = 0;
                for (int iParentSet = 0; iParentSet < nAtts; ++iParentSet) {
                    if (iTargetNode < this.m_nodes.size() && (Integer)this.m_nodes.elementAt(iTargetNode) == Integer.valueOf(iParentSet)) {
                        SerializedObject so = new SerializedObject(this.m_ParentSet[iTargetNode]);
                        parentSets[iParentSet] = (ParentSet)so.getObject();
                        ++iTargetNode;
                        continue;
                    }
                    parentSets[iParentSet] = EditableBayesNet.this.m_ParentSets[iParentSet - iTargetNode];
                    for (int iParent = 0; iParent < parentSets[iParentSet].getNrOfParents(); ++iParent) {
                        int nParent = parentSets[iParentSet].getParent(iParent);
                        parentSets[iParentSet].SetParent(iParent, offset[nParent]);
                    }
                }
                EditableBayesNet.access$702(EditableBayesNet.this, parentSets);
                Estimator[][] distributions = new Estimator[nAtts][];
                iTargetNode = 0;
                for (iNode = 0; iNode < nAtts; ++iNode) {
                    if (iTargetNode < this.m_nodes.size() && (Integer)this.m_nodes.elementAt(iTargetNode) == Integer.valueOf(iNode)) {
                        SerializedObject so = new SerializedObject(this.m_CPT[iTargetNode]);
                        distributions[iNode] = (Estimator[])so.getObject();
                        ++iTargetNode;
                        continue;
                    }
                    distributions[iNode] = EditableBayesNet.this.m_Distributions[iNode - iTargetNode];
                }
                EditableBayesNet.this.m_Distributions = distributions;
                for (iNode = 0; iNode < this.m_nodes.size(); ++iNode) {
                    int nTargetNode = (Integer)this.m_nodes.elementAt(iNode);
                    EditableBayesNet.this.m_nPositionX.insertElementAt(this.m_nPosX[iNode], nTargetNode);
                    EditableBayesNet.this.m_nPositionY.insertElementAt(this.m_nPosY[iNode], nTargetNode);
                    EditableBayesNet.this.m_nEvidence.insertElementAt(-1, nTargetNode);
                    EditableBayesNet.this.m_fMarginP.insertElementAt(new double[EditableBayesNet.this.getCardinality(nTargetNode)], nTargetNode);
                }
                for (int deletedArc = 0; deletedArc < this.m_deleteArcActions.size(); ++deletedArc) {
                    DeleteArcAction action = (DeleteArcAction)this.m_deleteArcActions.elementAt(deletedArc);
                    action.undo();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void redo() {
            try {
                for (int iNode = this.m_nodes.size() - 1; iNode >= 0; --iNode) {
                    int nNode = (Integer)this.m_nodes.elementAt(iNode);
                    EditableBayesNet.this.deleteNode(nNode);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class DeleteNodeAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        int m_nTargetNode;
        Attribute m_att;
        Estimator[] m_CPT;
        ParentSet m_ParentSet;
        FastVector m_deleteArcActions;
        int m_nPosX;
        int m_nPosY;

        DeleteNodeAction(int nTargetNode) {
            this.m_nTargetNode = nTargetNode;
            this.m_att = EditableBayesNet.this.m_Instances.attribute(nTargetNode);
            try {
                SerializedObject so = new SerializedObject(EditableBayesNet.this.m_Distributions[nTargetNode]);
                this.m_CPT = (Estimator[])so.getObject();
                so = new SerializedObject(EditableBayesNet.this.m_ParentSets[nTargetNode]);
                this.m_ParentSet = (ParentSet)so.getObject();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.m_deleteArcActions = new FastVector();
            for (int iNode = 0; iNode < EditableBayesNet.this.getNrOfNodes(); ++iNode) {
                if (!EditableBayesNet.this.m_ParentSets[iNode].contains(nTargetNode)) continue;
                this.m_deleteArcActions.addElement(new DeleteArcAction(nTargetNode, iNode));
            }
            this.m_nPosX = EditableBayesNet.this.getPositionX(this.m_nTargetNode);
            this.m_nPosY = EditableBayesNet.this.getPositionY(this.m_nTargetNode);
        }

        @Override
        public void undo() {
            try {
                EditableBayesNet.this.m_Instances.insertAttributeAt(this.m_att, this.m_nTargetNode);
                int nAtts = EditableBayesNet.this.m_Instances.numAttributes();
                ParentSet[] parentSets = new ParentSet[nAtts];
                int nX = 0;
                for (int iParentSet = 0; iParentSet < nAtts; ++iParentSet) {
                    if (iParentSet == this.m_nTargetNode) {
                        SerializedObject so = new SerializedObject(this.m_ParentSet);
                        parentSets[iParentSet] = (ParentSet)so.getObject();
                        nX = 1;
                        continue;
                    }
                    parentSets[iParentSet] = EditableBayesNet.this.m_ParentSets[iParentSet - nX];
                    for (int iParent = 0; iParent < parentSets[iParentSet].getNrOfParents(); ++iParent) {
                        int nParent = parentSets[iParentSet].getParent(iParent);
                        if (nParent < this.m_nTargetNode) continue;
                        parentSets[iParentSet].SetParent(iParent, nParent + 1);
                    }
                }
                EditableBayesNet.access$302(EditableBayesNet.this, parentSets);
                Estimator[][] distributions = new Estimator[nAtts][];
                nX = 0;
                for (int iNode = 0; iNode < nAtts; ++iNode) {
                    if (iNode == this.m_nTargetNode) {
                        SerializedObject so = new SerializedObject(this.m_CPT);
                        distributions[iNode] = (Estimator[])so.getObject();
                        nX = 1;
                        continue;
                    }
                    distributions[iNode] = EditableBayesNet.this.m_Distributions[iNode - nX];
                }
                EditableBayesNet.this.m_Distributions = distributions;
                for (int deletedArc = 0; deletedArc < this.m_deleteArcActions.size(); ++deletedArc) {
                    DeleteArcAction action = (DeleteArcAction)this.m_deleteArcActions.elementAt(deletedArc);
                    action.undo();
                }
                EditableBayesNet.this.m_nPositionX.insertElementAt(this.m_nPosX, this.m_nTargetNode);
                EditableBayesNet.this.m_nPositionY.insertElementAt(this.m_nPosY, this.m_nTargetNode);
                EditableBayesNet.this.m_nEvidence.insertElementAt(-1, this.m_nTargetNode);
                EditableBayesNet.this.m_fMarginP.insertElementAt(new double[EditableBayesNet.this.getCardinality(this.m_nTargetNode)], this.m_nTargetNode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void redo() {
            try {
                EditableBayesNet.this.deleteNode(this.m_nTargetNode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class AddNodeAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        String m_sName;
        int m_nPosX;
        int m_nPosY;
        int m_nCardinality;

        AddNodeAction(String sName, int nCardinality, int nPosX, int nPosY) {
            this.m_sName = sName;
            this.m_nCardinality = nCardinality;
            this.m_nPosX = nPosX;
            this.m_nPosY = nPosY;
        }

        @Override
        public void undo() {
            try {
                EditableBayesNet.this.deleteNode(EditableBayesNet.this.getNrOfNodes() - 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void redo() {
            try {
                EditableBayesNet.this.addNode(this.m_sName, this.m_nCardinality, this.m_nPosX, this.m_nPosY);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class UndoAction
    implements Serializable {
        static final long serialVersionUID = 1L;

        UndoAction() {
        }

        public void undo() {
        }

        public void redo() {
        }

        public String getUndoMsg() {
            return this.getMsg();
        }

        public String getRedoMsg() {
            return this.getMsg();
        }

        String getMsg() {
            String sStr = this.toString();
            int iStart = sStr.indexOf(36);
            int iEnd = sStr.indexOf(64);
            StringBuffer sBuffer = new StringBuffer();
            for (int i = iStart + 1; i < iEnd; ++i) {
                char c = sStr.charAt(i);
                if (Character.isUpperCase(c)) {
                    sBuffer.append(' ');
                }
                sBuffer.append(sStr.charAt(i));
            }
            return sBuffer.toString();
        }
    }
}

