/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AbstractService;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.replication.ChainWALEntryFilter;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfigListener;
import org.apache.hadoop.hbase.replication.ScopeWALEntryFilter;
import org.apache.hadoop.hbase.replication.TableCfWALEntryFilter;
import org.apache.hadoop.hbase.replication.WALEntryFilter;

@InterfaceAudience.LimitedPrivate(value={"Replication"})
public abstract class BaseReplicationEndpoint
extends AbstractService
implements ReplicationEndpoint {
    private static final Log LOG = LogFactory.getLog(BaseReplicationEndpoint.class);
    protected ReplicationEndpoint.Context ctx;

    @Override
    public void init(ReplicationEndpoint.Context context) throws IOException {
        this.ctx = context;
        if (this.ctx != null) {
            ReplicationPeer peer = this.ctx.getReplicationPeer();
            if (peer != null) {
                peer.trackPeerConfigChanges((ReplicationPeerConfigListener)this);
            } else {
                LOG.warn((Object)("Not tracking replication peer config changes for Peer Id " + this.ctx.getPeerId() + " because there's no such peer"));
            }
        }
    }

    public void peerConfigUpdated(ReplicationPeerConfig rpc) {
    }

    @Override
    public WALEntryFilter getWALEntryfilter() {
        String filterNameCSV;
        WALEntryFilter tableCfFilter;
        ArrayList filters = Lists.newArrayList();
        WALEntryFilter scopeFilter = this.getScopeWALEntryFilter();
        if (scopeFilter != null) {
            filters.add(scopeFilter);
        }
        if ((tableCfFilter = this.getTableCfWALEntryFilter()) != null) {
            filters.add(tableCfFilter);
        }
        if (this.ctx != null && this.ctx.getPeerConfig() != null && (filterNameCSV = (String)this.ctx.getPeerConfig().getConfiguration().get("hbase.replication.source.custom.walentryfilters")) != null && !filterNameCSV.isEmpty()) {
            String[] filterNames;
            for (String filterName : filterNames = filterNameCSV.split(",")) {
                try {
                    Class<?> clazz = Class.forName(filterName);
                    filters.add((WALEntryFilter)clazz.newInstance());
                }
                catch (Exception e) {
                    LOG.error((Object)("Unable to create WALEntryFilter " + filterName), (Throwable)e);
                }
            }
        }
        return filters.isEmpty() ? null : new ChainWALEntryFilter(filters);
    }

    protected WALEntryFilter getScopeWALEntryFilter() {
        return new ScopeWALEntryFilter();
    }

    protected WALEntryFilter getTableCfWALEntryFilter() {
        return new TableCfWALEntryFilter(this.ctx.getReplicationPeer());
    }

    @Override
    public boolean canReplicateToSameCluster() {
        return false;
    }

    public void close() {
        if (this.ctx != null) {
            ReplicationPeer peer = this.ctx.getReplicationPeer();
            peer.removeListenerOfPeerConfig((ReplicationPeerConfigListener)this);
        }
    }
}

