/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.big.data.bundles.impl.shim.hbase.mapping;

import com.google.common.collect.Maps;
import com.pentaho.big.data.bundles.impl.shim.hbase.meta.HBaseValueMetaInterfaceFactoryImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.hadoop.shim.api.hbase.mapping.Mapping;
import org.pentaho.hadoop.shim.api.hbase.meta.HBaseValueMetaInterface;
import org.pentaho.hadoop.shim.api.internal.hbase.HBaseBytesUtilShim;
import org.pentaho.hadoop.shim.api.internal.hbase.HBaseValueMeta;
import org.pentaho.hadoop.shim.api.internal.hbase.Mapping;
import org.w3c.dom.Node;

public class MappingImpl
implements org.pentaho.hadoop.shim.api.hbase.mapping.Mapping {
    private final Mapping delegate;
    private final HBaseBytesUtilShim hBaseBytesUtilShim;
    private final HBaseValueMetaInterfaceFactoryImpl hBaseValueMetaInterfaceFactory;

    public MappingImpl(Mapping delegate, HBaseBytesUtilShim hBaseBytesUtilShim, HBaseValueMetaInterfaceFactoryImpl hBaseValueMetaInterfaceFactory) {
        this.delegate = delegate;
        this.hBaseBytesUtilShim = hBaseBytesUtilShim;
        this.hBaseValueMetaInterfaceFactory = hBaseValueMetaInterfaceFactory;
    }

    public String addMappedColumn(HBaseValueMetaInterface column, boolean isTupleColumn) throws Exception {
        if (column instanceof HBaseValueMeta) {
            return this.delegate.addMappedColumn((HBaseValueMeta)column, isTupleColumn);
        }
        return this.delegate.addMappedColumn(this.hBaseValueMetaInterfaceFactory.copy(column), isTupleColumn);
    }

    public String getTableName() {
        return this.delegate.getTableName();
    }

    public void setTableName(String tableName) {
        this.delegate.setTableName(tableName);
    }

    public String getMappingName() {
        return this.delegate.getMappingName();
    }

    public void setMappingName(String mappingName) {
        this.delegate.setMappingName(mappingName);
    }

    public String getKeyName() {
        return this.delegate.getKeyName();
    }

    public void setKeyName(String keyName) {
        this.delegate.setKeyName(keyName);
    }

    public void setKeyTypeAsString(String type) throws Exception {
        this.delegate.setKeyTypeAsString(type);
    }

    public Mapping.KeyType getKeyType() {
        Mapping.KeyType keyType = this.delegate.getKeyType();
        if (keyType == null) {
            return null;
        }
        return Mapping.KeyType.valueOf((String)keyType.name());
    }

    public void setKeyType(Mapping.KeyType type) {
        if (type == null) {
            this.delegate.setKeyType(null);
        } else {
            this.delegate.setKeyType(Mapping.KeyType.valueOf(type.name()));
        }
    }

    public boolean isTupleMapping() {
        return this.delegate.isTupleMapping();
    }

    public void setTupleMapping(boolean t) {
        this.delegate.setTupleMapping(t);
    }

    public String getTupleFamilies() {
        return this.delegate.getTupleFamilies();
    }

    public void setTupleFamilies(String f) {
        this.delegate.setTupleFamilies(f);
    }

    public int numMappedColumns() {
        return this.delegate.getMappedColumns().size();
    }

    public String[] getTupleFamiliesSplit() {
        return this.getTupleFamilies().split(",");
    }

    public Map<String, HBaseValueMetaInterface> getMappedColumns() {
        return Collections.unmodifiableMap(Maps.transformEntries(this.delegate.getMappedColumns(), (Maps.EntryTransformer)new Maps.EntryTransformer<String, HBaseValueMeta, HBaseValueMetaInterface>(){

            public HBaseValueMetaInterface transformEntry(String key, HBaseValueMeta value) {
                if (value instanceof HBaseValueMetaInterface) {
                    return (HBaseValueMetaInterface)value;
                }
                return MappingImpl.this.hBaseValueMetaInterfaceFactory.copy(value);
            }
        }));
    }

    public void setMappedColumns(Map<String, HBaseValueMetaInterface> cols) {
        this.delegate.setMappedColumns(new HashMap<String, HBaseValueMeta>(Maps.transformEntries(cols, (Maps.EntryTransformer)new Maps.EntryTransformer<String, HBaseValueMetaInterface, HBaseValueMeta>(){

            public HBaseValueMeta transformEntry(String key, HBaseValueMetaInterface value) {
                if (value instanceof HBaseValueMeta) {
                    return (HBaseValueMeta)value;
                }
                return MappingImpl.this.hBaseValueMetaInterfaceFactory.copy(value);
            }
        })));
    }

    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        this.delegate.saveRep(rep, id_transformation, id_step);
    }

    public String getXML() {
        return this.delegate.getXML();
    }

    public boolean loadXML(Node stepnode) throws KettleXMLException {
        return this.delegate.loadXML(stepnode);
    }

    public boolean readRep(Repository rep, ObjectId id_step) throws KettleException {
        return this.delegate.readRep(rep, id_step);
    }

    public String getFriendlyName() {
        return this.delegate.getMappingName() + "," + this.delegate.getTableName();
    }

    public Object decodeKeyValue(byte[] rawval) throws KettleException {
        return HBaseValueMeta.decodeKeyValue(rawval, this.delegate, this.hBaseBytesUtilShim);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

