/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.hadoop.shim.ShimConfigsLoader;
import org.pentaho.hadoop.shim.api.internal.Configuration;
import org.pentaho.hadoop.shim.api.internal.fs.Path;
import org.pentaho.hadoop.shim.api.internal.mapred.RunningJob;
import org.pentaho.hadoop.shim.common.ConfigurationProxy;
import org.pentaho.hadoop.shim.common.RunningJobProxyV2;
import org.pentaho.hadoop.shim.common.ShimUtils;
import org.pentaho.hadoop.shim.common.YarnQueueAclsException;
import org.pentaho.hadoop.shim.common.YarnQueueAclsVerifier;

public class ConfigurationProxyV2
implements Configuration {
    protected Job job = Job.getInstance();

    public ConfigurationProxyV2() throws IOException {
        this.addConfigsForJobConf();
    }

    public ConfigurationProxyV2(String namedCluster) throws IOException {
        this.addConfigsForJobConf(namedCluster);
    }

    @VisibleForTesting
    void addConfigsForJobConf() {
        this.job.getConfiguration().addResource("hdfs-site.xml");
        this.job.getConfiguration().addResource("core-site.xml");
        this.job.getConfiguration().addResource("mapred-site.xml");
        this.job.getConfiguration().addResource("yarn-site.xml");
        this.job.getConfiguration().addResource("hbase-site.xml");
        this.job.getConfiguration().addResource("hive-site.xml");
    }

    @VisibleForTesting
    void addConfigsForJobConf(String additionalPath) {
        ShimConfigsLoader.addConfigsAsResources(additionalPath, arg_0 -> ((org.apache.hadoop.conf.Configuration)this.getJob().getConfiguration()).addResource(arg_0), ShimConfigsLoader.ClusterConfigNames.CORE_SITE, ShimConfigsLoader.ClusterConfigNames.MAPRED_SITE, ShimConfigsLoader.ClusterConfigNames.HDFS_SITE, ShimConfigsLoader.ClusterConfigNames.YARN_SITE, ShimConfigsLoader.ClusterConfigNames.HBASE_SITE, ShimConfigsLoader.ClusterConfigNames.HIVE_SITE);
    }

    public JobConf getJobConf() {
        return (JobConf)this.job.getConfiguration();
    }

    public Job getJob() {
        return this.job;
    }

    @Override
    public void setJobName(String jobName) {
        this.getJob().setJobName(jobName);
    }

    @Override
    public void set(String name, String value) {
        this.getJobConf().set(name, value);
    }

    @Override
    public String get(String name) {
        return this.getJobConf().get(name);
    }

    @Override
    public String get(String name, String defaultValue) {
        return this.getJobConf().get(name, defaultValue);
    }

    @Override
    public void setMapOutputKeyClass(Class<?> c) {
        this.getJob().setMapOutputKeyClass(c);
    }

    @Override
    public void setMapOutputValueClass(Class<?> c) {
        this.getJob().setMapOutputValueClass(c);
    }

    @Override
    public void setMapperClass(Class<?> c) {
        if (org.apache.hadoop.mapred.Mapper.class.isAssignableFrom(c)) {
            this.setUseOldMapApi();
            this.getJobConf().setMapperClass(c);
        } else if (Mapper.class.isAssignableFrom(c)) {
            this.getJob().setMapperClass(c);
        }
    }

    private void setUseOldMapApi() {
        this.set("mapred.mapper.new-api", "false");
    }

    @Override
    public void setCombinerClass(Class<?> c) {
        if (org.apache.hadoop.mapred.Reducer.class.isAssignableFrom(c)) {
            this.setUseOldRedApi();
            this.getJobConf().setCombinerClass(c);
        } else if (Reducer.class.isAssignableFrom(c)) {
            this.getJob().setCombinerClass(c);
        }
    }

    private void setUseOldRedApi() {
        this.set("mapred.reducer.new-api", "false");
    }

    @Override
    public void setReducerClass(Class<?> c) {
        if (org.apache.hadoop.mapred.Reducer.class.isAssignableFrom(c)) {
            this.setUseOldRedApi();
            this.getJobConf().setReducerClass(c);
        } else if (Reducer.class.isAssignableFrom(c)) {
            this.getJob().setReducerClass(c);
        }
    }

    @Override
    public void setOutputKeyClass(Class<?> c) {
        this.getJob().setOutputKeyClass(c);
    }

    @Override
    public void setOutputValueClass(Class<?> c) {
        this.getJob().setOutputValueClass(c);
    }

    @Override
    public void setMapRunnerClass(String className) {
        this.getJobConf().set("mapred.map.runner.class", className);
    }

    @Override
    public void setInputFormat(Class<?> inputFormat) {
        if (org.apache.hadoop.mapred.InputFormat.class.isAssignableFrom(inputFormat)) {
            this.setUseOldMapApi();
            this.getJobConf().setInputFormat(inputFormat);
        } else if (InputFormat.class.isAssignableFrom(inputFormat)) {
            this.getJob().setInputFormatClass(inputFormat);
        }
    }

    @Override
    public void setOutputFormat(Class<?> outputFormat) {
        if (org.apache.hadoop.mapred.OutputFormat.class.isAssignableFrom(outputFormat)) {
            this.setUseOldRedApi();
            if (this.getJobConf().getNumReduceTasks() == 0 || this.get("mapred.partitioner.class") != null) {
                this.setUseOldMapApi();
            }
            this.getJobConf().setOutputFormat(outputFormat);
        } else if (OutputFormat.class.isAssignableFrom(outputFormat)) {
            this.getJob().setOutputFormatClass(outputFormat);
        }
    }

    @Override
    public void setInputPaths(Path ... paths) {
        if (paths == null) {
            return;
        }
        org.apache.hadoop.fs.Path[] actualPaths = new org.apache.hadoop.fs.Path[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            actualPaths[i] = ShimUtils.asPath(paths[i]);
        }
        try {
            FileInputFormat.setInputPaths((Job)this.getJob(), (org.apache.hadoop.fs.Path[])actualPaths);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setOutputPath(Path path) {
        FileOutputFormat.setOutputPath((Job)this.getJob(), (org.apache.hadoop.fs.Path)ShimUtils.asPath(path));
    }

    @Override
    public void setJarByClass(Class<?> c) {
        this.getJob().setJarByClass(c);
    }

    @Override
    public void setJar(String url) {
        this.getJob().setJar(url);
    }

    @Override
    public void setNumMapTasks(int n) {
        this.getJobConf().setNumMapTasks(n);
    }

    @Override
    public void setNumReduceTasks(int n) {
        this.getJob().setNumReduceTasks(n);
    }

    @Override
    public void setStrings(String name, String ... values) {
        this.getJobConf().setStrings(name, values);
    }

    @Override
    public String getDefaultFileSystemURL() {
        return this.get("fs.default.name", "");
    }

    @Override
    public <T> T getAsDelegateConf(Class<T> delegate) {
        if (delegate.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (delegate.isAssignableFrom(JobConf.class)) {
            return (T)this.getJobConf();
        }
        return null;
    }

    @Override
    public RunningJob submit() throws IOException, ClassNotFoundException, InterruptedException {
        if (YarnQueueAclsVerifier.verify(this.createClusterDescription(this.getJob().getConfiguration()).getQueueAclsForCurrentUser())) {
            this.getJob().submit();
            return new RunningJobProxyV2(this.getJob());
        }
        throw new YarnQueueAclsException(BaseMessages.getString(ConfigurationProxy.class, (String)"ConfigurationProxy.UserHasNoPermissions", (String[])new String[]{UserGroupInformation.getCurrentUser().getUserName()}));
    }

    Cluster createClusterDescription(org.apache.hadoop.conf.Configuration configuration) throws IOException {
        return new Cluster(configuration);
    }
}

