/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.SnappyCodec;
import org.pentaho.hadoop.shim.ShimVersion;
import org.pentaho.hadoop.shim.spi.SnappyShim;

public abstract class CommonSnappyShim
implements SnappyShim {
    public static final String IO_COMPRESSION_CODEC_SNAPPY_BUFFERSIZE_KEY = "io.compression.codec.snappy.buffersize";
    public static final int IO_COMPRESSION_CODEC_SNAPPY_BUFFERSIZE_DEFAULT = 262144;

    @Override
    public ShimVersion getVersion() {
        return new ShimVersion(1, 0);
    }

    @Override
    public InputStream getSnappyInputStream(InputStream in) throws Exception {
        return this.getSnappyInputStream(262144, in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getSnappyInputStream(int bufferSize, InputStream in) throws Exception {
        if (!this.isHadoopSnappyAvailable()) {
            throw new Exception("Hadoop-snappy does not seem to be available");
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            SnappyCodec c = new SnappyCodec();
            Configuration newConf = new Configuration();
            newConf.set(IO_COMPRESSION_CODEC_SNAPPY_BUFFERSIZE_KEY, "" + bufferSize);
            c.setConf(newConf);
            CompressionInputStream compressionInputStream = c.createInputStream(in);
            return compressionInputStream;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    @Override
    public OutputStream getSnappyOutputStream(OutputStream out) throws Exception {
        return this.getSnappyOutputStream(262144, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getSnappyOutputStream(int bufferSize, OutputStream out) throws Exception {
        if (!this.isHadoopSnappyAvailable()) {
            throw new Exception("Hadoop-snappy does not seem to be available");
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            SnappyCodec c = new SnappyCodec();
            Configuration newConf = new Configuration();
            newConf.set(IO_COMPRESSION_CODEC_SNAPPY_BUFFERSIZE_KEY, "" + bufferSize);
            c.setConf(newConf);
            CompressionOutputStream compressionOutputStream = c.createOutputStream(out);
            return compressionOutputStream;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }
}

