/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common;

import java.io.IOException;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.pentaho.hadoop.shim.api.internal.mapred.RunningJob;
import org.pentaho.hadoop.shim.api.internal.mapred.TaskCompletionEvent;
import org.pentaho.hadoop.shim.common.mapred.TaskCompletionEventProxy;

public class RunningJobProxyV2
implements RunningJob {
    private Job delegateJob;

    public RunningJobProxyV2(Job job) {
        this.delegateJob = job;
    }

    @Override
    public boolean isComplete() throws IOException {
        return this.delegateJob.isComplete();
    }

    @Override
    public void killJob() throws IOException {
        this.delegateJob.killJob();
    }

    @Override
    public boolean isSuccessful() throws IOException {
        return this.delegateJob.isSuccessful();
    }

    @Override
    public TaskCompletionEvent[] getTaskCompletionEvents(int startIndex) throws IOException {
        org.apache.hadoop.mapred.TaskCompletionEvent[] events = this.delegateJob.getTaskCompletionEvents(startIndex);
        TaskCompletionEvent[] wrapped = new TaskCompletionEvent[events.length];
        for (int i = 0; i < wrapped.length; ++i) {
            wrapped[i] = new TaskCompletionEventProxy(events[i]);
        }
        return wrapped;
    }

    @Override
    public String[] getTaskDiagnostics(Object taskAttemptId) throws IOException {
        org.apache.hadoop.mapred.TaskAttemptID id = (org.apache.hadoop.mapred.TaskAttemptID)taskAttemptId;
        try {
            return this.delegateJob.getTaskDiagnostics((TaskAttemptID)id);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public float setupProgress() throws IOException {
        return this.delegateJob.setupProgress();
    }

    @Override
    public float mapProgress() throws IOException {
        return this.delegateJob.mapProgress();
    }

    @Override
    public float reduceProgress() throws IOException {
        return this.delegateJob.reduceProgress();
    }
}

