/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.parquet.delegate;

import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.format.IPentahoParquetInputFormat;
import org.pentaho.hadoop.shim.api.format.IPentahoParquetOutputFormat;
import org.pentaho.hadoop.shim.common.format.parquet.delegate.apache.PentahoApacheInputFormat;
import org.pentaho.hadoop.shim.common.format.parquet.delegate.apache.PentahoApacheOutputFormat;
import org.pentaho.hadoop.shim.common.format.parquet.delegate.twitter.PentahoTwitterInputFormat;
import org.pentaho.hadoop.shim.common.format.parquet.delegate.twitter.PentahoTwitterOutputFormat;

public class DelegateFormatFactory {
    private DelegateFormatFactory() {
    }

    public static IPentahoParquetInputFormat getInputFormatInstance(NamedCluster namedCluster) {
        if (DelegateFormatFactory.shimUsesTwitterLibs(namedCluster)) {
            return new PentahoTwitterInputFormat(namedCluster);
        }
        return new PentahoApacheInputFormat(namedCluster);
    }

    public static IPentahoParquetOutputFormat getOutputFormatInstance(NamedCluster namedCluster) {
        if (DelegateFormatFactory.shimUsesTwitterLibs(namedCluster)) {
            return new PentahoTwitterOutputFormat();
        }
        return new PentahoApacheOutputFormat(namedCluster);
    }

    private static boolean shimUsesTwitterLibs(NamedCluster namedCluster) {
        String shimIdentifier = namedCluster == null ? "" : namedCluster.getShimIdentifier();
        return shimIdentifier.startsWith("cdh") && !shimIdentifier.startsWith("cdh6") || shimIdentifier.startsWith("mapr") && !shimIdentifier.equals("mapr60");
    }
}

