/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.s3a.vfs;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileNameParser;
import org.apache.commons.vfs2.provider.FileNameParser;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponentContext;
import org.pentaho.s3a.vfs.S3AFileName;

public class S3AFileNameParser
extends AbstractFileNameParser {
    private static final S3AFileNameParser INSTANCE = new S3AFileNameParser();

    private S3AFileNameParser() {
    }

    public static FileNameParser getInstance() {
        return INSTANCE;
    }

    public FileName parseUri(VfsComponentContext context, FileName base, String uri) throws FileSystemException {
        StringBuilder name = new StringBuilder();
        String scheme = UriParser.extractScheme((String)uri, (StringBuilder)name);
        UriParser.canonicalizePath((StringBuilder)name, (int)0, (int)name.length(), (FileNameParser)this);
        UriParser.fixSeparators((StringBuilder)name);
        FileType fileType = UriParser.normalisePath((StringBuilder)name);
        String bucketName = UriParser.extractFirstElement((StringBuilder)name);
        return new S3AFileName(scheme, bucketName, name.toString(), fileType);
    }
}

