/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPProgressMonitor;
import com.enterprisedt.net.ftp.FTPProgressMonitorEx;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileTransferInputStream;
import com.enterprisedt.net.ftp.TransferDirection;
import com.enterprisedt.util.debug.Logger;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class FTPInputStream
extends FileTransferInputStream {
    private static Logger log = Logger.getLogger("FTPInputStream");
    private static final byte[] LINE_SEPARATOR = System.getProperty("line.separator").getBytes();
    private long monitorInterval;
    private FTPClient client;
    private BufferedInputStream in;
    private long size = 0L;
    private boolean isASCII = false;
    private byte[] buffer;
    private int bufpos = 0;
    private int buflen = 0;
    private byte[] chunk;
    private byte[] prevBuf = new byte[FTPClient.FTP_LINE_SEPARATOR.length];
    private int matchpos = 0;
    private ByteArrayOutputStream out;
    private long monitorCount = 0L;
    private FTPProgressMonitor monitor;
    private FTPProgressMonitorEx monitorEx;
    private boolean started = false;

    public FTPInputStream(FTPClient client, String remoteFile) throws IOException, FTPException {
        this.client = client;
        this.remoteFile = remoteFile;
        try {
            client.initGet(remoteFile);
            this.in = new BufferedInputStream(new DataInputStream(client.getInputStream()));
        }
        catch (IOException ex) {
            client.validateTransferOnError(ex);
            throw ex;
        }
        this.monitorInterval = client.getMonitorInterval();
        this.monitor = client.getProgressMonitor();
        this.chunk = new byte[client.getTransferBufferSize()];
        this.out = new ByteArrayOutputStream(client.getTransferBufferSize());
        this.isASCII = client.getType().equals(FTPTransferType.ASCII);
    }

    public void setMonitor(FTPProgressMonitorEx monitor, long monitorInterval) {
        this.monitor = monitor;
        this.monitorEx = monitor;
        this.monitorInterval = monitorInterval;
    }

    public int read() throws IOException {
        if (!this.started) {
            this.start();
        }
        if (this.buffer == null) {
            return -1;
        }
        if (this.bufpos == this.buflen) {
            this.buffer = this.refreshBuffer();
            if (this.buffer == null) {
                return -1;
            }
        }
        return 0xFF & this.buffer[this.bufpos++];
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.started) {
            this.start();
        }
        if (this.buffer == null || len == 0) {
            return -1;
        }
        if (this.bufpos == this.buflen) {
            this.buffer = this.refreshBuffer();
            if (this.buffer == null) {
                return -1;
            }
        }
        int available = 0;
        int remaining = len;
        while ((available = this.buflen - this.bufpos) < remaining) {
            System.arraycopy(this.buffer, this.bufpos, b, off, available);
            remaining -= available;
            off += available;
            this.buffer = this.refreshBuffer();
            if (this.buffer != null) continue;
            return len - remaining;
        }
        System.arraycopy(this.buffer, this.bufpos, b, off, remaining);
        this.bufpos += remaining;
        return len;
    }

    private void start() throws IOException {
        if (this.monitorEx != null) {
            this.monitorEx.transferStarted(TransferDirection.DOWNLOAD, this.remoteFile);
        }
        this.buffer = this.refreshBuffer();
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] refreshBuffer() throws IOException {
        this.bufpos = 0;
        if (this.client.isTransferCancelled()) {
            return null;
        }
        int count = this.client.readChunk(this.in, this.chunk, this.chunk.length);
        if (count < 0) {
            if (this.isASCII && this.matchpos > 0) {
                this.size += (long)this.matchpos;
                this.buflen = this.matchpos;
                this.monitorCount += (long)this.matchpos;
                byte[] tmp = new byte[this.matchpos];
                System.arraycopy(tmp, 0, this.prevBuf, 0, this.matchpos);
                this.matchpos = 0;
                return tmp;
            }
            return null;
        }
        try {
            if (!this.isASCII) {
                this.size += (long)count;
                this.monitorCount += (long)count;
                this.buflen = count;
                byte[] tmp = this.chunk;
                return tmp;
            }
            this.out.reset();
            for (int i = 0; i < count; ++i) {
                if (this.chunk[i] == FTPClient.FTP_LINE_SEPARATOR[this.matchpos]) {
                    this.prevBuf[this.matchpos] = this.chunk[i];
                    ++this.matchpos;
                    if (this.matchpos != FTPClient.FTP_LINE_SEPARATOR.length) continue;
                    this.out.write(LINE_SEPARATOR);
                    this.size += (long)LINE_SEPARATOR.length;
                    this.monitorCount += (long)LINE_SEPARATOR.length;
                    this.matchpos = 0;
                    continue;
                }
                if (this.matchpos > 0) {
                    this.out.write(this.prevBuf, 0, this.matchpos);
                    this.size += (long)this.matchpos;
                    this.monitorCount += (long)this.matchpos;
                }
                this.out.write(this.chunk[i]);
                ++this.size;
                ++this.monitorCount;
                this.matchpos = 0;
            }
            byte[] result = this.out.toByteArray();
            this.buflen = result.length;
            byte[] byArray = result;
            return byArray;
        }
        finally {
            if (this.monitor != null && this.monitorCount > this.monitorInterval) {
                this.monitor.bytesTransferred(this.size);
                this.monitorCount = 0L;
            }
        }
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.client.forceResumeOff();
            this.client.closeDataSocket(this.in);
            if (this.monitor != null) {
                this.monitor.bytesTransferred(this.size);
            }
            log.debug("Transferred " + this.size + " bytes from remote host");
            try {
                this.client.validateTransfer();
            }
            catch (FTPException ex) {
                throw new IOException(ex.getMessage());
            }
            if (this.monitorEx != null) {
                this.monitorEx.transferComplete(TransferDirection.DOWNLOAD, this.remoteFile);
            }
        }
    }
}

