/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.appsforyourdomain.generic;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.appsforyourdomain.Namespaces;
import com.google.gdata.data.appsforyourdomain.Property;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericEntry
extends BaseEntry<GenericEntry> {
    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        extProfile.declare(GenericEntry.class, Property.getDefaultDescription());
        extProfile.declareAdditionalNamespace(Namespaces.APPS_NAMESPACE);
    }

    public void addProperty(String name, String value) {
        Property prop = new Property();
        prop.setName(name);
        prop.setValue(value);
        this.getRepeatingExtension(Property.class).add(prop);
    }

    public void addProperties(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            this.addProperty(entry.getKey(), entry.getValue());
        }
    }

    public String getProperty(String name) {
        List<Property> properties = this.getRepeatingExtension(Property.class);
        for (Property prop : properties) {
            if (!prop.getName().equals(name)) continue;
            return prop.getValue();
        }
        return null;
    }

    public boolean removeProperty(String name) {
        List<Property> properties = this.getRepeatingExtension(Property.class);
        Property found = null;
        for (Property prop : properties) {
            if (!prop.getName().equals(name)) continue;
            found = prop;
            break;
        }
        if (found != null) {
            this.removeRepeatingExtension(found);
            return true;
        }
        return false;
    }

    public Map<String, String> getAllProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        List<Property> properties = this.getRepeatingExtension(Property.class);
        for (Property prop : properties) {
            map.put(prop.getName(), prop.getValue());
        }
        return map;
    }

    @Override
    public void validate() throws IllegalStateException {
        HashSet<String> names = new HashSet<String>();
        List<Property> properties = this.getRepeatingExtension(Property.class);
        for (Property prop : properties) {
            String name = prop.getName();
            if (name == null) {
                throw new IllegalStateException("Found property with null name");
            }
            if (names.contains(name)) {
                throw new IllegalStateException("Duplicate property: " + name);
            }
            names.add(name);
        }
    }
}

