/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.wireformats.input.media;

import com.google.gdata.data.ParseSource;
import com.google.gdata.data.media.MediaSource;
import com.google.gdata.data.media.MediaStreamSource;
import com.google.gdata.util.common.base.Preconditions;
import com.google.gdata.wireformats.AltFormat;
import com.google.gdata.wireformats.input.AbstractParser;
import com.google.gdata.wireformats.input.InputProperties;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaParser
extends AbstractParser<MediaSource> {
    public MediaParser() {
        super(AltFormat.MEDIA, MediaSource.class);
    }

    @Override
    public <R extends MediaSource> R parse(ParseSource parseSource, InputProperties inProps, Class<R> resultClass) {
        Preconditions.checkArgument(resultClass.isAssignableFrom(MediaSource.class), "Result class must be " + MediaSource.class.getName());
        InputStream inputStream = parseSource.getInputStream();
        Preconditions.checkNotNull(inputStream, "Parse source must be stream-based");
        MediaStreamSource mediaSource = new MediaStreamSource(inputStream, inProps.getContentType().toString());
        return (R)((MediaSource)resultClass.cast(mediaSource));
    }
}

