/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IUserRoleListService;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;

public class SecurityParameterProvider
implements IParameterProvider {
    public static final List SecurityNames = new ArrayList(4);
    public static final List SecurityTypes = new ArrayList(4);
    private static final int PRINCIPAL_NAME = 0;
    private static final int PRINCIPAL_ROLES = 1;
    private static final int PRINCIPAL_AUTHENTICATED = 2;
    private static final int PRINCIPAL_IS_ADMINISTRATOR = 3;
    private static final int SYSTEM_ROLE_NAMES = 4;
    private static final int SYSTEM_USER_NAMES = 5;
    public static final String SCOPE_SECURITY = "security";
    private String listSeparator = ",";
    private IPentahoSession session;

    public SecurityParameterProvider(IPentahoSession session) {
        this.session = session;
    }

    public void setListSeparator(String value) {
        this.listSeparator = value;
    }

    public String getListSeparator() {
        return this.listSeparator;
    }

    public String getStringParameter(String name, String defaultValue) {
        Object obj = this.getParameter(name);
        if (obj != null) {
            if (obj instanceof List) {
                return this.listToString((List)obj);
            }
            if (obj instanceof String[]) {
                return this.arrayToString((String[])obj);
            }
            if (obj instanceof GrantedAuthority[]) {
                return this.arrayToString((GrantedAuthority[])obj);
            }
            return obj.toString();
        }
        return defaultValue;
    }

    public String listToString(List aList) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < aList.size(); ++i) {
            if (aList.get(i) == null) continue;
            Object listObj = aList.get(i);
            if (listObj instanceof GrantedAuthority) {
                sb.append(i > 0 ? this.listSeparator : "").append(((GrantedAuthority)listObj).getAuthority());
                continue;
            }
            sb.append(i > 0 ? this.listSeparator : "").append(listObj.toString());
        }
        return sb.toString();
    }

    public String arrayToString(String[] anArray) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < anArray.length; ++i) {
            if (anArray[i] == null) continue;
            sb.append(i > 0 ? this.listSeparator : "").append(anArray[i]);
        }
        return sb.toString();
    }

    public String arrayToString(GrantedAuthority[] anArray) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < anArray.length; ++i) {
            if (anArray[i] == null) continue;
            sb.append(i > 0 ? this.listSeparator : "").append(anArray[i].getAuthority());
        }
        return sb.toString();
    }

    public long getLongParameter(String name, long defaultValue) {
        return defaultValue;
    }

    public Date getDateParameter(String name, Date defaultValue) {
        return defaultValue;
    }

    public BigDecimal getDecimalParameter(String name, BigDecimal defaultValue) {
        return defaultValue;
    }

    public Object[] getArrayParameter(String name, Object[] defaultValue) {
        return defaultValue;
    }

    public String[] getStringArrayParameter(String name, String[] defaultValue) {
        return defaultValue;
    }

    public Iterator getParameterNames() {
        return SecurityNames.iterator();
    }

    public String getParameterType(String name) {
        int idx = SecurityNames.indexOf(name);
        if (idx >= 0) {
            return (String)SecurityTypes.get(idx);
        }
        return null;
    }

    public Object getParameter(String name) {
        if (name.startsWith("principal")) {
            if (name.equals(SecurityNames.get(0))) {
                return this.getPrincipalName();
            }
            if (name.equals(SecurityNames.get(1))) {
                return this.getPrincipalRoles();
            }
            if (name.equals(SecurityNames.get(2))) {
                return this.getPrincipalAuthenticated();
            }
            if (name.equals(SecurityNames.get(3))) {
                return this.getPrincipalIsAdministrator();
            }
        } else {
            if (name.equals(SecurityNames.get(4))) {
                return this.getSystemRoleNames();
            }
            if (name.equals(SecurityNames.get(5))) {
                return this.getSystemUserNames();
            }
        }
        return null;
    }

    private Authentication getAuthentication() {
        return SecurityHelper.getInstance().getAuthentication();
    }

    protected String getPrincipalName() {
        Authentication auth = this.getAuthentication();
        if (auth != null) {
            return auth.getName();
        }
        return null;
    }

    protected String getPrincipalAuthenticated() {
        Authentication auth = this.getAuthentication();
        if (auth != null) {
            return auth.isAuthenticated() ? "true" : "false";
        }
        return "false";
    }

    protected String getPrincipalIsAdministrator() {
        return SecurityHelper.getInstance().isPentahoAdministrator(this.session) ? "true" : "false";
    }

    protected Object getPrincipalRoles() {
        Authentication auth = this.getAuthentication();
        if (auth != null) {
            GrantedAuthority[] auths = auth.getAuthorities();
            if (auths != null) {
                ArrayList<String> rtn = new ArrayList<String>(auths.length);
                for (GrantedAuthority element : auths) {
                    rtn.add(element.getAuthority());
                }
                return rtn;
            }
            return new ArrayList();
        }
        return null;
    }

    protected Object getSystemRoleNames() {
        IUserRoleListService service = PentahoSystem.get(IUserRoleListService.class);
        if (service != null) {
            return service.getAllRoles();
        }
        return null;
    }

    protected Object getSystemUserNames() {
        IUserRoleListService service = PentahoSystem.get(IUserRoleListService.class);
        if (service != null) {
            return service.getAllUsers();
        }
        return null;
    }

    public boolean hasParameter(String name) {
        return this.getParameter(name) != null;
    }

    static {
        SecurityNames.add("principalName");
        SecurityNames.add("principalRoles");
        SecurityNames.add("principalAuthenticated");
        SecurityNames.add("principalAdministrator");
        SecurityNames.add("systemRoleNames");
        SecurityNames.add("systemUserNames");
        SecurityTypes.add("string");
        SecurityTypes.add("string-list");
        SecurityTypes.add("string");
        SecurityTypes.add("string");
        SecurityTypes.add("string-list");
        SecurityTypes.add("string-list");
    }
}

