/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.engine.ActionSequenceException;
import org.pentaho.platform.api.engine.IMessageFormatter;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.api.util.IVersionHelper;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.PentahoMessenger;
import org.pentaho.platform.engine.services.actionsequence.ActionSequenceResource;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.engine.services.runtime.ParameterManager;
import org.pentaho.platform.util.messages.LocaleHelper;

public class MessageFormatter
implements IMessageFormatter {
    public static final String HTML_MIME_TYPE = "text/html";
    public static final String TEXT_MIME_TYPE = "text/plain";
    public static final int MAX_RESULT_THRESHOLD = 100;
    DateFormat dateFormat = LocaleHelper.getFullDateFormat(true, true);

    public void formatErrorMessage(String mimeType, String title, String message, StringBuffer messageBuffer) {
        ArrayList<String> messages = new ArrayList<String>(1);
        messages.add(message);
        this.formatErrorMessage(mimeType, title, messages, messageBuffer);
    }

    public String getFirstError(List messages) {
        String errorStart = PentahoMessenger.getUserString("ERROR");
        if (messages != null && errorStart != null) {
            int pos = errorStart.indexOf(123);
            if (pos != -1) {
                errorStart = errorStart.substring(0, pos);
            }
            for (String message : messages) {
                if (message == null || message == null || message.indexOf(errorStart) != 0) continue;
                message = StringEscapeUtils.escapeHtml((String)message);
                return message;
            }
        }
        return null;
    }

    public void formatErrorMessage(String mimeType, String title, List messages, StringBuffer messageBuffer) {
        if (HTML_MIME_TYPE.equals(mimeType)) {
            String firstMessage;
            messageBuffer.append("<html><head><title>").append(Messages.getInstance().getString("MessageFormatter.ERROR_PAGE_TITLE")).append("</title><link rel=\"stylesheet\" type=\"text/css\" href=\"/pentaho-style/active/default.css\"></head>").append("<body dir=\"").append(LocaleHelper.getTextDirection()).append("\"><table cellspacing=\"10\"><tr><td class=\"portlet-section\" colspan=\"3\">").append(title).append("<hr size=\"1\"/></td></tr><tr><td class=\"portlet-font\" valign=\"top\">");
            Iterator messageIterator = messages.iterator();
            String errorStart = PentahoMessenger.getUserString("ERROR");
            int pos = errorStart.indexOf(123);
            if (pos != -1) {
                errorStart = errorStart.substring(0, pos);
            }
            if ((firstMessage = this.getFirstError(messages)) != null) {
                messageBuffer.append("<span style=\"color:red\">").append(firstMessage).append("</span><p/>");
            }
            messageIterator = messages.iterator();
            while (messageIterator.hasNext()) {
                messageBuffer.append(StringEscapeUtils.escapeHtml((String)((String)messageIterator.next()))).append("<br/>");
            }
            messageBuffer.append("</td></tr></table><p>");
            if (PentahoSystem.getObjectFactory().objectDefined(IVersionHelper.class.getSimpleName())) {
                IVersionHelper versionHelper = PentahoSystem.get(IVersionHelper.class, null);
                messageBuffer.append("&nbsp;&nbsp;" + Messages.getInstance().getString("MessageFormatter.USER_SERVER_VERSION", versionHelper.getVersionInformation(PentahoSystem.class)));
            }
            messageBuffer.append("</body></html>");
        }
    }

    public void formatFailureMessage(String mimeType, IRuntimeContext context, StringBuffer messageBuffer, List defaultMessages) {
        if (context == null && defaultMessages == null) {
            this.formatErrorMessage(mimeType, Messages.getInstance().getString("MessageFormatter.ERROR_0001_REQUEST_FAILED"), Messages.getInstance().getString("MessageFormatter.ERROR_0002_COULD_NOT_PROCESS"), messageBuffer);
        } else if (context == null) {
            this.formatErrorMessage(mimeType, "Failed", defaultMessages, messageBuffer);
        } else {
            ActionSequenceException theFailureException = null;
            List theMessages = context.getMessages();
            for (Object msg : theMessages) {
                if (!(msg instanceof ActionSequenceException)) continue;
                theFailureException = (ActionSequenceException)msg;
                break;
            }
            if (theFailureException != null) {
                this.formatExceptionMessage(mimeType, theFailureException, messageBuffer);
            } else {
                this.formatErrorMessage(mimeType, "Failed", theMessages, messageBuffer);
            }
        }
    }

    public void formatExceptionMessage(String mimeType, ActionSequenceException exception, StringBuffer messageBuffer) {
        if (HTML_MIME_TYPE.equals(mimeType)) {
            String templateFile = null;
            String templatePath = "system/ui/templates/viewActionErrorTemplate.html";
            try {
                byte[] bytes = IOUtils.toByteArray((InputStream)ActionSequenceResource.getInputStream(templatePath, LocaleHelper.getLocale()));
                templateFile = new String(bytes, LocaleHelper.getSystemEncoding());
            }
            catch (IOException e) {
                messageBuffer.append(Messages.getInstance().getErrorString("MessageFormatter.RESPONSE_ERROR_HEADING", templatePath));
                e.printStackTrace();
            }
            templateFile = StringUtils.replace((String)templateFile, (String)"%ERROR_HEADING%", (String)Messages.getInstance().getString("MessageFormatter.RESPONSE_ERROR_HEADING"));
            templateFile = StringUtils.replace((String)templateFile, (String)"%EXCEPTION_MSG%", (String)StringEscapeUtils.escapeHtml((String)(exception.getMessage() == null ? "" : exception.getMessage())));
            templateFile = StringUtils.replace((String)templateFile, (String)"%EXCEPTION_MSG_LABEL%", (String)Messages.getInstance().getString("MessageFormatter.RESPONSE_EXCEPTION_MSG_LABEL"));
            templateFile = StringUtils.replace((String)templateFile, (String)"%EXCEPTION_TIME%", (String)StringEscapeUtils.escapeHtml((String)this.dateFormat.format(exception.getDate())));
            templateFile = StringUtils.replace((String)templateFile, (String)"%EXCEPTION_TIME_LABEL%", (String)Messages.getInstance().getString("MessageFormatter.RESPONSE_EXCEPTION_TIME_LABEL"));
            templateFile = StringUtils.replace((String)templateFile, (String)"%EXCEPTION_TYPE%", (String)StringEscapeUtils.escapeHtml((String)exception.getClass().getSimpleName()));
            templateFile = StringUtils.replace((String)templateFile, (String)"%EXCEPTION_TYPE_LABEL%", (String)Messages.getInstance().getString("MessageFormatter.RESPONSE_EXCEPTION_TYPE_LABEL"));
            templateFile = StringUtils.replace((String)templateFile, (String)"%SESSION_ID%", (String)StringEscapeUtils.escapeHtml((String)(exception.getSessionId() == null ? "" : exception.getSessionId())));
            templateFile = StringUtils.replace((String)templateFile, (String)"%SESSION_ID_LABEL%", (String)Messages.getInstance().getString("MessageFormatter.RESPONSE_EXCEPTION_SESSION_ID_LABEL"));
            templateFile = StringUtils.replace((String)templateFile, (String)"%INSTANCE_ID%", (String)StringEscapeUtils.escapeHtml((String)(exception.getInstanceId() == null ? "" : exception.getInstanceId())));
            templateFile = StringUtils.replace((String)templateFile, (String)"%INSTANCE_ID_LABEL%", (String)Messages.getInstance().getString("MessageFormatter.RESPONSE_EXCEPTION_INSTANCE_ID_LABEL"));
            templateFile = StringUtils.replace((String)templateFile, (String)"%ACTION_SEQUENCE%", (String)StringEscapeUtils.escapeHtml((String)(exception.getActionSequenceName() == null ? "" : exception.getActionSequenceName())));
            templateFile = StringUtils.replace((String)templateFile, (String)"%ACTION_SEQUENCE_LABEL%", (String)Messages.getInstance().getString("MessageFormatter.RESPONSE_EXCEPTION_ACTION_SEQUENCE_LABEL"));
            CharArrayWriter charWriter = new CharArrayWriter();
            PrintWriter printWriter = new PrintWriter(charWriter);
            exception.printActionExecutionStack(printWriter);
            templateFile = StringUtils.replace((String)templateFile, (String)"%ACTION_SEQUENCE_EXECUTION_STACK%", (String)StringEscapeUtils.escapeHtml((String)charWriter.toString()));
            templateFile = StringUtils.replace((String)templateFile, (String)"%ACTION_SEQUENCE_EXECUTION_STACK_LABEL%", (String)Messages.getInstance().getString("MessageFormatter.RESPONSE_EXCEPTION_ACTION_SEQUENCE_EXECUTION_STACK_LABEL"));
            templateFile = StringUtils.replace((String)templateFile, (String)"%ACTION_CLASS%", (String)StringEscapeUtils.escapeHtml((String)(exception.getActionClass() == null ? "" : exception.getActionClass())));
            templateFile = StringUtils.replace((String)templateFile, (String)"%ACTION_CLASS_LABEL%", (String)Messages.getInstance().getString("MessageFormatter.RESPONSE_EXCEPTION_ACTION_CLASS_LABEL"));
            templateFile = StringUtils.replace((String)templateFile, (String)"%ACTION_DESC%", (String)StringEscapeUtils.escapeHtml((String)(exception.getStepDescription() == null ? "" : exception.getStepDescription())));
            templateFile = StringUtils.replace((String)templateFile, (String)"%ACTION_DESC_LABEL%", (String)Messages.getInstance().getString("MessageFormatter.RESPONSE_EXCEPTION_ACTION_DESC_LABEL"));
            templateFile = StringUtils.replace((String)templateFile, (String)"%STEP_NUM%", (String)StringEscapeUtils.escapeHtml((String)(exception.getStepNumber() == null ? Messages.getInstance().getString("MessageFormatter.EXCEPTION_FIELD_NOT_APPLICABLE") : exception.getStepNumber().toString())));
            templateFile = StringUtils.replace((String)templateFile, (String)"%STEP_NUM_LABEL%", (String)Messages.getInstance().getString("MessageFormatter.RESPONSE_EXCEPTION_STEP_NUM_LABEL"));
            templateFile = StringUtils.replace((String)templateFile, (String)"%LOOP_INDEX%", (String)StringEscapeUtils.escapeHtml((String)(exception.getLoopIndex() == null ? Messages.getInstance().getString("MessageFormatter.EXCEPTION_FIELD_NOT_APPLICABLE") : exception.getLoopIndex().toString())));
            templateFile = StringUtils.replace((String)templateFile, (String)"%LOOP_INDEX_LABEL%", (String)Messages.getInstance().getString("MessageFormatter.RESPONSE_EXCEPTION_LOOP_INDEX_LABEL"));
            charWriter = new CharArrayWriter();
            printWriter = new PrintWriter(charWriter);
            exception.printStackTrace(printWriter);
            templateFile = StringUtils.replace((String)templateFile, (String)"%STACK_TRACE%", (String)StringEscapeUtils.escapeHtml((String)charWriter.toString()));
            templateFile = StringUtils.replace((String)templateFile, (String)"%STACK_TRACE_LABEL%", (String)Messages.getInstance().getString("MessageFormatter.RESPONSE_EXCEPTION_STACK_TRACE_LABEL"));
            Stack<String> causes = new Stack<String>();
            MessageFormatter.buildCauses(causes, (Throwable)exception);
            charWriter = new CharArrayWriter();
            printWriter = new PrintWriter(charWriter);
            while (!causes.empty()) {
                printWriter.println(causes.pop());
            }
            templateFile = StringUtils.replace((String)templateFile, (String)"%EXCEPTION_MESSAGES%", (String)StringEscapeUtils.escapeHtml((String)charWriter.toString()));
            templateFile = StringUtils.replace((String)templateFile, (String)"%EXCEPTION_MESSAGES_LABEL%", (String)Messages.getInstance().getString("MessageFormatter.RESPONSE_EXCEPTION_MESSAGES_LABEL"));
            if (PentahoSystem.getObjectFactory().objectDefined(IVersionHelper.class.getSimpleName())) {
                IVersionHelper versionHelper = PentahoSystem.get(IVersionHelper.class);
                templateFile = StringUtils.replace((String)templateFile, (String)"%SERVER_INFO%", (String)Messages.getInstance().getString("MessageFormatter.USER_SERVER_VERSION", versionHelper.getVersionInformation(PentahoSystem.class)));
            }
            messageBuffer.append(templateFile);
        }
    }

    private static void buildCauses(Stack<String> causes, Throwable cause) {
        if (cause != null) {
            causes.push(cause.getClass().getSimpleName() + ": " + (cause.getMessage() != null ? cause.getMessage() : ""));
            MessageFormatter.buildCauses(causes, cause.getCause());
        }
    }

    public void formatFailureMessage(String mimeType, IRuntimeContext context, StringBuffer messageBuffer) {
        this.formatFailureMessage(mimeType, context, messageBuffer, null);
    }

    public void formatResultSetAsHTMLRows(IPentahoResultSet resultSet, StringBuffer messageBuffer) {
        boolean hasColumnHeaders = false;
        boolean hasRowHeaders = false;
        Object[][] columnHeaders = null;
        Object[][] rowHeaders = null;
        if (resultSet.getMetaData() != null) {
            columnHeaders = resultSet.getMetaData().getColumnHeaders();
            rowHeaders = resultSet.getMetaData().getRowHeaders();
            hasColumnHeaders = columnHeaders != null && columnHeaders.length > 0;
            boolean bl = hasRowHeaders = rowHeaders != null && rowHeaders.length > 0;
            if (hasColumnHeaders) {
                for (Object[] element : columnHeaders) {
                    messageBuffer.append("<tr>");
                    if (hasRowHeaders) {
                        for (int indent = 0; indent < rowHeaders[0].length; ++indent) {
                            messageBuffer.append("<th></th>");
                        }
                    }
                    for (int column = 0; column < element.length; ++column) {
                        messageBuffer.append("<th>").append(element[column]).append("</th>");
                    }
                    messageBuffer.append("</tr>");
                }
            }
        }
        Object[] dataRow = resultSet.next();
        for (int currentRow = 0; dataRow != null && currentRow < 100; ++currentRow) {
            messageBuffer.append("<tr>");
            if (hasRowHeaders) {
                for (int rowHeaderCol = rowHeaders[currentRow].length - 1; rowHeaderCol >= 0; --rowHeaderCol) {
                    messageBuffer.append("<th>").append(rowHeaders[currentRow][rowHeaderCol].toString()).append("</th>");
                }
            }
            NumberFormat nf = NumberFormat.getInstance();
            for (Object element : dataRow) {
                if (element != null) {
                    Object value = element;
                    if (value instanceof Number) {
                        Number numVal = (Number)value;
                        value = nf.format(numVal);
                        messageBuffer.append("<td align=\"right\">").append(value.toString()).append("</td>");
                        continue;
                    }
                    messageBuffer.append("<td>").append(value.toString()).append("</td>");
                    continue;
                }
                messageBuffer.append("<td>---</td>");
            }
            messageBuffer.append("</tr>");
            dataRow = resultSet.next();
        }
    }

    public void formatSuccessMessage(String mimeType, IRuntimeContext context, StringBuffer messageBuffer, boolean doMessages) {
        this.formatSuccessMessage(mimeType, context, messageBuffer, doMessages, true);
    }

    public void formatSuccessMessage(String mimeType, IRuntimeContext context, StringBuffer messageBuffer, boolean doMessages, boolean doWrapper) {
        if (context == null) {
            this.formatFailureMessage(mimeType, context, messageBuffer);
        } else if (mimeType.equalsIgnoreCase(HTML_MIME_TYPE)) {
            if (doWrapper) {
                messageBuffer.append("<html><head><title>").append(Messages.getInstance().getString("MessageFormatter.USER_START_ACTION")).append("</title><link rel=\"stylesheet\" type=\"text/css\" href=\"/pentaho-style/active/default.css\"></head>").append("<body dir=\"").append(LocaleHelper.getTextDirection()).append("\"><table cellspacing=\"10\"><tr><td class=\"portlet-section\" colspan=\"3\">").append(Messages.getInstance().getString("MessageFormatter.USER_ACTION_SUCCESSFUL")).append("<hr size=\"1\"/></td></tr><tr><td class=\"portlet-font\" valign=\"top\">");
            }
            Set outputNames = context.getOutputNames();
            for (String outputName : outputNames) {
                Object value = context.getOutputParameter(outputName).getValue();
                if (value == null) {
                    value = "";
                    continue;
                }
                if (value instanceof IPentahoResultSet) {
                    this.formatResultSetAsHTMLRows((IPentahoResultSet)value, messageBuffer);
                    continue;
                }
                ParameterManager.ReturnParameter rpm = (ParameterManager.ReturnParameter)context.getParameterManager().getReturnParameters().get(outputName);
                if (rpm != null && "response".equalsIgnoreCase(rpm.destinationName) && "header".equalsIgnoreCase(rpm.destinationParameter)) continue;
                if (doWrapper) {
                    messageBuffer.append(outputName).append("=");
                }
                messageBuffer.append(value.toString());
                if (!doWrapper) continue;
                messageBuffer.append("<br/>");
            }
            if (doMessages) {
                if (doWrapper) {
                    messageBuffer.append("<p><br size=\"1\">");
                }
                List messages = context.getMessages();
                Iterator messageIterator = messages.iterator();
                while (messageIterator.hasNext()) {
                    messageBuffer.append((String)messageIterator.next());
                    if (!doWrapper) continue;
                    messageBuffer.append("<br/>");
                }
            }
            if (doWrapper) {
                messageBuffer.append("</td></tr></table></body></html>");
            }
        } else if (mimeType.equalsIgnoreCase(TEXT_MIME_TYPE)) {
            messageBuffer.append(Messages.getInstance().getString("MessageFormatter.USER_START_ACTION\n")).append(Messages.getInstance().getString("MessageFormatter.USER_ACTION_SUCCESSFUL\n"));
            Set outputNames = context.getOutputNames();
            for (String outputName : outputNames) {
                Object value = context.getOutputParameter(outputName).getValue();
                if (value == null) {
                    value = "";
                    continue;
                }
                if (value instanceof IPentahoResultSet) {
                    boolean hasRowHeaders;
                    IPentahoResultSet resultSet = (IPentahoResultSet)value;
                    Object[][] columnHeaders = resultSet.getMetaData().getColumnHeaders();
                    Object[][] rowHeaders = resultSet.getMetaData().getRowHeaders();
                    boolean hasColumnHeaders = columnHeaders != null;
                    boolean bl = hasRowHeaders = rowHeaders != null;
                    if (hasColumnHeaders) {
                        for (Object[] element : columnHeaders) {
                            for (int column = 0; column < element.length; ++column) {
                                if (hasRowHeaders) {
                                    for (int indent = 0; indent < rowHeaders[0].length; ++indent) {
                                        messageBuffer.append("\t");
                                    }
                                }
                                messageBuffer.append(element[column]).append("\t");
                            }
                            messageBuffer.append("\n");
                        }
                    }
                    int headerRow = 0;
                    Object[] dataRow = resultSet.next();
                    for (int currentRow = 0; dataRow != null && currentRow < 100; ++currentRow) {
                        if (hasRowHeaders) {
                            for (int rowHeaderCol = 0; rowHeaderCol < rowHeaders[headerRow].length; ++rowHeaderCol) {
                                messageBuffer.append(rowHeaders[headerRow][rowHeaderCol].toString()).append("\t");
                            }
                        }
                        for (Object element : dataRow) {
                            messageBuffer.append(element.toString()).append("\t");
                        }
                        dataRow = resultSet.next();
                    }
                    continue;
                }
                ParameterManager.ReturnParameter rpm = (ParameterManager.ReturnParameter)context.getParameterManager().getReturnParameters().get(outputName);
                if (rpm != null && "response".equalsIgnoreCase(rpm.destinationName) && "header".equalsIgnoreCase(rpm.destinationParameter)) continue;
                messageBuffer.append(outputName).append("=").append(value.toString()).append("\n");
            }
            if (doMessages) {
                List messages = context.getMessages();
                Iterator messageIterator = messages.iterator();
                while (messageIterator.hasNext()) {
                    messageBuffer.append((String)messageIterator.next()).append("\n");
                }
            }
        }
    }
}

