/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.audit;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.data.IDBDatasourceService;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.engine.core.messages.Messages;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.connection.datasource.dbcp.JndiDatasourceService;

public class AuditConnection {
    private DataSource auditDs;
    private boolean initialized;
    private static final Log logger = LogFactory.getLog(AuditConnection.class);
    private boolean useNewDatasourceService = false;
    private static final String auditConfigFile = "audit_sql.xml";
    private static String DRIVER_URL;
    private static String DRIVER_CLASS;
    private static String DRIVER_USERID;
    private static String DRIVER_PASSWORD;
    private static String AUDIT_JNDI;

    public void initialize() {
        if (!this.initialized) {
            try {
                IDBDatasourceService datasourceService = this.getDBDatasourceService();
                this.auditDs = datasourceService.getDataSource(AUDIT_JNDI);
                if (this.auditDs != null) {
                    logger.debug((Object)Messages.getInstance().getString("AUDCONN.DEBUG_LOOKUP_FOUND_CLASS", this.auditDs.getClass().getName()));
                }
            }
            catch (Exception dsException) {
                logger.error((Object)Messages.getInstance().getErrorString("AUDCONN.ERROR_0001_COULD_NOT_GET_DATASOURCE"), (Throwable)dsException);
            }
            if (this.auditDs != null) {
                this.initialized = true;
            } else {
                try {
                    logger.warn((Object)Messages.getInstance().getString("AUDCONN.WARN_FALLING_BACK_TO_DRIVERMGR"));
                    Class.forName(DRIVER_CLASS).newInstance();
                    this.initialized = true;
                }
                catch (IllegalAccessException ex) {
                    logger.error((Object)Messages.getInstance().getErrorString("AUDCONN.ERROR_0002_INSTANCE_DRIVER"), (Throwable)ex);
                }
                catch (ClassNotFoundException cfe) {
                    logger.error((Object)Messages.getInstance().getErrorString("AUDCONN.ERROR_0002_INSTANCE_DRIVER"), (Throwable)cfe);
                }
                catch (InstantiationException ie) {
                    logger.error((Object)Messages.getInstance().getErrorString("AUDCONN.ERROR_0002_INSTANCE_DRIVER"), (Throwable)ie);
                }
            }
        }
    }

    public void setUseNewDatasourceService(boolean useNewService) {
        this.useNewDatasourceService = useNewService;
    }

    private IDBDatasourceService getDBDatasourceService() throws ObjectFactoryException {
        if (!this.useNewDatasourceService) {
            return new JndiDatasourceService();
        }
        IDBDatasourceService datasourceService = (IDBDatasourceService)PentahoSystem.getObjectFactory().get(IDBDatasourceService.class, null);
        return datasourceService;
    }

    public DataSource getAuditDatasource() {
        this.initialize();
        return this.auditDs;
    }

    protected void waitFor(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Connection getConnection() throws SQLException {
        return this.auditDs != null ? this.auditDs.getConnection() : DriverManager.getConnection(DRIVER_URL, DRIVER_USERID, DRIVER_PASSWORD);
    }

    public Connection getAuditConnection() throws SQLException {
        SQLException sqlEx = null;
        int[] sleepTime = new int[]{0, 200, 500, 2000};
        for (int i = 0; i <= 3; ++i) {
            this.waitFor(sleepTime[i]);
            try {
                Connection con = this.getConnection();
                try {
                    con.clearWarnings();
                }
                catch (SQLException ex) {
                    // empty catch block
                }
                return con;
            }
            catch (SQLException ex) {
                sqlEx = ex;
                logger.warn((Object)Messages.getInstance().getErrorString("AuditConnection.WARN_0001_CONNECTION_ATTEMPT_FAILED", "" + sleepTime[i]));
                continue;
            }
        }
        throw new SQLException(Messages.getInstance().getErrorString("AUDSQLENT.ERROR_0001_INVALID_CONNECTION"), sqlEx);
    }

    static {
        String tmp = PentahoSystem.getSystemSetting(auditConfigFile, "auditConnection/driverURL", null);
        DRIVER_URL = tmp != null ? tmp : PentahoSystem.getSystemSetting("auditConnection/driverURL", Messages.getInstance().getString("AUDCONN.CODE_DEFAULT_CONNECT_URL"));
        tmp = PentahoSystem.getSystemSetting(auditConfigFile, "auditConnection/driverCLASS", null);
        DRIVER_CLASS = tmp != null ? tmp : PentahoSystem.getSystemSetting("auditConnection/driverCLASS", Messages.getInstance().getString("AUDCONN.CODE_DEFAULT_CONNECT_DRIVER"));
        tmp = PentahoSystem.getSystemSetting(auditConfigFile, "auditConnection/userid", null);
        DRIVER_USERID = tmp != null ? tmp : PentahoSystem.getSystemSetting("auditConnection/userid", "sa");
        tmp = PentahoSystem.getSystemSetting(auditConfigFile, "auditConnection/password", null);
        DRIVER_PASSWORD = tmp != null ? tmp : PentahoSystem.getSystemSetting("auditConnection/password", "");
        tmp = PentahoSystem.getSystemSetting(auditConfigFile, "auditConnection/JNDI", null);
        AUDIT_JNDI = tmp != null ? tmp : PentahoSystem.getSystemSetting("auditConnection/JNDI", "Hibernate");
    }
}

