/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.xpath;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.AbstractDataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.extensions.datasources.xpath.LegacyXPathTableModel;
import org.pentaho.reporting.engine.classic.extensions.datasources.xpath.XPathTableModel;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class XPathDataFactory
extends AbstractDataFactory {
    private static final Log logger = LogFactory.getLog(XPathDataFactory.class);
    private LinkedHashMap<String, QueryDefinition> queries = new LinkedHashMap();
    private String xqueryDataFile;

    public String getXqueryDataFile() {
        return this.xqueryDataFile;
    }

    public void setXqueryDataFile(String xqueryDataFile) {
        this.xqueryDataFile = xqueryDataFile;
    }

    public void setQuery(String name, String value, boolean legacyQuery) {
        if (value == null) {
            this.queries.remove(name);
        } else {
            this.queries.put(name, new QueryDefinition(value, legacyQuery));
        }
    }

    public QueryDefinition getQuery(String name) {
        return this.queries.get(name);
    }

    public String[] getQueryNames() {
        return this.queries.keySet().toArray(new String[this.queries.size()]);
    }

    public TableModel queryData(String query, DataRow parameters) throws ReportDataFactoryException {
        int queryLimitVal;
        QueryDefinition xpath = this.queries.get(query);
        if (xpath == null) {
            throw new ReportDataFactoryException("No such query");
        }
        Object queryLimit = parameters.get("::org.pentaho.reporting::query-limit");
        if (queryLimit instanceof Number) {
            Number i = (Number)queryLimit;
            queryLimitVal = i.intValue();
        } else {
            queryLimitVal = -1;
        }
        try {
            ResourceManager resourceManager = this.getResourceManager();
            ResourceData resource = this.load();
            if (xpath.isLegacyQuery()) {
                return new LegacyXPathTableModel(resource, resourceManager, xpath.getXpathExpression(), parameters, queryLimitVal);
            }
            return new XPathTableModel(resource, resourceManager, xpath.getXpathExpression(), parameters, queryLimitVal);
        }
        catch (ResourceException re) {
            throw new ReportDataFactoryException("Failed to load XML data", (Throwable)re);
        }
    }

    private ResourceData load() throws ResourceException {
        ResourceKey resourceKey;
        try {
            ResourceKey contextKey = this.getContextKey();
            if (contextKey != null) {
                ResourceManager resourceManager = this.getResourceManager();
                ResourceKey resourceKey2 = resourceManager.deriveKey(contextKey, this.getXqueryDataFile());
                return resourceManager.load(resourceKey2);
            }
        }
        catch (ResourceException re) {
            logger.debug((Object)("Failed to load datasource as derived path: " + (Object)((Object)re)));
        }
        try {
            ResourceManager resourceManager = this.getResourceManager();
            resourceKey = resourceManager.createKey((Object)new URL(this.getXqueryDataFile()));
            return resourceManager.load(resourceKey);
        }
        catch (ResourceException re) {
            logger.debug((Object)("Failed to load datasource as URL: " + (Object)((Object)re)));
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        try {
            ResourceManager resourceManager = this.getResourceManager();
            resourceKey = resourceManager.createKey((Object)new File(this.getXqueryDataFile()));
            return resourceManager.load(resourceKey);
        }
        catch (ResourceException re) {
            logger.debug((Object)("Failed to load datasource as file: " + (Object)((Object)re)));
            throw new ResourceException("Unable to load the resource");
        }
    }

    public XPathDataFactory clone() {
        XPathDataFactory dataFactory = (XPathDataFactory)super.clone();
        dataFactory.queries = (LinkedHashMap)this.queries.clone();
        return dataFactory;
    }

    public XPathDataFactory derive() {
        return this.clone();
    }

    public void close() {
    }

    public boolean isQueryExecutable(String query, DataRow parameters) {
        return this.queries.containsKey(query);
    }

    public static class QueryDefinition
    implements Serializable {
        private boolean legacyQuery;
        private String xpathExpression;

        public QueryDefinition(String xpathExpression, boolean legacyQuery) {
            this.xpathExpression = xpathExpression;
            this.legacyQuery = legacyQuery;
        }

        public boolean isLegacyQuery() {
            return this.legacyQuery;
        }

        public String getXpathExpression() {
            return this.xpathExpression;
        }
    }
}

