/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.xpath;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.table.AbstractTableModel;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.util.TypedTableModel;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XPathTableModel
extends AbstractTableModel {
    private static final Log logger = LogFactory.getLog(XPathTableModel.class);
    private static final Map<String, Class> SUPPORTED_TYPES;
    private ArrayList<Class> columnTypes;
    private TypedTableModel backend;
    private int dataLimit;
    private static final String PROCESSING_INSTRUCTION_PENTAHO_DATASET = "/processing-instruction('pentaho-dataset')";
    private static final String COMMENT_XPATH = "/comment()";
    private static final String RESULT_SET_COMMENT_XPATH = "/result-set/comment()";

    public XPathTableModel(ResourceData xmlResource, ResourceManager resourceManager, String xPathExpression, DataRow parameters, int maxRowsToProcess) throws ReportDataFactoryException {
        try {
            this.columnTypes = new ArrayList();
            XPath xPath = XPathFactory.newInstance().newXPath();
            xPath.setXPathVariableResolver(new InternalXPathVariableResolver(parameters));
            String nodeValue = this.computeColDeclaration(xmlResource, resourceManager, xPath);
            if (nodeValue != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(nodeValue, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String className = stringTokenizer.nextToken();
                    if (SUPPORTED_TYPES.containsKey(className)) {
                        this.columnTypes.add(SUPPORTED_TYPES.get(className));
                        continue;
                    }
                    this.columnTypes.add(String.class);
                }
            }
            this.dataLimit = maxRowsToProcess == -1 ? Integer.MAX_VALUE : Math.min(1, maxRowsToProcess);
            this.backend = new TypedTableModel();
            LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
            NodeList rows = this.evaluateNodeList(xPath, xPathExpression, xmlResource, resourceManager);
            for (int r = 0; r < rows.getLength(); ++r) {
                Node rowValue = rows.item(r);
                short nodeType = rowValue.getNodeType();
                if (nodeType == 1) {
                    if (this.processNode(rowValue, results, this.backend)) continue;
                    return;
                }
                String columnName = rowValue.getNodeValue();
                results.put(columnName, rowValue.toString());
                if (!this.addRow(results, this.backend)) {
                    return;
                }
                results.clear();
            }
        }
        catch (Exception e) {
            throw new ReportDataFactoryException("Failed to query XPath datasource", (Throwable)e);
        }
    }

    private Object convertFromString(int columnPosition, String textContent) throws ReportDataFactoryException {
        if (textContent == null) {
            return null;
        }
        try {
            Class columnClass = columnPosition < this.columnTypes.size() ? this.columnTypes.get(columnPosition) : String.class;
            if (String.class.equals(columnClass)) {
                return textContent;
            }
            if (columnClass == Date.class) {
                return new Date(Long.parseLong(textContent));
            }
            if (columnClass == BigDecimal.class || columnClass == Number.class) {
                return new BigDecimal(textContent);
            }
            if (columnClass == BigInteger.class) {
                return new BigInteger(textContent);
            }
            if (columnClass == Timestamp.class) {
                return new Timestamp(Long.parseLong(textContent));
            }
            if (columnClass == Integer.class) {
                return Integer.valueOf(textContent);
            }
            if (columnClass == Double.class) {
                return Double.valueOf(textContent);
            }
            if (columnClass == Long.class) {
                return Long.valueOf(textContent);
            }
            return textContent;
        }
        catch (Exception e) {
            throw new ReportDataFactoryException("Unable to convert data to the declared type", (Throwable)e);
        }
    }

    private boolean addRow(HashMap<String, String> results, TypedTableModel tableModel) throws ReportDataFactoryException {
        int row = tableModel.getRowCount();
        if (row >= this.dataLimit) {
            return false;
        }
        Set<Map.Entry<String, String>> entries = results.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String colName = entry.getKey();
            int colIdx = tableModel.findColumn(colName);
            if (colIdx == -1) {
                tableModel.addColumn(colName, Object.class);
                int colum = tableModel.getColumnCount() - 1;
                Object value = this.convertFromString(colum, entry.getValue());
                tableModel.setValueAt(value, row, colum);
                continue;
            }
            Object value = this.convertFromString(colIdx, entry.getValue());
            tableModel.setValueAt(value, row, colIdx);
        }
        return true;
    }

    private boolean processNode(Node node, LinkedHashMap<String, String> results, TypedTableModel typedTableModel) throws ReportDataFactoryException {
        int i;
        LinkedHashMap<String, String> innerResults = new LinkedHashMap<String, String>(results);
        boolean isLeaf = true;
        NodeList childList = node.getChildNodes();
        for (i = 0; i < childList.getLength(); ++i) {
            Node nodeIf = childList.item(i);
            short type = nodeIf.getNodeType();
            if (type == 8) continue;
            if (type == 1) {
                NodeList anIf = nodeIf.getChildNodes();
                int size = anIf.getLength();
                if (size == 0) {
                    innerResults.put(nodeIf.getNodeName(), null);
                    continue;
                }
                if (size == 1) {
                    Node subNode = anIf.item(0);
                    if (subNode.getNodeType() == 3 || subNode.getNodeType() == 4) {
                        innerResults.put(nodeIf.getNodeName(), nodeIf.getTextContent());
                        continue;
                    }
                    if (subNode.getNodeType() == 1) {
                        isLeaf = false;
                        continue;
                    }
                    innerResults.put(nodeIf.getNodeName(), nodeIf.getTextContent());
                    continue;
                }
                isLeaf = false;
                continue;
            }
            String content = nodeIf.getTextContent();
            if (StringUtils.isEmpty((String)content, (boolean)true)) continue;
            innerResults.put(nodeIf.getNodeName(), content);
        }
        if (!isLeaf) {
            for (i = 0; i < childList.getLength(); ++i) {
                NodeList childNodes;
                Node deepNode = childList.item(i);
                if (deepNode.getNodeType() != 1 || (childNodes = deepNode.getChildNodes()).getLength() <= 1 && (childNodes.getLength() != 1 || childNodes.item(0).getNodeType() != 1) || this.processNode(deepNode, innerResults, typedTableModel)) continue;
                return false;
            }
            return true;
        }
        return this.addRow(innerResults, typedTableModel);
    }

    private String computeColDeclaration(ResourceData xmlResource, ResourceManager resourceManager, XPath xPath) throws XPathExpressionException, ResourceLoadingException, IOException {
        String text;
        String text2;
        String text3;
        Node pi = this.evaluateNode(xPath, PROCESSING_INSTRUCTION_PENTAHO_DATASET, xmlResource, resourceManager);
        if (pi != null && (text3 = pi.getNodeValue()).length() > 0) {
            return text3;
        }
        Node types = this.evaluateNode(xPath, COMMENT_XPATH, xmlResource, resourceManager);
        if (types != null && (text2 = types.getNodeValue()).length() > 0) {
            return text2;
        }
        Node resultsetComment = this.evaluateNode(xPath, RESULT_SET_COMMENT_XPATH, xmlResource, resourceManager);
        if (resultsetComment != null && (text = resultsetComment.getNodeValue()).length() > 0) {
            return text;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeList evaluateNodeList(XPath xpath, String xpathQuery, ResourceData xmlResourceData, ResourceManager resourceManager) throws XPathExpressionException, ResourceLoadingException, IOException {
        InputStream stream = xmlResourceData.getResourceAsStream(resourceManager);
        try {
            NodeList nodeList = (NodeList)xpath.evaluate(xpathQuery, new InputSource(stream), XPathConstants.NODESET);
            return nodeList;
        }
        finally {
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node evaluateNode(XPath xpath, String xpathQuery, ResourceData xmlResourceData, ResourceManager resourceManager) throws XPathExpressionException, ResourceLoadingException, IOException {
        InputStream stream = xmlResourceData.getResourceAsStream(resourceManager);
        try {
            Node node = (Node)xpath.evaluate(xpathQuery, new InputSource(stream), XPathConstants.NODE);
            return node;
        }
        finally {
            stream.close();
        }
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex < this.columnTypes.size()) {
            return this.columnTypes.get(columnIndex);
        }
        return String.class;
    }

    @Override
    public int getRowCount() {
        return this.backend.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.backend.getColumnCount();
    }

    @Override
    public String getColumnName(int column) {
        return this.backend.getColumnName(column);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.backend.getValueAt(rowIndex, columnIndex);
    }

    static {
        HashMap<String, Class<Long>> types = new HashMap<String, Class<Long>>();
        types.put("java.lang.String", String.class);
        types.put("java.sql.Date", Date.class);
        types.put("java.math.BigDecimal", BigDecimal.class);
        types.put("java.sql.Timestamp", Timestamp.class);
        types.put("java.lang.Integer", Integer.class);
        types.put("java.lang.Double", Double.class);
        types.put("java.lang.Long", Long.class);
        SUPPORTED_TYPES = Collections.unmodifiableMap(types);
    }

    private static class InternalXPathVariableResolver
    implements XPathVariableResolver {
        private final DataRow parameters;

        private InternalXPathVariableResolver(DataRow parameters) {
            this.parameters = parameters;
        }

        @Override
        public Object resolveVariable(QName variableName) {
            if (this.parameters != null) {
                String var = variableName.getLocalPart();
                return this.parameters.get(var);
            }
            return null;
        }
    }
}

