/*
 * Decompiled with CFR 0.152.
 */
package com.debortoliwines.openerp.api;

import com.debortoliwines.openerp.api.Field;
import com.debortoliwines.openerp.api.FieldCollection;
import com.debortoliwines.openerp.api.FilterCollection;
import com.debortoliwines.openerp.api.OpenERPCommand;
import com.debortoliwines.openerp.api.OpeneERPApiException;
import com.debortoliwines.openerp.api.Row;
import com.debortoliwines.openerp.api.RowCollection;
import com.debortoliwines.openerp.api.SelectionOption;
import com.debortoliwines.openerp.api.Session;
import com.debortoliwines.openerp.api.helpers.FilterHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.xmlrpc.XmlRpcException;

public class ObjectAdapter {
    private final String objectName;
    private final OpenERPCommand commands;
    private final FieldCollection allFields;
    private static ArrayList<String> objectList = new ArrayList();
    private HashMap<String, HashMap<String, String>> modelNameCache = new HashMap();

    public ObjectAdapter(Session session, String objectName) throws XmlRpcException, OpeneERPApiException {
        this.commands = session.getOpenERPCommand();
        this.objectName = objectName;
        ObjectAdapter.objectExists(this.commands, this.objectName);
        this.allFields = this.getFields();
    }

    private static synchronized void objectExists(OpenERPCommand commands, String objectName) throws OpeneERPApiException {
        if (objectList.size() == 0) {
            try {
                Object[] result;
                Object[] ids = commands.searchObject("ir.model", new Object[0]);
                for (Object row : result = commands.readObject("ir.model", ids, new String[]{"model"})) {
                    objectList.add(((HashMap)row).get("model").toString());
                }
            }
            catch (XmlRpcException e) {
                throw new OpeneERPApiException("Could not validate model name: ", e);
            }
        }
        if (objectList.indexOf(objectName) < 0) {
            throw new OpeneERPApiException("Could not find model with name '" + objectName + "'");
        }
    }

    public Row getNewRow(FieldCollection fields) throws XmlRpcException, OpeneERPApiException {
        Row row = new Row(new HashMap<String, Object>(), fields);
        return row;
    }

    public Row getNewRow(String[] fields) throws XmlRpcException, OpeneERPApiException {
        FieldCollection fieldCol = this.getFields(fields);
        Row row = new Row(new HashMap<String, Object>(), fieldCol);
        return row;
    }

    public RowCollection readObject(Object[] ids, String[] fields) throws XmlRpcException, OpeneERPApiException {
        FieldCollection fieldCol = new FieldCollection();
        for (String fieldName : fields) {
            for (Field fld : this.allFields) {
                if (!fld.getName().equals(fieldName)) continue;
                fieldCol.add(fld);
            }
        }
        Object[] results = this.commands.readObject(this.objectName, ids, fields);
        RowCollection rows = new RowCollection(results, fieldCol);
        return rows;
    }

    public FieldCollection getFields() throws XmlRpcException {
        return this.getFields(new String[0]);
    }

    public String[] getFieldNames() throws XmlRpcException {
        FieldCollection fields = this.getFields(new String[0]);
        String[] fieldNames = new String[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            fieldNames[i] = ((Field)fields.get(i)).getName();
        }
        return fieldNames;
    }

    public FieldCollection getFields(String[] filterFields) throws XmlRpcException {
        FieldCollection collection = new FieldCollection();
        HashMap<String, Object> fields = this.commands.getFields(this.objectName, filterFields);
        for (String fieldName : fields.keySet()) {
            HashMap fieldDetails = (HashMap)fields.get(fieldName);
            collection.add(new Field(fieldName, fieldDetails));
        }
        return collection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object[] validateFilters(FilterCollection filters) throws OpeneERPApiException {
        if (filters == null) {
            return new Object[0];
        }
        ArrayList<Object> processedFilters = new ArrayList<Object>();
        for (int i = 0; i < filters.getFilters().length; ++i) {
            Object filter = filters.getFilters()[i];
            if (filter == null) {
                throw new OpeneERPApiException("The first filter parameter is mandatory");
            }
            if (filter instanceof String) {
                String operator = filter.toString();
                if (operator.equals((Object)FilterCollection.FilterOperator.AND)) continue;
                if (operator.equals((Object)FilterCollection.FilterOperator.OR) && filters.getFilters().length <= i + 2) {
                    throw new OpeneERPApiException("Logical operator OR needs two parameters.  Please read the OpenERP help.");
                }
                if (operator.equals((Object)FilterCollection.FilterOperator.NOT) && filters.getFilters().length <= i + 1) {
                    throw new OpeneERPApiException("Logical operator NOT needs one parameter.  Please read the OpenERP help.");
                }
                processedFilters.add(operator);
                continue;
            }
            if (!(filter instanceof Object[]) && ((Object[])filter).length != 3) {
                throw new OpeneERPApiException("Filters aren't in the correct format.  Please read the OpenERP help.");
            }
            String fieldName = ((Object[])filter)[0].toString();
            String comparison = ((Object[])filter)[1].toString();
            Object value = ((Object[])filter)[2];
            Field fld = null;
            for (int j = 0; j < this.allFields.size(); ++j) {
                if (!((Field)this.allFields.get(j)).getName().equals(fieldName)) continue;
                fld = (Field)this.allFields.get(j);
                break;
            }
            if (fld != null && fld.getFunc_method()) {
                throw new OpeneERPApiException("Can not search on function field " + fieldName);
            }
            if (!fieldName.equals("id") && fld == null) {
                throw new OpeneERPApiException("Unknow filter field " + fieldName);
            }
            if (comparison.equals("is null")) {
                comparison = "=";
                value = false;
            } else if (comparison.equals("is not null")) {
                comparison = "!=";
                value = false;
            } else if (fld != null && fld.getType() == Field.FieldType.BOOLEAN && !(value instanceof Boolean)) {
                if (value instanceof String) {
                    char firstchar = value.toString().toLowerCase().charAt(0);
                    if (firstchar == '1' || firstchar == 'y' || firstchar == 't') {
                        value = true;
                    } else {
                        if (firstchar != '0' && firstchar != 'n' && firstchar != 'f') throw new OpeneERPApiException("Unknown boolean " + value.toString());
                        value = false;
                    }
                }
            } else if (fld != null && fld.getType() == Field.FieldType.FLOAT && !(value instanceof Double)) {
                value = Double.parseDouble(value.toString());
            } else if (comparison.equals("=")) {
                if (!(value instanceof Integer) && (fieldName.equals("id") || fld != null && fld.getType() == Field.FieldType.INTEGER && !(value instanceof Integer) || fld != null && fld.getType() == Field.FieldType.MANY2ONE && !(value instanceof Integer))) {
                    value = Integer.parseInt(value.toString());
                }
            } else if (comparison.equalsIgnoreCase("in")) {
                if (value instanceof String) {
                    String[] entries = value.toString().split("(?<!\\\\),");
                    Object[] valueArr = new Object[entries.length];
                    for (int entrIdx = 0; entrIdx < entries.length; ++entrIdx) {
                        String entry = FilterHelper.csvDecodeString(entries[entrIdx]);
                        valueArr[entrIdx] = fld != null && (fld.getType() == Field.FieldType.INTEGER || fld.getType() == Field.FieldType.ONE2MANY || fld.getType() == Field.FieldType.MANY2MANY || fld.getType() == Field.FieldType.MANY2ONE) || fieldName.equals("id") ? Integer.valueOf(Integer.parseInt(entry)) : entry;
                    }
                    value = valueArr;
                } else if (!(value instanceof Object[])) {
                    value = new Object[]{value};
                }
            }
            processedFilters.add(new Object[]{fieldName, comparison, value});
        }
        return processedFilters.toArray(new Object[processedFilters.size()]);
    }

    private Object[] fixImportData(Row inputRow) throws OpeneERPApiException, XmlRpcException {
        Object[] outputRow = new Object[inputRow.getFields().size() + 1];
        outputRow[0] = inputRow.get("id");
        outputRow[0] = outputRow[0] == null ? Integer.valueOf(0) : Integer.valueOf(Integer.parseInt(inputRow.get("id").toString()));
        block4: for (int i = 0; i < inputRow.getFields().size(); ++i) {
            Object value;
            int columnIndex = i + 1;
            Field fld = (Field)inputRow.getFields().get(i);
            String fieldName = fld.getName();
            outputRow[columnIndex] = value = inputRow.get(fieldName);
            if (fld.getType() == Field.FieldType.MANY2ONE) {
                if (value == null) {
                    outputRow[columnIndex] = 0;
                    continue;
                }
                outputRow[columnIndex] = Integer.parseInt(value.toString());
                continue;
            }
            if (value == null) {
                outputRow[columnIndex] = false;
                continue;
            }
            value = this.formatValueForWrite(fld, value);
            switch (fld.getType()) {
                case SELECTION: {
                    boolean validValue = false;
                    for (SelectionOption option : fld.getSelectionOptions()) {
                        if (option.code.equals(value.toString())) {
                            validValue = true;
                            outputRow[columnIndex] = option.value;
                            break;
                        }
                        if (!option.value.equals(value.toString())) continue;
                        outputRow[columnIndex] = value;
                        validValue = true;
                        break;
                    }
                    if (validValue) continue block4;
                    throw new OpeneERPApiException("Could not find a valid value for section field " + fieldName + " with value " + value);
                }
                case MANY2MANY: {
                    HashMap<Object, Object> idToName = null;
                    if (!this.modelNameCache.containsKey(fld.getRelation())) {
                        idToName = new HashMap();
                        Object[] ids = this.commands.searchObject(fld.getRelation(), new Object[0]);
                        Object[] names = this.commands.nameGet(fld.getRelation(), ids);
                        for (int j = 0; j < ids.length; ++j) {
                            Object[] nameValue = (Object[])names[j];
                            idToName.put(nameValue[0].toString(), nameValue[1].toString());
                        }
                        this.modelNameCache.put(fld.getRelation(), idToName);
                    } else {
                        idToName = this.modelNameCache.get(fld.getRelation());
                    }
                    String newValue = "";
                    if (value instanceof String) {
                        for (String string : value.toString().split(",")) {
                            if (!idToName.containsKey(string)) {
                                throw new OpeneERPApiException("Could not find " + fld.getRelation() + " with ID " + (String)string);
                            }
                            newValue = newValue + "," + (String)idToName.get(string);
                        }
                    } else {
                        for (Object object : (Object[])value) {
                            if (!idToName.containsKey(object.toString())) {
                                throw new OpeneERPApiException("Could not find " + fld.getRelation() + " with ID " + object.toString());
                            }
                            newValue = newValue + "," + (String)idToName.get(object.toString());
                        }
                    }
                    outputRow[columnIndex] = newValue.substring(1);
                    continue block4;
                }
                default: {
                    outputRow[columnIndex] = value.toString();
                }
            }
        }
        return outputRow;
    }

    private String[] getFieldListForImport(FieldCollection currentFields) {
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.add(".id");
        for (Field field : currentFields) {
            if (field.getType() == Field.FieldType.MANY2ONE) {
                fieldList.add(field.getName() + ".id");
                continue;
            }
            fieldList.add(field.getName());
        }
        return fieldList.toArray(new String[fieldList.size()]);
    }

    public boolean importData(RowCollection rows) throws OpeneERPApiException, XmlRpcException {
        this.modelNameCache.clear();
        String[] targetFieldList = this.getFieldListForImport(((Row)rows.get(0)).getFields());
        Object[][] importRows = new Object[rows.size()][];
        for (int i = 0; i < rows.size(); ++i) {
            Row row = (Row)rows.get(i);
            importRows[i] = this.fixImportData(row);
        }
        Object[] result = this.commands.importData(this.objectName, targetFieldList, importRows);
        if ((Integer)result[0] != importRows.length) {
            throw new OpeneERPApiException(result[2].toString() + "\nRow :" + result[1].toString() + "");
        }
        return true;
    }

    public int getObjectCount(FilterCollection filter) throws XmlRpcException, OpeneERPApiException {
        Object[] preparedFilters = this.validateFilters(filter);
        return Integer.parseInt(this.commands.searchObject(this.objectName, preparedFilters, -1, -1, null, true).toString());
    }

    public RowCollection searchAndReadObject(FilterCollection filter, String[] fields) throws XmlRpcException, OpeneERPApiException {
        return this.searchAndReadObject(filter, fields, -1, -1, "");
    }

    public RowCollection searchAndReadObject(FilterCollection filter, String[] fields, int offset, int limit, String order) throws XmlRpcException, OpeneERPApiException {
        String[] fieldArray = fields == null ? new String[]{} : fields;
        Object[] preparedFilters = this.validateFilters(filter);
        Object[] idList = (Object[])this.commands.searchObject(this.objectName, preparedFilters, offset, limit, order, false);
        return this.readObject(idList, fieldArray);
    }

    private Object formatValueForWrite(Field fld, Object value) {
        if (value == null) {
            return false;
        }
        switch (fld.getType()) {
            case BOOLEAN: {
                value = (Boolean)value;
                break;
            }
            case FLOAT: {
                value = Double.parseDouble(value.toString());
                break;
            }
            case MANY2ONE: {
                value = Double.valueOf(value.toString()).intValue();
                break;
            }
            case MANY2MANY: {
                if (!(value instanceof Object[])) break;
                value = new Object[][]{{6, 0, (Object[])value}};
                break;
            }
            case ONE2MANY: 
            case INTEGER: {
                value = Double.valueOf(value.toString()).intValue();
                break;
            }
            default: {
                value = value.toString();
            }
        }
        return value;
    }

    public Boolean[] writeObject(RowCollection rows, boolean changesOnly) throws OpeneERPApiException, XmlRpcException {
        Boolean[] returnValues = new Boolean[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            returnValues[i] = this.writeObject((Row)rows.get(i), changesOnly);
        }
        return returnValues;
    }

    public boolean writeObject(Row row, boolean changesOnly) throws OpeneERPApiException, XmlRpcException {
        HashMap<String, Object> valueList = new HashMap<String, Object>();
        Object idObj = row.get("id");
        if (idObj == null || Integer.parseInt(idObj.toString()) <= 0) {
            throw new OpeneERPApiException("Please set the id field with the database ID of the object");
        }
        int id = Integer.parseInt(idObj.toString());
        if (changesOnly) {
            for (Field fld : row.getChangedFields()) {
                valueList.put(fld.getName(), this.formatValueForWrite(fld, row.get(fld)));
            }
        } else {
            for (Field fld : row.getFields()) {
                valueList.put(fld.getName(), this.formatValueForWrite(fld, row.get(fld)));
            }
        }
        if (valueList.size() == 0) {
            return false;
        }
        boolean success = this.commands.writeObject(this.objectName, id, valueList);
        if (success) {
            row.changesApplied();
        }
        return success;
    }

    public void createObject(Row row) throws OpeneERPApiException, XmlRpcException {
        HashMap<String, Object> valueList = new HashMap<String, Object>();
        for (Field fld : row.getFields()) {
            valueList.put(fld.getName(), this.formatValueForWrite(fld, row.get(fld)));
        }
        if (valueList.size() == 0) {
            throw new OpeneERPApiException("Row doesn't have any fields to update");
        }
        Object id = this.commands.createObject(this.objectName, valueList);
        row.put("id", id);
        row.changesApplied();
    }

    public FieldCollection callFieldsFunction(String functionName, Object[] parameters) throws XmlRpcException, OpeneERPApiException {
        Object[] results = this.commands.callObjectFunction(this.objectName, functionName, parameters);
        FieldCollection fieldCol = new FieldCollection();
        if (results.length > 0) {
            HashMap rowMap = (HashMap)results[0];
            for (String field : rowMap.keySet()) {
                HashMap<String, Object> fldDetails = null;
                if (rowMap.get(field) instanceof HashMap) {
                    try {
                        fldDetails = (HashMap)rowMap.get(field);
                    }
                    catch (Exception e) {
                        fldDetails = null;
                    }
                }
                if (fldDetails == null) {
                    fldDetails = new HashMap<String, Object>();
                }
                if (!fldDetails.containsKey("name")) {
                    fldDetails.put("name", field);
                }
                if (!fldDetails.containsKey("description")) {
                    fldDetails.put("description", field);
                }
                if (!fldDetails.containsKey("type")) {
                    Class<?> type = rowMap.get(field).getClass();
                    if (type == String.class) {
                        fldDetails.put("type", "char");
                    } else if (type == Date.class) {
                        fldDetails.put("type", "date");
                    } else if (type == Boolean.class) {
                        fldDetails.put("type", "boolean");
                    } else if (type == Double.class) {
                        fldDetails.put("type", "float");
                    } else if (type == Integer.class) {
                        fldDetails.put("type", "integer");
                    } else {
                        fldDetails.put("type", "char");
                    }
                }
                fieldCol.add(new Field(field, fldDetails));
            }
        }
        return fieldCol;
    }

    public RowCollection callFunction(String functionName, Object[] parameters, FieldCollection fieldCol) throws XmlRpcException, OpeneERPApiException {
        Object[] results = this.commands.callObjectFunction(this.objectName, functionName, parameters);
        if (fieldCol == null) {
            fieldCol = this.callFieldsFunction(functionName, parameters);
        }
        RowCollection rows = new RowCollection(results, fieldCol);
        return rows;
    }
}

