/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BaseEngineException;
import org.apache.oozie.DagEngineException;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JMSTopicService;
import org.apache.oozie.service.Services;

public abstract class BaseEngine {
    public static final String USE_XCOMMAND = "oozie.useXCommand";
    protected String user;

    public String getUser() {
        return this.user;
    }

    public abstract String submitJob(Configuration var1, boolean var2) throws BaseEngineException;

    public abstract void start(String var1) throws BaseEngineException;

    public abstract void resume(String var1) throws BaseEngineException;

    public abstract void suspend(String var1) throws BaseEngineException;

    public abstract void kill(String var1) throws BaseEngineException;

    public abstract void change(String var1, String var2) throws BaseEngineException;

    public abstract void reRun(String var1, Configuration var2) throws BaseEngineException;

    public abstract WorkflowJob getJob(String var1) throws BaseEngineException;

    public abstract WorkflowJob getJob(String var1, int var2, int var3) throws BaseEngineException;

    public abstract CoordinatorJob getCoordJob(String var1) throws BaseEngineException;

    public abstract CoordinatorJob getCoordJob(String var1, String var2, int var3, int var4, boolean var5) throws BaseEngineException;

    public abstract String getDefinition(String var1) throws BaseEngineException;

    public abstract void streamLog(String var1, Writer var2, Map<String, String[]> var3) throws IOException, BaseEngineException;

    public abstract String getJobIdForExternalId(String var1) throws BaseEngineException;

    public abstract String dryRunSubmit(Configuration var1) throws BaseEngineException;

    public String getJMSTopicName(String jobId) throws DagEngineException {
        JMSTopicService jmsTopicService = Services.get().get(JMSTopicService.class);
        if (jmsTopicService != null) {
            try {
                return jmsTopicService.getTopic(jobId);
            }
            catch (JPAExecutorException e) {
                throw new DagEngineException(ErrorCode.E1602, e);
            }
        }
        throw new DagEngineException(ErrorCode.E1602, "JMSTopicService is not initialized. JMS notificationmay not be enabled");
    }
}

