/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.oozie.action.hadoop.LauncherMapper;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.URIHandlerService;
import org.apache.oozie.util.XLog;

public class LauncherMapperHelper {
    public static String getRecoveryId(Configuration launcherConf, Path actionDir, String recoveryId) throws HadoopAccessorException, IOException {
        String jobId = null;
        Path recoveryFile = new Path(actionDir, recoveryId);
        FileSystem fs = Services.get().get(HadoopAccessorService.class).createFileSystem(launcherConf.get("user.name"), recoveryFile.toUri(), launcherConf);
        if (fs.exists(recoveryFile)) {
            FSDataInputStream is = fs.open(recoveryFile);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is));
            jobId = reader.readLine();
            reader.close();
        }
        return jobId;
    }

    public static void setupMainClass(Configuration launcherConf, String javaMainClass) {
        if (javaMainClass != null && !javaMainClass.equals("")) {
            launcherConf.set("oozie.launcher.action.main.class", javaMainClass);
        }
    }

    public static void setupLauncherURIHandlerConf(Configuration launcherConf) {
        for (Map.Entry entry : Services.get().get(URIHandlerService.class).getLauncherConfig()) {
            launcherConf.set((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static void setupMainArguments(Configuration launcherConf, String[] args) {
        launcherConf.setInt("oozie.action.main.arg.count", args.length);
        for (int i = 0; i < args.length; ++i) {
            launcherConf.set("oozie.action.main.arg." + i, args[i]);
        }
    }

    public static void setupMaxOutputData(Configuration launcherConf, int maxOutputData) {
        launcherConf.setInt("oozie.action.max.output.data", maxOutputData);
    }

    public static void setupMaxExternalStatsSize(Configuration launcherConf, int maxStatsData) {
        launcherConf.setInt("oozie.external.stats.max.size", maxStatsData);
    }

    public static void setupLauncherInfo(JobConf launcherConf, String jobId, String actionId, Path actionDir, String recoveryId, Configuration actionConf, String prepareXML) throws IOException, HadoopAccessorException {
        launcherConf.setMapperClass(LauncherMapper.class);
        launcherConf.setSpeculativeExecution(false);
        launcherConf.setNumMapTasks(1);
        launcherConf.setNumReduceTasks(0);
        launcherConf.set("oozie.job.id", jobId);
        launcherConf.set("oozie.action.id", actionId);
        launcherConf.set("oozie.action.dir.path", actionDir.toString());
        launcherConf.set("oozie.action.recovery.id", recoveryId);
        launcherConf.set("oozie.action.prepare.xml", prepareXML);
        actionConf.set("oozie.job.id", jobId);
        actionConf.set("oozie.action.id", actionId);
        if (Services.get().getConf().getBoolean("oozie.hadoop-2.0.2-alpha.workaround.for.distributed.cache", false)) {
            ArrayList<String> purgedEntries = new ArrayList<String>();
            Collection entries = actionConf.getStringCollection("mapreduce.job.cache.files");
            for (String entry : entries) {
                if (!entry.contains("#")) continue;
                purgedEntries.add(entry);
            }
            actionConf.setStrings("mapreduce.job.cache.files", purgedEntries.toArray(new String[purgedEntries.size()]));
            launcherConf.setBoolean("oozie.hadoop-2.0.2-alpha.workaround.for.distributed.cache", true);
        }
        FileSystem fs = Services.get().get(HadoopAccessorService.class).createFileSystem(launcherConf.get("user.name"), actionDir.toUri(), (Configuration)launcherConf);
        fs.mkdirs(actionDir);
        FSDataOutputStream os = fs.create(new Path(actionDir, "action.xml"));
        actionConf.writeXml((OutputStream)os);
        os.close();
        Path inputDir = new Path(actionDir, "input");
        fs.mkdirs(inputDir);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(new Path(inputDir, "dummy.txt")));
        writer.write("dummy");
        ((Writer)writer).close();
        launcherConf.set("mapred.input.dir", inputDir.toString());
        launcherConf.set("mapred.output.dir", new Path(actionDir, "output").toString());
    }

    public static boolean isMainDone(RunningJob runningJob) throws IOException {
        return runningJob.isComplete();
    }

    public static boolean isMainSuccessful(RunningJob runningJob) throws IOException {
        Counters.Group group;
        Counters counters;
        boolean succeeded = runningJob.isSuccessful();
        if (succeeded && (counters = runningJob.getCounters()) != null && (group = counters.getGroup("oozie.launcher")) != null) {
            succeeded = group.getCounter("oozie.launcher.error") == 0L;
        }
        return succeeded;
    }

    public static boolean hasOutputData(RunningJob runningJob) throws IOException {
        Counters.Group group;
        boolean output = false;
        Counters counters = runningJob.getCounters();
        if (counters != null && (group = counters.getGroup("oozie.launcher")) != null) {
            output = group.getCounter("oozie.output.data") == 1L;
        }
        return output;
    }

    public static boolean hasStatsData(RunningJob runningJob) throws IOException {
        Counters.Group group;
        boolean output = false;
        Counters counters = runningJob.getCounters();
        if (counters != null && (group = counters.getGroup("oozie.launcher")) != null) {
            output = group.getCounter("oozie.stats.data") == 1L;
        }
        return output;
    }

    public static boolean hasIdSwap(RunningJob runningJob) throws IOException {
        Counters.Group group;
        boolean swap = false;
        Counters counters = runningJob.getCounters();
        if (counters != null && (group = counters.getGroup("oozie.launcher")) != null) {
            swap = group.getCounter("oozie.do.id.swap") == 1L;
        }
        return swap;
    }

    public static boolean hasIdSwap(RunningJob runningJob, String user, String group, Path actionDir) throws IOException, HadoopAccessorException {
        boolean swap = false;
        XLog log = XLog.getLog("org.apache.oozie.action.hadoop.LauncherMapper");
        Counters counters = runningJob.getCounters();
        if (counters != null) {
            Counters.Group counterGroup = counters.getGroup("oozie.launcher");
            if (counterGroup != null) {
                swap = counterGroup.getCounter("oozie.do.id.swap") == 1L;
            }
        } else {
            Path p = LauncherMapperHelper.getIdSwapPath(actionDir);
            HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
            JobConf conf = has.createJobConf(p.toUri().getAuthority());
            FileSystem fs = has.createFileSystem(user, p.toUri(), (Configuration)conf);
            if (fs.exists(p)) {
                log.debug("Hadoop Counters is null, but found newID file.");
                swap = true;
            } else {
                log.debug("Hadoop Counters is null, and newID file doesn't exist at: [{0}]", p);
            }
        }
        return swap;
    }

    public static Path getOutputDataPath(Path actionDir) {
        return new Path(actionDir, "output.properties");
    }

    public static Path getActionStatsDataPath(Path actionDir) {
        return new Path(actionDir, "stats.properties");
    }

    public static Path getExternalChildIDsDataPath(Path actionDir) {
        return new Path(actionDir, "externalChildIds.properties");
    }

    public static Path getErrorPath(Path actionDir) {
        return new Path(actionDir, "error.properties");
    }

    public static Path getIdSwapPath(Path actionDir) {
        return new Path(actionDir, "newId.properties");
    }
}

