/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.dependency.hcat;

import java.util.List;
import java.util.Map;
import javax.jms.Message;
import org.apache.hcatalog.messaging.AddPartitionMessage;
import org.apache.hcatalog.messaging.HCatEventMessage;
import org.apache.hcatalog.messaging.jms.MessagingUtils;
import org.apache.oozie.jms.MessageHandler;
import org.apache.oozie.service.PartitionDependencyManagerService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.XLog;

public class HCatMessageHandler
implements MessageHandler {
    private static XLog LOG = XLog.getLog(HCatMessageHandler.class);
    private final String server;
    private final PartitionDependencyManagerService pdmService;

    public HCatMessageHandler(String server) {
        this.server = server;
        this.pdmService = Services.get().get(PartitionDependencyManagerService.class);
    }

    @Override
    public void process(Message msg) {
        try {
            HCatEventMessage hcatMsg = MessagingUtils.getMessage((Message)msg);
            if (hcatMsg.getEventType().equals((Object)HCatEventMessage.EventType.ADD_PARTITION)) {
                AddPartitionMessage partMsg = (AddPartitionMessage)hcatMsg;
                String db = partMsg.getDB();
                String table = partMsg.getTable();
                LOG.info("Partition available event: db [{0}]  table [{1}] partitions [{2}]", db, table, partMsg.getPartitions());
                List partitions = partMsg.getPartitions();
                for (int i = 0; i < partitions.size(); ++i) {
                    this.pdmService.partitionAvailable(this.server, db, table, (Map)partitions.get(i));
                }
            } else {
                LOG.debug("Ignoring message of event type [{0}] ", hcatMsg.getEventType());
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error processing JMS message", e);
        }
    }
}

