/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.FaultInjection;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class CoordJobsDeleteJPAExecutor
implements JPAExecutor<Integer> {
    private Collection<String> deleteList;

    public CoordJobsDeleteJPAExecutor(Collection<String> deleteList) {
        this.deleteList = deleteList;
    }

    public CoordJobsDeleteJPAExecutor() {
    }

    public void setDeleteList(Collection<String> deleteList) {
        this.deleteList = deleteList;
    }

    @Override
    public String getName() {
        return "CoordJobsDeleteJPAExecutor";
    }

    @Override
    public Integer execute(EntityManager em) throws JPAExecutorException {
        int actionsDeleted = 0;
        try {
            FaultInjection.activate("org.apache.oozie.command.SkipCommitFaultInjection");
            if (this.deleteList != null) {
                for (String id : this.deleteList) {
                    ParamChecker.notNull(id, "Coordinator Job Id");
                    Query q = em.createNamedQuery("DELETE_COORD_JOB");
                    q.setParameter("id", (Object)id);
                    q.executeUpdate();
                    Query g = em.createNamedQuery("DELETE_ACTIONS_FOR_COORDINATOR");
                    g.setParameter("jobId", (Object)id);
                    actionsDeleted = g.executeUpdate();
                }
            }
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
        return actionsDeleted;
    }
}

