/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.oozie.command.coord.CoordActionUpdatePushMissingDependency;
import org.apache.oozie.dependency.hcat.HCatDependencyCache;
import org.apache.oozie.dependency.hcat.SimpleHCatDependencyCache;
import org.apache.oozie.service.CallableQueueService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.HCatURI;
import org.apache.oozie.util.XLog;

public class PartitionDependencyManagerService
implements Service {
    public static final String CONF_PREFIX = "oozie.service.PartitionDependencyManagerService.";
    public static final String CACHE_MANAGER_IMPL = "oozie.service.PartitionDependencyManagerService.cache.manager.impl";
    private static XLog LOG = XLog.getLog(PartitionDependencyManagerService.class);
    private HCatDependencyCache dependencyCache;

    @Override
    public void init(Services services) throws ServiceException {
        this.init(services.getConf());
    }

    private void init(Configuration conf) throws ServiceException {
        Class defaultClass = conf.getClass(CACHE_MANAGER_IMPL, null);
        this.dependencyCache = defaultClass == null ? new SimpleHCatDependencyCache() : (HCatDependencyCache)ReflectionUtils.newInstance((Class)defaultClass, null);
        this.dependencyCache.init(conf);
        LOG.info("PartitionDependencyManagerService initialized. Dependency cache is {0} ", this.dependencyCache.getClass().getName());
    }

    @Override
    public void destroy() {
        this.dependencyCache.destroy();
    }

    @Override
    public Class<? extends Service> getInterface() {
        return PartitionDependencyManagerService.class;
    }

    public void addMissingDependency(HCatURI hcatURI, String actionID) {
        this.dependencyCache.addMissingDependency(hcatURI, actionID);
    }

    public boolean removeMissingDependency(HCatURI hcatURI, String actionID) {
        return this.dependencyCache.removeMissingDependency(hcatURI, actionID);
    }

    public Collection<String> getWaitingActions(HCatURI hcatURI) {
        return this.dependencyCache.getWaitingActions(hcatURI);
    }

    public void partitionAvailable(String server, String db, String table, Map<String, String> partitions) {
        Collection<String> actionsWithAvailableDep = this.dependencyCache.markDependencyAvailable(server, db, table, partitions);
        if (actionsWithAvailableDep != null) {
            for (String actionID : actionsWithAvailableDep) {
                boolean ret = Services.get().get(CallableQueueService.class).queue(new CoordActionUpdatePushMissingDependency(actionID), 100L);
                if (ret) continue;
                XLog.getLog(this.getClass()).warn("Unable to queue the callable commands for PartitionDependencyManagerService for actionID " + actionID + ".Most possibly command queue is full. Queue size is :" + Services.get().get(CallableQueueService.class).queueSize());
            }
        }
    }

    public Collection<String> getAvailableDependencyURIs(String actionID) {
        return this.dependencyCache.getAvailableDependencyURIs(actionID);
    }

    public boolean removeAvailableDependencyURIs(String actionID, Collection<String> dependencyURIs) {
        return this.dependencyCache.removeAvailableDependencyURIs(actionID, dependencyURIs);
    }
}

