/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements;

import java.util.ArrayList;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.actions.elements.AbstractLayerAction;
import org.pentaho.reporting.designer.core.editor.groups.EditGroupsUndoEntry;
import org.pentaho.reporting.designer.core.editor.groups.GroupDataEntry;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.undo.BandedSubreportEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.CompoundUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.DataSourceEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.ElementEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.ExpressionAddedUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.ExpressionRemoveUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.ParameterEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.AbstractRootLevelBand;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionCollection;
import org.pentaho.reporting.engine.classic.core.parameters.ModifiableReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;

public final class LayerBottomAction
extends AbstractLayerAction {
    public LayerBottomAction() {
        this.putValue("Name", ActionMessages.getString("LayerBottomAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("LayerBottomAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("LayerBottomAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("LayerBottomAction.Accelerator"));
        this.putValue("SmallIcon", IconLoader.getInstance().getLayerDownIcon());
    }

    @Override
    protected UndoEntry moveGroup(RelationalGroup designerGroupElement) throws CloneNotSupportedException {
        if (!this.isSingleElementSelection()) {
            return null;
        }
        AbstractReportDefinition reportDefinition = this.getActiveContext().getReportDefinition();
        GroupDataEntry[] entries = EditGroupsUndoEntry.buildGroupData(reportDefinition);
        ArrayList<GroupDataEntry> list = new ArrayList<GroupDataEntry>(entries.length);
        int index = -1;
        for (int i = 0; i < entries.length; ++i) {
            GroupDataEntry entry = entries[i];
            list.add(entry);
            if (designerGroupElement.getObjectID() != entry.getInstanceID()) continue;
            index = i;
        }
        if (index == -1 || index == list.size() - 1) {
            return null;
        }
        GroupDataEntry o = (GroupDataEntry)list.get(index);
        list.remove(index);
        list.add(0, o);
        GroupDataEntry[] changedEntries = list.toArray(new GroupDataEntry[list.size()]);
        EditGroupsUndoEntry.applyGroupData(reportDefinition, changedEntries);
        return new EditGroupsUndoEntry(entries, changedEntries);
    }

    @Override
    protected UndoEntry moveVisualElement(AbstractReportDefinition report, Element element) {
        int i;
        int count;
        Section reportElement = element.getParentSection();
        if (!(reportElement instanceof Band)) {
            return null;
        }
        if (element instanceof SubReport && reportElement instanceof AbstractRootLevelBand) {
            AbstractRootLevelBand re = (AbstractRootLevelBand)reportElement;
            count = re.getSubReportCount();
            for (i = 1; i < count; ++i) {
                SubReport sr = re.getSubReport(i);
                if (sr != element) continue;
                re.removeSubreport(sr);
                re.addSubReport(0, sr);
                return new CompoundUndoEntry(new BandedSubreportEditUndoEntry(re.getObjectID(), i, sr, null), new BandedSubreportEditUndoEntry(re.getObjectID(), 0, null, sr));
            }
        }
        Band parentBand = (Band)reportElement;
        count = parentBand.getElementCount();
        for (i = 1; i < count; ++i) {
            Element visualReportElement = parentBand.getElement(i);
            if (element != visualReportElement) continue;
            parentBand.removeElement(visualReportElement);
            parentBand.addElement(0, visualReportElement);
            return new CompoundUndoEntry(new ElementEditUndoEntry(parentBand.getObjectID(), i, visualReportElement, null), new ElementEditUndoEntry(parentBand.getObjectID(), 0, null, visualReportElement));
        }
        return null;
    }

    @Override
    protected UndoEntry moveExpressions(AbstractReportDefinition report, Object element) {
        ExpressionCollection expressionCollection = report.getExpressions();
        Expression[] expressions = expressionCollection.getExpressions();
        for (int j = 0; j < expressions.length - 1; ++j) {
            Expression expression = expressions[j];
            if (element != expression) continue;
            expressionCollection.removeExpression(j);
            expressionCollection.add(expression);
            report.fireModelLayoutChanged((ReportElement)report, 3, (Object)expression);
            return new CompoundUndoEntry(new ExpressionRemoveUndoEntry(j, expression), new ExpressionAddedUndoEntry(expressionCollection.getExpressions().length - 1, expression));
        }
        return null;
    }

    @Override
    protected UndoEntry moveDataFactories(AbstractReportDefinition report, Object element) throws ReportDataFactoryException {
        CompoundDataFactory collection = (CompoundDataFactory)report.getDataFactory();
        int dataFactoryCount = collection.size();
        for (int j = 0; j < dataFactoryCount - 1; ++j) {
            DataFactory dataFactory = collection.getReference(j);
            if (element != dataFactory) continue;
            collection.remove(j);
            collection.add(dataFactory);
            report.fireModelLayoutChanged((ReportElement)report, 3, (Object)dataFactory);
            return new CompoundUndoEntry(new DataSourceEditUndoEntry(j, dataFactory, null), new DataSourceEditUndoEntry(collection.size() - 1, null, dataFactory));
        }
        return null;
    }

    @Override
    protected UndoEntry moveParameters(AbstractReportDefinition report, Object element) {
        if (!(report instanceof MasterReport)) {
            return null;
        }
        MasterReport mr = (MasterReport)report;
        ReportParameterDefinition definition = mr.getParameterDefinition();
        if (!(definition instanceof ModifiableReportParameterDefinition)) {
            return null;
        }
        ModifiableReportParameterDefinition dpd = (ModifiableReportParameterDefinition)definition;
        ParameterDefinitionEntry[] entries = dpd.getParameterDefinitions();
        for (int i = 0; i < entries.length - 1; ++i) {
            ParameterDefinitionEntry entry = entries[i];
            if (element != entry) continue;
            dpd.removeParameterDefinition(i);
            dpd.addParameterDefinition(entry);
            report.fireModelLayoutChanged((ReportElement)report, 3, (Object)entry);
            return new CompoundUndoEntry(new ParameterEditUndoEntry(i, entry, null), new ParameterEditUndoEntry(dpd.getParameterDefinitions().length - 1, null, entry));
        }
        return null;
    }

    @Override
    protected boolean collectChange(Object[] selectedElements, AbstractReportDefinition report, ArrayList<UndoEntry> undos) {
        for (int i = selectedElements.length - 1; i >= 0; --i) {
            Object element = selectedElements[i];
            if (this.move(element, report, undos)) continue;
            return false;
        }
        return true;
    }
}

