/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.global.units;

import java.awt.event.ActionEvent;
import org.pentaho.reporting.designer.core.actions.AbstractDesignerContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.actions.ToggleStateAction;
import org.pentaho.reporting.designer.core.settings.SettingsListener;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.Unit;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public abstract class SetUnitAction
extends AbstractDesignerContextAction
implements ToggleStateAction,
SettingsListener {
    private Unit unit;

    protected SetUnitAction(Unit unit) {
        if (unit == null) {
            throw new NullPointerException();
        }
        this.unit = unit;
        this.putValue("Name", ActionMessages.getString("SetUnitAction.Text", unit.ordinal()));
        this.putValue("ShortDescription", ActionMessages.getString("SetUnitAction.Description", unit.ordinal()));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("SetUnitAction.Text"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("SetUnitAction.Accelerator"));
        WorkspaceSettings.getInstance().addSettingsListener(this);
        this.settingsChanged();
    }

    @Override
    public boolean isSelected() {
        return Boolean.TRUE.equals(this.getValue("SwingSelectedKey"));
    }

    public void setSelected(boolean selected) {
        this.putValue("SwingSelectedKey", selected);
    }

    @Override
    public void settingsChanged() {
        this.putValue("SwingSelectedKey", ObjectUtilities.equal((Object)((Object)this.unit), (Object)((Object)WorkspaceSettings.getInstance().getUnit())));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        WorkspaceSettings.getInstance().setUnit(this.unit);
    }
}

