/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.fieldselector;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.UIManager;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.fieldselector.FieldSelectorPanel;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.designtime.swing.MacOSXIntegration;

public class FieldSelectorPaletteDialog
extends JDialog {
    private FieldSelectorPanel fieldSelectorPanel;

    public FieldSelectorPaletteDialog(Frame parent, ReportDesignerContext designerContext) {
        super(parent);
        this.init(designerContext);
    }

    protected void init(ReportDesignerContext designerContext) {
        this.setResizable(true);
        this.addWindowListener(new FrameSizeMonitor());
        if (MacOSXIntegration.MAC_OS_X) {
            this.getRootPane().putClientProperty("Window.style", "small");
        } else if (UIManager.getLookAndFeel().getSupportsWindowDecorations()) {
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(2);
        }
        this.setTitle(Messages.getString("FieldSelectorPaletteDialog.Title", new Object[0]));
        this.setDefaultCloseOperation(1);
        this.fieldSelectorPanel = new FieldSelectorPanel();
        this.fieldSelectorPanel.setReportDesignerContext(designerContext);
        this.setContentPane(this.fieldSelectorPanel);
    }

    public void initWindowLocation() {
        Rectangle bounds;
        Rectangle rectangle = WorkspaceSettings.getInstance().getFieldPaletteBounds();
        if (rectangle != null && (rectangle.contains(bounds = this.fieldSelectorPanel.getReportDesignerContext().getView().getParent().getBounds()) || rectangle.equals(bounds))) {
            DebugLog.log((Object)("Found a usable screen-configuration: Restoring frame to " + bounds));
            this.setBounds(bounds);
            this.setVisible(true);
            return;
        }
        this.pack();
        LibSwingUtil.centerDialogInParent((Dialog)this);
    }

    private class FrameSizeMonitor
    extends WindowAdapter {
        private FrameSizeMonitor() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            WorkspaceSettings.getInstance().setFieldPaletteBounds(FieldSelectorPaletteDialog.this.getBounds());
            WorkspaceSettings.getInstance().setFieldSelectorVisible(false);
        }
    }
}

