/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.format;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.editor.format.BorderPropertiesPane;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.TextWrap;
import org.pentaho.reporting.engine.classic.core.style.VerticalTextAlign;
import org.pentaho.reporting.engine.classic.core.style.WhitespaceCollapse;
import org.pentaho.reporting.libraries.designtime.swing.KeyedComboBoxModel;
import org.pentaho.reporting.tools.configeditor.util.VerticalLayout;

public class ParagraphPropertiesPane
extends JPanel {
    private JRadioButton leftAlignButton;
    private JRadioButton centerAlignButton;
    private JRadioButton rightAlignButton;
    private JRadioButton topAlignButton;
    private JRadioButton middleAlignButton;
    private JRadioButton bottomAlignButton;
    private JTextField lineHeightField;
    private JCheckBox wrapTextCheckbox;
    private KeyedComboBoxModel whitespaceModel;
    private KeyedComboBoxModel textAlignModel;

    public ParagraphPropertiesPane() {
        this.setLayout((LayoutManager)new VerticalLayout());
        this.leftAlignButton = new JRadioButton(Messages.getString("ParagraphPropertiesPane.Left", new Object[0]));
        this.centerAlignButton = new JRadioButton(Messages.getString("ParagraphPropertiesPane.Center", new Object[0]));
        this.rightAlignButton = new JRadioButton(Messages.getString("ParagraphPropertiesPane.Right", new Object[0]));
        ButtonGroup halignGroup = new ButtonGroup();
        halignGroup.add(this.leftAlignButton);
        halignGroup.add(this.centerAlignButton);
        halignGroup.add(this.rightAlignButton);
        this.topAlignButton = new JRadioButton(Messages.getString("ParagraphPropertiesPane.Top", new Object[0]));
        this.middleAlignButton = new JRadioButton(Messages.getString("ParagraphPropertiesPane.Middle", new Object[0]));
        this.bottomAlignButton = new JRadioButton(Messages.getString("ParagraphPropertiesPane.Bottom", new Object[0]));
        ButtonGroup valignGroup = new ButtonGroup();
        valignGroup.add(this.topAlignButton);
        valignGroup.add(this.middleAlignButton);
        valignGroup.add(this.bottomAlignButton);
        this.textAlignModel = this.createTextAlignmentModel();
        this.whitespaceModel = this.createWhitspaceModel();
        JComboBox textAlignmentComboBox = new JComboBox(this.textAlignModel);
        this.wrapTextCheckbox = new JCheckBox(Messages.getString("ParagraphPropertiesPane.AllowTextWrapping", new Object[0]));
        this.lineHeightField = new JTextField();
        this.lineHeightField.setColumns(10);
        JComboBox whitespaceComboBox = new JComboBox(this.whitespaceModel);
        JPanel halignPanel = new JPanel();
        halignPanel.setLayout((LayoutManager)new VerticalLayout());
        halignPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ParagraphPropertiesPane.HorizontalAlignment", new Object[0])));
        halignPanel.add(this.leftAlignButton);
        halignPanel.add(this.centerAlignButton);
        halignPanel.add(this.rightAlignButton);
        JPanel valignPanel = new JPanel();
        valignPanel.setLayout((LayoutManager)new VerticalLayout());
        valignPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ParagraphPropertiesPane.VerticalAlignment", new Object[0])));
        valignPanel.add(this.topAlignButton);
        valignPanel.add(this.middleAlignButton);
        valignPanel.add(this.bottomAlignButton);
        JPanel textToTextPanel = new JPanel();
        textToTextPanel.setLayout(new GridBagLayout());
        textToTextPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ParagraphPropertiesPane.TextToTextAlignment", new Object[0])));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        textToTextPanel.add((Component)new JLabel(Messages.getString("ParagraphPropertiesPane.Alignment", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        textToTextPanel.add(textAlignmentComboBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        textToTextPanel.add((Component)new JLabel(Messages.getString("ParagraphPropertiesPane.LineHeight", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        textToTextPanel.add((Component)this.lineHeightField, gbc);
        JPanel whitespacePanel = new JPanel();
        whitespacePanel.setLayout(new GridBagLayout());
        whitespacePanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ParagraphPropertiesPane.WhitespaceProcessing", new Object[0])));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        whitespacePanel.add((Component)this.wrapTextCheckbox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        whitespacePanel.add((Component)new JLabel(Messages.getString("ParagraphPropertiesPane.WhitespaceProcessing", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        whitespacePanel.add(whitespaceComboBox, gbc);
        this.add(halignPanel);
        this.add(valignPanel);
        this.add(textToTextPanel);
        this.add(whitespacePanel);
    }

    private KeyedComboBoxModel createTextAlignmentModel() {
        KeyedComboBoxModel model = new KeyedComboBoxModel();
        model.add((Object)VerticalTextAlign.TOP, (Object)Messages.getString("ParagraphPropertiesPane.Top", new Object[0]));
        model.add((Object)VerticalTextAlign.CENTRAL, (Object)Messages.getString("ParagraphPropertiesPane.Central", new Object[0]));
        model.add((Object)VerticalTextAlign.MIDDLE, (Object)Messages.getString("ParagraphPropertiesPane.Middle", new Object[0]));
        model.add((Object)VerticalTextAlign.BASELINE, (Object)Messages.getString("ParagraphPropertiesPane.Baseline", new Object[0]));
        model.add((Object)VerticalTextAlign.USE_SCRIPT, (Object)Messages.getString("ParagraphPropertiesPane.UseScript", new Object[0]));
        model.add((Object)VerticalTextAlign.TEXT_TOP, (Object)Messages.getString("ParagraphPropertiesPane.TextTop", new Object[0]));
        model.add((Object)VerticalTextAlign.TEXT_BOTTOM, (Object)Messages.getString("ParagraphPropertiesPane.TextBottom", new Object[0]));
        model.add((Object)VerticalTextAlign.SUB, (Object)Messages.getString("ParagraphPropertiesPane.Subscript", new Object[0]));
        model.add((Object)VerticalTextAlign.SUPER, (Object)Messages.getString("ParagraphPropertiesPane.Superscript", new Object[0]));
        model.add((Object)VerticalTextAlign.BOTTOM, (Object)Messages.getString("ParagraphPropertiesPane.Bottom", new Object[0]));
        return model;
    }

    private KeyedComboBoxModel createWhitspaceModel() {
        KeyedComboBoxModel model = new KeyedComboBoxModel();
        model.add((Object)WhitespaceCollapse.COLLAPSE, (Object)Messages.getString("ParagraphPropertiesPane.CollapseWhitespaces", new Object[0]));
        model.add((Object)WhitespaceCollapse.DISCARD, (Object)Messages.getString("ParagraphPropertiesPane.DiscardAllWhitespaces", new Object[0]));
        model.add((Object)WhitespaceCollapse.PRESERVE, (Object)Messages.getString("ParagraphPropertiesPane.PreserveAllWhitespaces", new Object[0]));
        model.add((Object)WhitespaceCollapse.PRESERVE_BREAKS, (Object)Messages.getString("ParagraphPropertiesPane.PreserveBreaks", new Object[0]));
        return model;
    }

    public void initializeFromStyle(ElementStyleSheet styleSheet) {
        ElementAlignment halign = (ElementAlignment)styleSheet.getStyleProperty(ElementStyleKeys.ALIGNMENT);
        if (ElementAlignment.LEFT.equals((Object)halign)) {
            this.leftAlignButton.setSelected(true);
        } else if (ElementAlignment.CENTER.equals((Object)halign)) {
            this.centerAlignButton.setSelected(true);
        } else {
            this.rightAlignButton.setSelected(true);
        }
        ElementAlignment valign = (ElementAlignment)styleSheet.getStyleProperty(ElementStyleKeys.VALIGNMENT);
        if (ElementAlignment.BOTTOM.equals((Object)valign)) {
            this.bottomAlignButton.setSelected(true);
        } else if (ElementAlignment.MIDDLE.equals((Object)valign)) {
            this.middleAlignButton.setSelected(true);
        } else {
            this.topAlignButton.setSelected(true);
        }
        this.wrapTextCheckbox.setSelected(TextWrap.WRAP.equals(styleSheet.getStyleProperty(TextStyleKeys.TEXT_WRAP)));
        this.lineHeightField.setText(BorderPropertiesPane.printLength((Number)styleSheet.getStyleProperty(TextStyleKeys.LINEHEIGHT)));
        this.textAlignModel.setSelectedKey(styleSheet.getStyleProperty(TextStyleKeys.VERTICAL_TEXT_ALIGNMENT));
        this.whitespaceModel.setSelectedKey(styleSheet.getStyleProperty(TextStyleKeys.WHITE_SPACE_COLLAPSE));
    }

    public void commitValues(ElementStyleSheet styleSheet) {
        if (this.centerAlignButton.isSelected()) {
            styleSheet.setStyleProperty(ElementStyleKeys.ALIGNMENT, (Object)ElementAlignment.CENTER);
        } else if (this.rightAlignButton.isSelected()) {
            styleSheet.setStyleProperty(ElementStyleKeys.ALIGNMENT, (Object)ElementAlignment.RIGHT);
        } else {
            styleSheet.setStyleProperty(ElementStyleKeys.ALIGNMENT, (Object)ElementAlignment.LEFT);
        }
        if (this.middleAlignButton.isSelected()) {
            styleSheet.setStyleProperty(ElementStyleKeys.VALIGNMENT, (Object)ElementAlignment.MIDDLE);
        } else if (this.bottomAlignButton.isSelected()) {
            styleSheet.setStyleProperty(ElementStyleKeys.VALIGNMENT, (Object)ElementAlignment.BOTTOM);
        } else {
            styleSheet.setStyleProperty(ElementStyleKeys.VALIGNMENT, (Object)ElementAlignment.TOP);
        }
        styleSheet.setStyleProperty(TextStyleKeys.VERTICAL_TEXT_ALIGNMENT, this.textAlignModel.getSelectedKey());
        styleSheet.setStyleProperty(TextStyleKeys.LINEHEIGHT, (Object)BorderPropertiesPane.parseLength(this.lineHeightField.getText()));
        if (this.wrapTextCheckbox.isSelected()) {
            styleSheet.setStyleProperty(TextStyleKeys.TEXT_WRAP, (Object)TextWrap.WRAP);
        } else {
            styleSheet.setStyleProperty(TextStyleKeys.TEXT_WRAP, (Object)TextWrap.NONE);
        }
        styleSheet.setStyleProperty(TextStyleKeys.WHITE_SPACE_COLLAPSE, this.whitespaceModel.getSelectedKey());
    }
}

