/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report;

import java.awt.Point;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.geom.Point2D;
import java.util.Locale;
import javax.swing.JComponent;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.report.DndElementOverlay;
import org.pentaho.reporting.designer.core.editor.report.ReportElementDragHandler;
import org.pentaho.reporting.designer.core.editor.report.ReportElementEditorContext;
import org.pentaho.reporting.designer.core.model.CachedLayoutData;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.undo.ElementEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoManager;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;

public abstract class AbstractReportElementDragHandler
implements ReportElementDragHandler {
    protected static final Float DEFAULT_WIDTH = new Float(100.0f);
    protected static final Float DEFAULT_HEIGHT = new Float(20.0f);
    private DndElementOverlay representation = new DndElementOverlay();

    protected DndElementOverlay getRepresentation() {
        return this.representation;
    }

    @Override
    public int dragStarted(DropTargetDragEvent event, ReportElementEditorContext dragContext, ElementMetaData elementMetaData, String fieldName) {
        JComponent representationContainer = dragContext.getRepresentationContainer();
        ReportDocumentContext renderContext = dragContext.getRenderContext();
        Point pos = event.getLocation();
        Point2D point = dragContext.normalize(pos);
        if (point.getX() < 0.0 || point.getY() < 0.0) {
            representationContainer.removeAll();
            return 0;
        }
        if (this.isFilteredDropZone(event, dragContext, elementMetaData, point)) {
            representationContainer.removeAll();
            return 0;
        }
        this.representation.setZoom(renderContext.getZoomModel().getZoomAsPercentage());
        this.representation.setVisible(true);
        this.representation.setText(elementMetaData.getDisplayName(Locale.getDefault()));
        this.representation.setLocation(pos.x, pos.y);
        this.representation.setSize(100, 20);
        representationContainer.removeAll();
        representationContainer.add(this.representation);
        return 1;
    }

    protected boolean isFilteredDropZone(DropTargetEvent event, ReportElementEditorContext dragContext, ElementMetaData elementMetaData, Point2D point) {
        return false;
    }

    @Override
    public int dragUpdated(DropTargetDragEvent event, ReportElementEditorContext dragContext, ElementMetaData elementMetaData, String fieldName) {
        return this.dragStarted(event, dragContext, elementMetaData, fieldName);
    }

    @Override
    public void dragAborted(DropTargetEvent event, ReportElementEditorContext dragContext) {
        JComponent representationContainer = dragContext.getRepresentationContainer();
        representationContainer.removeAll();
    }

    @Override
    public void drop(DropTargetDropEvent event, ReportElementEditorContext dragContext, ElementMetaData elementMetaData, String fieldName) {
        try {
            Point2D point = dragContext.normalize(event.getLocation());
            if (this.isFilteredDropZone(event, dragContext, elementMetaData, point)) {
                event.dropComplete(false);
                return;
            }
            Band band = this.getInsertionBand(event, dragContext, point);
            if (band == null) {
                event.dropComplete(false);
                return;
            }
            ReportDocumentContext context = dragContext.getRenderContext();
            Element visualElement = this.createElement(elementMetaData, fieldName, context);
            ElementStyleSheet styleSheet = visualElement.getStyle();
            double parentX = this.getParentX((Section)band);
            double parentY = this.getParentY((Section)band);
            styleSheet.setStyleProperty(ElementStyleKeys.POS_X, (Object)new Float(Math.max(0.0, point.getX() - parentX)));
            styleSheet.setStyleProperty(ElementStyleKeys.POS_Y, (Object)new Float(Math.max(0.0, point.getY() - parentY)));
            this.postProcessDrop(visualElement, band, dragContext, point);
            dragContext.getRenderContext().getSelectionModel().setSelectedElements(new Object[]{visualElement});
            event.acceptDrop(1);
            this.getRepresentation().setVisible(false);
            dragContext.getRepresentationContainer().removeAll();
            event.dropComplete(true);
        }
        catch (Exception e) {
            UncaughtExceptionsModel.getInstance().addException(e);
            dragContext.getRepresentationContainer().removeAll();
            event.dropComplete(false);
        }
    }

    protected void postProcessDrop(Element visualElement, Band target, ReportElementEditorContext dragContext, Point2D point) {
        ReportDocumentContext context = dragContext.getRenderContext();
        UndoManager undo = context.getUndo();
        undo.addChange(Messages.getString("DefaultReportElementDragHandler.AddElementUndoEntry", new Object[0]), new ElementEditUndoEntry(target.getObjectID(), target.getElementCount(), null, visualElement));
        target.addElement(visualElement);
    }

    protected abstract Element createElement(ElementMetaData var1, String var2, ReportDocumentContext var3) throws InstantiationException;

    protected Band getInsertionBand(DropTargetDropEvent event, ReportElementEditorContext dragContext, Point2D point) {
        Element elementForLocation = dragContext.getElementForLocation(point, false);
        Object band = elementForLocation instanceof Band ? (Band)elementForLocation : (elementForLocation != null ? elementForLocation.getParent() : null);
        if (band == null) {
            Element defaultEntry = dragContext.getDefaultElement();
            if (!(defaultEntry instanceof Band)) {
                event.rejectDrop();
                dragContext.getRepresentationContainer().removeAll();
                return null;
            }
            band = (Band)defaultEntry;
        }
        return band;
    }

    protected double getParentX(Section band) {
        CachedLayoutData data = ModelUtility.getCachedLayoutData((Element)band);
        if (data.getLayoutAge() == -1L) {
            return this.getParentX(band.getParentSection());
        }
        return StrictGeomUtility.toExternalValue((long)data.getX());
    }

    protected double getParentY(Section band) {
        CachedLayoutData data = ModelUtility.getCachedLayoutData((Element)band);
        if (data.getLayoutAge() == -1L) {
            return this.getParentY(band.getParentSection());
        }
        return StrictGeomUtility.toExternalValue((long)data.getY());
    }
}

