/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.font.LineMetrics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class DndElementOverlay
extends JLabel {
    private float zoom;

    public DndElementOverlay() {
        this.setDoubleBuffered(true);
        this.setOpaque(false);
        this.zoom = 1.0f;
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        preferredSize.setSize(Math.ceil(preferredSize.getWidth() * (double)this.zoom), Math.ceil(preferredSize.getHeight() * (double)this.zoom));
        return preferredSize;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension preferredSize = super.getMaximumSize();
        preferredSize.setSize(Math.ceil(preferredSize.getWidth() * (double)this.zoom), Math.ceil(preferredSize.getHeight() * (double)this.zoom));
        return preferredSize;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension preferredSize = super.getMinimumSize();
        preferredSize.setSize(Math.ceil(preferredSize.getWidth() * (double)this.zoom), Math.ceil(preferredSize.getHeight() * (double)this.zoom));
        return preferredSize;
    }

    @Override
    public void paintComponent(Graphics g) {
        FontMetrics fontMetrics;
        Graphics2D g2 = (Graphics2D)g;
        g2.scale(this.zoom, this.zoom);
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setColor(this.getForeground());
        Icon icon = this.getIcon();
        int gap = this.getIconTextGap();
        String text = this.getText();
        Insets insets = this.getInsets();
        if (icon != null && text != null) {
            icon.paintIcon(this, g2, insets.left, insets.top);
            g2.setFont(this.getFont());
            fontMetrics = g2.getFontMetrics();
            LineMetrics lineMetrics = fontMetrics.getLineMetrics(text, g2);
            float baseLine = lineMetrics.getAscent();
            float iconWidth = icon.getIconWidth();
            float textX = (float)(insets.left + gap) + iconWidth;
            float iconHeight = icon.getIconHeight();
            float textY = (float)insets.top + baseLine + (iconHeight - lineMetrics.getHeight());
            g2.drawString(text, textX, textY);
        } else if (icon != null) {
            icon.paintIcon(this, g2, insets.left, insets.top);
        } else if (text != null) {
            g2.setFont(this.getFont());
            fontMetrics = g2.getFontMetrics();
            LineMetrics lineMetrics = fontMetrics.getLineMetrics(text, g2);
            float baseLine = lineMetrics.getAscent();
            int textX = insets.left;
            float textY = (float)insets.top + baseLine;
            g2.drawString(text, (float)textX, textY);
        }
        Border border = this.getBorder();
        if (border != null) {
            border.paintBorder(this, g2, 0, 0, (int)((float)this.getWidth() / this.zoom), (int)((float)this.getHeight() / this.zoom));
        }
        g2.dispose();
    }
}

