/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.report.OverlayRenderer;
import org.pentaho.reporting.designer.core.model.CachedLayoutData;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;

public class OverlappingElementOverlayRenderer
implements OverlayRenderer {
    private Element rootElement;
    private double zoomFactor;
    private Rectangle2D elementBounds = new Rectangle2D.Double();
    private double offset;

    public OverlappingElementOverlayRenderer(Element defaultElement) {
        this.rootElement = defaultElement;
    }

    @Override
    public void validate(ReportDocumentContext context, double zoomFactor, Point2D sectionOffset) {
        this.zoomFactor = zoomFactor;
        this.offset = sectionOffset.getY();
    }

    @Override
    public void draw(Graphics2D graphics, Rectangle2D bounds, ImageObserver obs) {
        if (!WorkspaceSettings.getInstance().isShowOverlappingElements()) {
            return;
        }
        graphics.translate(0.0, -(this.offset * this.zoomFactor));
        this.draw(this.rootElement, graphics);
    }

    private void draw(Element element, Graphics2D graphics2D) {
        CachedLayoutData layoutData = ModelUtility.getCachedLayoutData(element);
        if (layoutData.getLayoutAge() > -1L && layoutData.isConflictsInTableMode()) {
            double x = StrictGeomUtility.toExternalValue((long)layoutData.getX());
            double y = StrictGeomUtility.toExternalValue((long)layoutData.getY());
            double width = StrictGeomUtility.toExternalValue((long)layoutData.getWidth());
            double height = StrictGeomUtility.toExternalValue((long)layoutData.getHeight());
            this.elementBounds.setFrame(x * this.zoomFactor, y * this.zoomFactor, width * this.zoomFactor, height * this.zoomFactor);
            Color overlapErrorColor = WorkspaceSettings.getInstance().getOverlapErrorColor();
            Color highLight = new Color(overlapErrorColor.getRed(), overlapErrorColor.getGreen(), overlapErrorColor.getBlue(), 64);
            graphics2D.setPaint(highLight);
            graphics2D.fill(this.elementBounds);
        }
        if (element instanceof SubReport && element != this.rootElement) {
            return;
        }
        if (element instanceof Section) {
            Section section = (Section)element;
            int count = section.getElementCount();
            for (int i = 0; i < count; ++i) {
                Element e = section.getElement(i);
                if (!(e instanceof Element)) continue;
                this.draw(e, graphics2D);
            }
        }
    }
}

