/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report.snapping;

import java.util.ArrayList;
import org.pentaho.reporting.designer.core.editor.report.snapping.SnapPositionsModel;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class CompoundSnapModel
implements SnapPositionsModel {
    private ArrayList<SnapPositionsModel> snapModels = new ArrayList();
    private transient SnapPositionsModel[] snapModelsAsArray;

    public void add(SnapPositionsModel model) {
        if (model == null) {
            throw new NullPointerException();
        }
        this.snapModels.add(model);
    }

    public void remove(SnapPositionsModel model) {
        if (model == null) {
            throw new NullPointerException();
        }
        this.snapModels.remove(model);
    }

    @Override
    public long getNearestSnapPosition(long position, InstanceID owner) {
        if (this.snapModelsAsArray == null) {
            this.snapModelsAsArray = this.snapModels.toArray(new SnapPositionsModel[this.snapModels.size()]);
        }
        long retval = position;
        long delta = Long.MAX_VALUE;
        for (int i = 0; i < this.snapModelsAsArray.length; ++i) {
            SnapPositionsModel positionsModel = this.snapModelsAsArray[i];
            long snapPos = positionsModel.getNearestSnapPosition(position, owner);
            long newDelta = Math.abs(position - snapPos);
            if (newDelta >= delta) continue;
            retval = snapPos;
            delta = newDelta;
        }
        return retval;
    }
}

