/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.model;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.pentaho.reporting.designer.core.ReportDesignerBoot;
import org.pentaho.reporting.designer.core.model.CachedLayoutData;
import org.pentaho.reporting.designer.core.model.lineal.LinealModel;
import org.pentaho.reporting.designer.core.model.lineal.LinealModelEvent;
import org.pentaho.reporting.designer.core.model.lineal.LinealModelListener;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class ModelUtility {
    private static final String CACHED_LAYOUT_DATA = "CachedLayoutData";
    private static final String NUMBER_FORMAT_CONFIG_PREFIX = "NumberFormat.String.";
    private static final String DATE_FORMAT_CONFIG_PREFIX = "DateFormat.String.";

    private ModelUtility() {
    }

    public static boolean isHideInLayoutGui(RenderNode node) {
        Object attribute = node.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI");
        return attribute != null && Boolean.TRUE.equals(attribute);
    }

    public static boolean isHideInLayoutGui(ReportElement element) {
        Object attribute = element.getAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI");
        return attribute != null && Boolean.TRUE.equals(attribute);
    }

    public static LinealModel getVerticalLinealModel(Element rootBand) {
        Object maybeLinealModel = rootBand.getAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "lineal-model-object");
        if (maybeLinealModel instanceof LinealModel) {
            return (LinealModel)maybeLinealModel;
        }
        LinealModel verticalLinealModel = new LinealModel();
        Object attribute = rootBand.getAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "VerticalGuideLines");
        if (attribute instanceof String) {
            verticalLinealModel.parse(attribute.toString());
        }
        verticalLinealModel.addLinealModelListener(new LinealUpdateHandler(rootBand, verticalLinealModel, "VerticalGuideLines"));
        rootBand.setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "lineal-model-object", (Object)verticalLinealModel, false);
        return verticalLinealModel;
    }

    public static LinealModel getHorizontalLinealModel(AbstractReportDefinition rootBand) {
        Object maybeLinealModel = rootBand.getAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "lineal-model-object");
        if (maybeLinealModel instanceof LinealModel) {
            return (LinealModel)maybeLinealModel;
        }
        LinealModel linealModel = new LinealModel();
        Object attribute = rootBand.getAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "HorizontalGuideLines");
        if (attribute instanceof String) {
            linealModel.parse(attribute.toString());
        }
        linealModel.addLinealModelListener(new LinealUpdateHandler((Element)rootBand, linealModel, "HorizontalGuideLines"));
        rootBand.setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "lineal-model-object", (Object)linealModel, false);
        return linealModel;
    }

    public static CachedLayoutData getCachedLayoutData(Element element) {
        Object attribute = element.getAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", CACHED_LAYOUT_DATA);
        if (attribute instanceof CachedLayoutData) {
            return (CachedLayoutData)attribute;
        }
        CachedLayoutData retval = new CachedLayoutData();
        element.setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", CACHED_LAYOUT_DATA, (Object)retval, false);
        return retval;
    }

    public static boolean isDescendant(Section definition, ReportElement element) {
        for (ReportElement band = element; band != null; band = band.getParentSection()) {
            if (band != definition) continue;
            return true;
        }
        return false;
    }

    public static List<Element> filterParents(List<Element> elements) {
        if (elements.size() == 1) {
            return elements;
        }
        ArrayList<Element> retval = new ArrayList<Element>(elements.size());
        for (Element element : elements) {
            Section s;
            if (element instanceof Section && ModelUtility.isParentSection(s = (Section)element, elements)) continue;
            retval.add(element);
        }
        return retval;
    }

    private static boolean isParentSection(Section s, List<Element> elements) {
        for (Element potentialChild : elements) {
            if (potentialChild == s || !ModelUtility.isDescendant(s, (ReportElement)potentialChild)) continue;
            return true;
        }
        return false;
    }

    public static SubReport[] findSubReports(Section section) {
        ArrayList<SubReport> result = new ArrayList<SubReport>();
        ModelUtility.findSubReportsInteral(section, result);
        return result.toArray(new SubReport[result.size()]);
    }

    private static void findSubReportsInteral(Section section, ArrayList<SubReport> result) {
        int count = section.getElementCount();
        for (int i = 0; i < count; ++i) {
            Element element = section.getElement(i);
            if (!(element instanceof Section)) continue;
            ModelUtility.findSubReportsInteral((Section)element, result);
        }
        if (section instanceof SubReport) {
            result.add((SubReport)section);
        }
    }

    public static ReportElement findElementById(AbstractReportDefinition definition, InstanceID id) {
        return FunctionUtilities.findElementByInstanceId((ReportDefinition)definition, (InstanceID)id);
    }

    public static int findIndexOf(Section parent, Element visualElement) {
        int count = parent.getElementCount();
        for (int i = 0; i < count; ++i) {
            Element element = parent.getElement(i);
            if (element != visualElement) continue;
            return i;
        }
        return -1;
    }

    public static int findSubreportIndexOf(RootLevelBand parent, SubReport visualElement) {
        int count = parent.getSubReportCount();
        for (int i = 0; i < count; ++i) {
            SubReport element = parent.getSubReport(i);
            if (element != visualElement) continue;
            return i;
        }
        return -1;
    }

    public static String[] getGroups(AbstractReportDefinition reportDefinition) {
        String groupName;
        Group g;
        int i;
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        int count = reportDefinition.getGroupCount();
        for (i = 0; i < count; ++i) {
            g = reportDefinition.getGroup(i);
            groupName = g.getName();
            if (groupName == null) continue;
            groups.add(groupName);
        }
        for (i = 0; i < count; ++i) {
            g = reportDefinition.getGroup(i);
            groupName = g.getGeneratedName();
            if (groupName == null) continue;
            groups.add(groupName);
        }
        return groups.toArray(new String[groups.size()]);
    }

    public static String[] getNumberFormats() {
        return ModelUtility.getMessageSeries(NUMBER_FORMAT_CONFIG_PREFIX);
    }

    public static String[] getDateFormats() {
        return ModelUtility.getMessageSeries(DATE_FORMAT_CONFIG_PREFIX);
    }

    private static String[] getMessageSeries(String seriesPrefix) {
        ArrayList<String> stringSeries = new ArrayList<String>();
        int index = 0;
        Configuration configuration = ReportDesignerBoot.getInstance().getGlobalConfig();
        String message = configuration.getConfigProperty(seriesPrefix + index);
        while (message != null) {
            stringSeries.add(message);
            message = configuration.getConfigProperty(seriesPrefix + ++index);
        }
        return stringSeries.toArray(new String[stringSeries.size()]);
    }

    public static DataFactory findDataFactoryForQuery(AbstractReportDefinition definition, String query) {
        while (definition != null) {
            CompoundDataFactory cdf;
            DataFactory factoryForQuery;
            DataFactory dataFactory = definition.getDataFactory();
            if (dataFactory instanceof CompoundDataFactory && (factoryForQuery = (cdf = (CompoundDataFactory)dataFactory).getDataFactoryForQuery(query)) != null) {
                return factoryForQuery;
            }
            Section parentSection = definition.getParentSection();
            if (parentSection == null) {
                definition = null;
                continue;
            }
            definition = (AbstractReportDefinition)parentSection.getReportDefinition();
        }
        return null;
    }

    private static class LinealUpdateHandler
    implements LinealModelListener {
        private Element element;
        private LinealModel model;
        private String attribute;

        private LinealUpdateHandler(Element element, LinealModel model, String attribute) {
            this.element = element;
            this.model = model;
            this.attribute = attribute;
        }

        @Override
        public void modelChanged(LinealModelEvent event) {
            this.element.setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", this.attribute, (Object)this.model.externalize(), false);
        }
    }
}

