/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.model.data;

import akka.dispatch.OnFailure;
import akka.dispatch.OnSuccess;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pentaho.reporting.designer.core.model.data.ActorSystemHost;
import org.pentaho.reporting.designer.core.model.data.DataSchemaManager;
import org.pentaho.reporting.designer.core.model.data.QueryMetaDataActor;
import org.pentaho.reporting.designer.core.model.data.QueryMetaDataActorImpl;
import org.pentaho.reporting.designer.core.model.data.TemporaryDataSchemaModel;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.designtime.DefaultDesignTimeDataSchemaModelChangeTracker;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportModelListener;
import org.pentaho.reporting.engine.classic.core.wizard.ContextAwareDataSchemaModel;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import scala.PartialFunction;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;

public class AsynchronousDataSchemaManager
implements DataSchemaManager,
ReportModelListener {
    private final MasterReport masterReport;
    private final AbstractReportDefinition report;
    private final QueryMetaDataActor actor;
    private final ArrayList<ChangeListener> listeners;
    private final DefaultDesignTimeDataSchemaModelChangeTracker changeTracker;
    private ContextAwareDataSchemaModel model;

    public AsynchronousDataSchemaManager(MasterReport masterReport, AbstractReportDefinition report) {
        ArgumentNullException.validate((String)"masterReport", (Object)masterReport);
        ArgumentNullException.validate((String)"report", (Object)report);
        this.listeners = new ArrayList();
        this.actor = ActorSystemHost.INSTANCE.createActor(QueryMetaDataActor.class, QueryMetaDataActorImpl.class);
        this.masterReport = masterReport;
        this.report = report;
        this.report.addReportModelListener((ReportModelListener)this);
        this.changeTracker = new DefaultDesignTimeDataSchemaModelChangeTracker(report);
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        ArgumentNullException.validate((String)"l", (Object)l);
        this.listeners.add(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        ArgumentNullException.validate((String)"l", (Object)l);
        this.listeners.remove(l);
    }

    @Override
    public synchronized ContextAwareDataSchemaModel getModel() {
        if (this.model == null) {
            this.model = new TemporaryDataSchemaModel(this.masterReport, this.report);
            this.startQueryModel();
        }
        return this.model;
    }

    public synchronized void nodeChanged(ReportModelEvent event) {
        if (this.changeTracker.isReportChanged()) {
            this.model = new TemporaryDataSchemaModel(this.masterReport, this.report);
            this.startQueryModel();
        }
    }

    private synchronized void startQueryModel() {
        Future<ContextAwareDataSchemaModel> retrieve = this.actor.retrieve(this.masterReport, this.report);
        retrieve.onSuccess((PartialFunction)new SuccessHandler(), (ExecutionContext)ActorSystemHost.INSTANCE.getSystem().dispatcher());
        retrieve.onFailure((PartialFunction)new FailureHandler(), (ExecutionContext)ActorSystemHost.INSTANCE.getSystem().dispatcher());
    }

    @Override
    public void close() {
        ActorSystemHost.INSTANCE.stopNow(this.actor);
    }

    protected void fireChangeEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResultOnEDT(Runnable r) {
        AsynchronousDataSchemaManager asynchronousDataSchemaManager = this;
        synchronized (asynchronousDataSchemaManager) {
            this.changeTracker.updateChangeTrackers();
        }
        SwingUtilities.invokeLater(r);
    }

    private static class FailureTask
    implements Runnable {
        private Throwable t;

        private FailureTask(Throwable t) {
            ArgumentNullException.validate((String)"t", (Object)t);
            this.t = t;
        }

        @Override
        public void run() {
            UncaughtExceptionsModel.getInstance().addException(this.t);
        }
    }

    private class FailureHandler
    extends OnFailure
    implements PartialFunction<Throwable, BoxedUnit> {
        private FailureHandler() {
        }

        public void onFailure(Throwable failure) throws Throwable {
            AsynchronousDataSchemaManager.this.processResultOnEDT(new FailureTask(failure));
        }
    }

    private class SuccessTask
    implements Runnable {
        private ContextAwareDataSchemaModel model;

        private SuccessTask(ContextAwareDataSchemaModel model) {
            this.model = model;
        }

        @Override
        public void run() {
            AsynchronousDataSchemaManager.this.model = this.model;
            AsynchronousDataSchemaManager.this.fireChangeEvent();
        }
    }

    private class SuccessHandler
    extends OnSuccess<ContextAwareDataSchemaModel>
    implements PartialFunction<ContextAwareDataSchemaModel, BoxedUnit> {
        private SuccessHandler() {
        }

        public void onSuccess(ContextAwareDataSchemaModel result) throws Throwable {
            AsynchronousDataSchemaManager.this.processResultOnEDT(new SuccessTask(result));
        }
    }
}

