/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.settings.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.Scrollable;

public class ButtonTabbedPane
extends JPanel {
    private ArrayList<Component> settingPlugins = new ArrayList();
    private ArrayList<JToggleButton> settingsButtons = new ArrayList();
    private JPanel buttonPanel;
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private ButtonGroup panelButtons;

    public ButtonTabbedPane() {
        this.setLayout(new BorderLayout(0, 0));
        this.buttonPanel = new JPanel(new GridLayout(0, 1));
        this.panelButtons = new ButtonGroup();
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        ScrollablePanel buttonHelperPanel = new ScrollablePanel((LayoutManager)new BorderLayout());
        buttonHelperPanel.setOpaque(true);
        buttonHelperPanel.add((Component)this.buttonPanel, "North");
        JScrollPane scrollPane = new JScrollPane(buttonHelperPanel);
        scrollPane.setOpaque(false);
        scrollPane.setBorder(null);
        scrollPane.getViewport().setBorder(null);
        scrollPane.getViewport().setOpaque(false);
        JPanel buttonArea = new JPanel(new BorderLayout());
        buttonArea.add((Component)scrollPane, "Center");
        JPanel helperPanel = new JPanel(new BorderLayout());
        helperPanel.add((Component)buttonArea, "West");
        helperPanel.add(Box.createHorizontalStrut(5), "Center");
        this.add((Component)helperPanel, "West");
        this.add((Component)this.cardPanel, "Center");
    }

    public void showFirst() {
        if (!this.settingsButtons.isEmpty()) {
            this.settingsButtons.get(0).setSelected(true);
            this.cardLayout.first(this.cardPanel);
        }
    }

    public void addTab(Icon icon, String title, JComponent component) {
        String magicKey = String.valueOf(this.settingPlugins.size());
        this.settingPlugins.add(component);
        this.cardPanel.add((Component)component, magicKey);
        JToggleButton toggleButton = new JToggleButton(title, icon);
        toggleButton.setHorizontalTextPosition(0);
        toggleButton.setVerticalTextPosition(3);
        toggleButton.addActionListener(new SelectPanelAction(magicKey));
        this.panelButtons.add(toggleButton);
        this.settingsButtons.add(toggleButton);
        JPanel helperPanel = new JPanel(new BorderLayout());
        helperPanel.setOpaque(false);
        helperPanel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        helperPanel.add((Component)toggleButton, "Center");
        this.buttonPanel.add(helperPanel);
    }

    public int getCardCount() {
        return this.settingPlugins.size();
    }

    private class SelectPanelAction
    implements ActionListener {
        private final String magicKey;

        public SelectPanelAction(String magicKey) {
            this.magicKey = magicKey;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ButtonTabbedPane.this.cardLayout.show(ButtonTabbedPane.this.cardPanel, this.magicKey);
        }
    }

    private static class ScrollablePanel
    extends JPanel
    implements Scrollable {
        private ScrollablePanel(LayoutManager layout) {
            super(layout);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 20;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 20;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }
}

